package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.OperationState;
import com.ejianc.business.scene.util.OverdueState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scene.mapper.SceneCheckDetailMapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 检查单待检复检子表
 * 
 * @author generator
 * 
 */
@Service("sceneCheckDetailService")
public class SceneCheckDetailServiceImpl extends BaseServiceImpl<SceneCheckDetailMapper, SceneCheckDetailEntity> implements ISceneCheckDetailService{

    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;

    @Override
    public void checkDetailSubmitHandler(Long billId) {
        if(billId != null){
            //提交后，检查项的整改次数+1
            SceneCheckDetailEntity sceneCheckDetail = this.selectById(billId);
            LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckDetailEntity::getId,billId);
            updateWrapper.set(SceneCheckDetailEntity::getReformNumber,sceneCheckDetail.getReformNumber()+1);
            updateWrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REVIEW_REFORM_STATE.getDescription());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String reformNews = sceneCheckDetail.getCurrentRectificationPerson()+"-"+sdf.format(sceneCheckDetail.getReformDate())+"-整改完成请复查";
            updateWrapper.set(SceneCheckDetailEntity::getReformNews,reformNews);


            Date finishDate = sceneCheckDetail.getFinishDate();
            Date nowDate = new Date();
            String nowDateStr = sdf.format(nowDate);
            String finishDateStr = sdf.format(finishDate);
            //当前时间大于完成时间 逾期状态设置为1
            if(nowDateStr.compareTo(finishDateStr) > 0){
                updateWrapper.set(SceneCheckDetailEntity::getIsOverdue, Integer.parseInt(OverdueState.OVERDUE_STATE.getCode()));
            }else if(sceneCheckDetail.getIsOverdue()==null){
                //当前整改未逾期，且逾期状态为空时，设置默认逾期状态
                updateWrapper.set(SceneCheckDetailEntity::getIsOverdue, Integer.parseInt(OverdueState.NOTOVERDUE_STATE.getCode()));
            }

            this.update(updateWrapper);

            //生成整改信息
            SceneCheckRecordEntity sceneCheckRecord=new SceneCheckRecordEntity();
            sceneCheckRecord.setPid(sceneCheckDetail.getId());
            sceneCheckRecord.setCheckId(sceneCheckDetail.getPid());
            //设置操作状态
            sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REFORM_STATE.getCode()));
            sceneCheckRecord.setReviewPerson(sceneCheckDetail.getReviewPerson());
            sceneCheckRecord.setReviewDescribe(sceneCheckDetail.getReviewDescribe());
            sceneCheckRecord.setReviewResult(sceneCheckDetail.getReviewResult());
            sceneCheckRecord.setImgIds(sceneCheckDetail.getReformImgIds());
            sceneCheckRecord.setCheckPerson(sceneCheckDetail.getCheckPerson());
            sceneCheckRecord.setCheckItem(sceneCheckDetail.getCheckItem());
            sceneCheckRecord.setRectificationPerson(sceneCheckDetail.getCurrentRectificationPerson());
            sceneCheckRecord.setRectificationDescribe(sceneCheckDetail.getReformMsg());
            sceneCheckRecordService.save(sceneCheckRecord);

            //提交时要判断子表是否已经全部提交了，全部提交后把主表的复查状态设置为待复查
            int count = 0;
            QueryParam param = new QueryParam();
            param.getParams().put("pid",new Parameter(QueryParam.EQ,sceneCheckDetail.getPid()));
            List<SceneCheckDetailEntity> detailList = this.queryList(param);
            for (SceneCheckDetailEntity detailEntity:detailList) {
                if(detailEntity.getIsReform()==Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())){
                    count+=1;
                }
            }
            if(count == detailList.size()){
                LambdaUpdateWrapper<SceneCheckEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(SceneCheckEntity::getId,sceneCheckDetail.getPid());
                wrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_STATE.getCode()));
                wrapper.set(SceneCheckEntity::getReformFinishDate ,sdf.format(new Date()));
                service.update(wrapper);
            }

        }

    }
}
