package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Controller
@RequestMapping("reform")
@Api(value = "待复查", tags = {"检查单主子表"})
public class ReformController {


    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";//此处需要根据实际修改


    @ApiOperation("待复检查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckDetailVO> queryDetail(@RequestParam Long id) {
        SceneCheckDetailEntity entity = sceneCheckDetailService.selectById(id);
        //根据检查项id重新查询检查及复查整改记录数，根据创建时间倒序
        Long detailId = entity.getId();
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ, detailId));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<SceneCheckRecordEntity> sceneCheckRecordList = sceneCheckRecordService.queryList(param);
        entity.setSceneCheckRecords(sceneCheckRecordList);
        SceneCheckDetailVO vo = BeanMapper.map(entity, SceneCheckDetailVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询待整改单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkItem");
        fuzzyFields.add("checkPerson");
        fuzzyFields.add("checkName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的

        param.getParams().put("is_reform", new Parameter(QueryParam.IN, Arrays.asList(CheckItemReformState.REFORM_STATE.getCode(),CheckItemReformState.REFORM_FAILED_STATE.getCode())));
        param.getParams().put("rectification_id",new Parameter(QueryParam.LIKE,sessionManager.getUserContext().getUserId().toString()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));

        //IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<SceneCheckDetailEntity> page = sceneCheckDetailService.queryPage(param, false);
        IPage<SceneCheckDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckDetailVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckDetailVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SceneCheckDetailVO saveorUpdateVO) {
        SceneCheckDetailEntity entity = BeanMapper.map(saveorUpdateVO, SceneCheckDetailEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setIsReform(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
        }
        sceneCheckDetailService.saveOrUpdate(entity, false);
        SceneCheckDetailVO vo = BeanMapper.map(entity, SceneCheckDetailVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

}
