package com.ejianc.business.scene.controller;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;


@RestController
@RequestMapping(value = "/overdueWarn")
public class OverdueWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISceneCheckService service;

    @RequestMapping(value = "/overdue", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> overdue(HttpServletRequest request) {
        logger.info("接收到现场管理Task参数：{}", request);
        //修改逾期状态和检查结果状态描述
        service.updateSceneCheckOverdue();
        //修改逾期数量
        service.updateSceneCheckOverdueNumber();
        return CommonResponse.success("更新成功！");
    }
}
