/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.scene.util.NoticeEnum;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CheckMessageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weixin_template.check_id}")
    private String weixinCheckTemplateId;
    @Autowired
    private IPushMessageApi pushMessageApi;

    public CommonResponse<String> sendMsg(SceneCheckVO checkVO, String[] receivers, NoticeEnum notice) {
        if (checkVO != null) {
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("weixin");
            channel.add("sys");
            if (StringUtils.isNotBlank((CharSequence)this.weixinCheckTemplateId)) {
                HashMap<String, String> keyMap = new HashMap<String, String>();
                keyMap.put("#NUM#", checkVO.getReviewedNum() != null ? String.valueOf(checkVO.getReviewedNum()) : null);
                keyMap.put("#BILLCODE#", checkVO.getBillCode());
                keyMap.put("#CHECKNAME#", checkVO.getCheckName());
                keyMap.put("#ID#", String.valueOf(checkVO.getReviewedNum()));
                keyMap.put("#BASEHOST#", this.baseHost);
                NoticeEnum.instance((NoticeEnum)notice, keyMap);
                JSONObject weixinParams = new JSONObject();
                weixinParams.put("template_id", (Object)this.weixinCheckTemplateId);
                JSONObject wxparams = new JSONObject();
                wxparams.put("first", (Object)notice.getContent());
                wxparams.put("keyword1", (Object)notice.getKey1());
                wxparams.put("keyword2", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                weixinParams.put("data", (Object)wxparams);
                weixinParams.put("url", (Object)(notice.getUrl() + "&openid={openid}"));
                parameter.setWeixinParams(weixinParams);
            } else {
                this.logger.info("\u672a\u914d\u7f6e\u5fae\u4fe1\u516c\u4f17\u53f7\u6a21\u677f\uff0c\u6545\u4e0d\u53d1\u5fae\u4fe1\u516c\u4f17\u53f7\u6d88\u606f");
            }
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject(notice.getSubject());
            parameter.setContent(notice.getPcContent());
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }
}

