package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
@Service("sceneCheckService")
public class SceneCheckServiceImpl extends BaseServiceImpl<SceneCheckMapper, SceneCheckEntity> implements ISceneCheckService{

    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SceneCheckMapper sceneCheckMapper;
    @Autowired
    private CheckMessageService checkMessageService;

    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     *  检查单提交后的操作
     * @param billId 检查单id
     */
    @Override
    public void checkSubmitHandle(Long billId) {

        if(billId != null){
            SceneCheckEntity sceneCheckEntity = this.selectById(billId);

            //检查单提交后，修改复查状态为 1
            LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckEntity::getId,billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus,Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem,sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus,Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update(updateWrapper);

            //检查单提交后 检查项状态改为待整改
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d->{
                LambdaUpdateWrapper<SceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(SceneCheckDetailEntity::getId,d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_STATE.getDescription());
                sceneCheckDetailService.update(wrapper);
            });


            List<SceneCheckRecordEntity> list = new ArrayList<>();
            List<SceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            //检查单提交后，生成检查信息记录
            sceneCheckDetaillist.forEach(item->{
                SceneCheckRecordEntity sceneCheckRecord=new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                //设置操作状态
                sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getProblemImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            sceneCheckRecordService.saveBatch(list,list.size());



            SceneCheckVO vo = BeanMapper.map(sceneCheckEntity, SceneCheckVO.class);
            //待整改检查项发 送消息
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();
            if(StringUtils.isNotBlank(reformDutyId)){
                String[] reformDuty = reformDutyId.split(",");
                //发送消息给整改人
                vo.setMsgNum(vo.getSceneCheckDetails().size());
                checkMessageService.sendMsg(vo,reformDuty,NoticeEnum.CHECK_COMMIT_PASS);
            }
            if(StringUtils.isNotBlank(notifRelevantId)){
                String[] notifRelevant = notifRelevantId.split(",");
                //发送消息给需要通知人员
                vo.setMsgBillCode(vo.getBillCode());
                vo.setMsgId(vo.getId());
                checkMessageService.sendMsg(vo,notifRelevant,NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }


        }

    }

    /**
     * 检查单弃审前的操作
     * @param billId
     */
    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        //检查单弃审前，查询记录表中是否有整改记录
        SceneCheckEntity sceneCheckEntity = this.selectById(billId);
        QueryParam param = new QueryParam();
        /*LambdaUpdateWrapper<SceneCheckRecordEntity> wrapper = new LambdaUpdateWrapper<>();
        //检查单id
        wrapper.set(SceneCheckRecordEntity :: getCheckId,sceneCheckEntity.getId());
        //操作类型为：整改
        wrapper.set(SceneCheckRecordEntity :: getOperationType,Integer.parseInt(OperationState.REFORM_STATE.getCode()));*/

        param.getParams().put("checkId",new Parameter(QueryParam.EQ,sceneCheckEntity.getId()));
        param.getParams().put("operationType",new Parameter(QueryParam.EQ,Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List<SceneCheckRecordEntity> list = sceneCheckRecordService.queryList(param,false);
        //int count = sceneCheckRecordService.count(wrapper);
        if(list.size()>0){
            flag = false;
        }
        return flag;
    }

    /**
     * 检查单弃审后操作
     * @param billId 单据id
     */
    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if(billId != null){
            SceneCheckEntity sceneCheckEntity = this.selectById(billId);
            //检查单弃审后，修改复查状态为 0
            LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckEntity::getId,billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus,Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem,sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus,null);
            this.update(updateWrapper);

            //检查单弃审后 检查项状态改为默认值 0
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d->{
                LambdaUpdateWrapper<SceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(SceneCheckDetailEntity::getId,d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.DEFULT_STATE.getCode());
                sceneCheckDetailService.update(wrapper);
            });

            //检查单弃审后，要删除记录表中检查单的检查记录  检查单id 和 操作类型为检查
            LambdaUpdateWrapper<SceneCheckRecordEntity> deleteWrapper = new LambdaUpdateWrapper<>();
            deleteWrapper.set(SceneCheckRecordEntity :: getCheckId,sceneCheckEntity.getId());
            deleteWrapper.set(SceneCheckRecordEntity :: getOperationType,Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            sceneCheckRecordService.remove(deleteWrapper);
        }
    }

    @Override
    public void updateSceneCheckOverdue() {
        sceneCheckMapper.updateSceneCheckOverdue();
    }

    @Override
    public void updateSceneCheckOverdueNumber() {
      sceneCheckMapper.updateSceneCheckOverdueNumber();
    }
}
