/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckDetailMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.ModifyState;
import com.ejianc.business.scene.util.NoticeEnum;
import com.ejianc.business.scene.util.OperationState;
import com.ejianc.business.scene.util.OverdueState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.util.ReviewState;
import com.ejianc.business.scene.util.SubmitState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckRecordVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="sceneCheckDetailService")
public class SceneCheckDetailServiceImpl
extends BaseServiceImpl<SceneCheckDetailMapper, SceneCheckDetailEntity>
implements ISceneCheckDetailService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private CheckMessageService checkMessageService;
    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<SceneCheckDetailVO> insertOrUpdate(SceneCheckDetailVO saveorUpdateVO) {
        SceneCheckDetailEntity entity;
        block12: {
            entity = (SceneCheckDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SceneCheckDetailEntity.class));
            if (entity.getId() == null || entity.getId() == 0L) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setBillCode((String)billCode.getData());
                entity.setIsReform(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
            }
            if (saveorUpdateVO.getVersion() != null && saveorUpdateVO.getVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(saveorUpdateVO.getId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        JSONObject checkDetailEntity = this.commenQueryFieldsService.queryBillDetail(String.valueOf(saveorUpdateVO.getId()), "BT211018000000001");
                        String objVersion = checkDetailEntity.getJSONObject("data").get((Object)"version").toString();
                        Integer version = checkDetailEntity.getJSONObject("data").get((Object)"version") == null ? 0 : Integer.parseInt(objVersion.substring(0, objVersion.indexOf(".")));
                        if (version != (conVersion = saveorUpdateVO.getVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u68c0\u67e5\u9879\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u6574\u6539\uff01");
                            return commonResponse;
                        }
                        break block12;
                    }
                    CommonResponse checkDetailEntity = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return checkDetailEntity;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(saveorUpdateVO.getId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        super.saveOrUpdate((Object)entity, false);
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
        param.getOrderMap().put("createTime", "desc");
        List sceneCheckRecordList = this.sceneCheckRecordService.queryList(param, false);
        SceneCheckDetailVO vo = (SceneCheckDetailVO)BeanMapper.map((Object)((Object)entity), SceneCheckDetailVO.class);
        List sceneCheckRecordVO = BeanMapper.mapList((Iterable)sceneCheckRecordList, SceneCheckRecordVO.class);
        vo.setSceneCheckRecords(sceneCheckRecordVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)vo, SceneCheckDetailVO.class));
    }

    @Override
    public void checkDetailSubmitHandler(Long billId) {
        if (billId != null) {
            SceneCheckDetailEntity sceneCheckDetail = (SceneCheckDetailEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckDetailEntity::getReformNumber, (Object)(sceneCheckDetail.getReformNumber() + 1));
            updateWrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REVIEW_REFORM_STATE.getDescription());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String reformNews = sceneCheckDetail.getCurrentRectificationPerson() + "-" + sdf.format(sceneCheckDetail.getReformDate()) + "-" + sceneCheckDetail.getReformMsg();
            updateWrapper.set(SceneCheckDetailEntity::getReformNews, (Object)reformNews);
            updateWrapper.set(SceneCheckDetailEntity::getReviewResult, (Object)Integer.parseInt(ReviewState.REVIEW_STATE.getCode()));
            updateWrapper.set(SceneCheckDetailEntity::getIsModify, (Object)Integer.parseInt(ModifyState.NOT_MODIFIED_STATE.getCode()));
            Date finishDate = sceneCheckDetail.getFinishDate();
            Date nowDate = new Date();
            String nowDateStr = sdf.format(nowDate);
            String finishDateStr = sdf.format(finishDate);
            if (nowDateStr.compareTo(finishDateStr) > 0) {
                updateWrapper.set(SceneCheckDetailEntity::getIsOverdue, (Object)Integer.parseInt(OverdueState.OVERDUE_STATE.getCode()));
            } else if (sceneCheckDetail.getIsOverdue() == null) {
                updateWrapper.set(SceneCheckDetailEntity::getIsOverdue, (Object)Integer.parseInt(OverdueState.NOTOVERDUE_STATE.getCode()));
            }
            this.update((Wrapper)updateWrapper);
            SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
            sceneCheckRecord.setPid(sceneCheckDetail.getId());
            sceneCheckRecord.setCheckId(sceneCheckDetail.getPid());
            sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REFORM_STATE.getCode()));
            sceneCheckRecord.setReviewPerson(sceneCheckDetail.getReviewPerson());
            sceneCheckRecord.setReviewDescribe(sceneCheckDetail.getReviewDescribe());
            sceneCheckRecord.setReviewResult(sceneCheckDetail.getReviewResult());
            sceneCheckRecord.setImgIds(sceneCheckDetail.getReformImgIds());
            sceneCheckRecord.setCheckPerson(sceneCheckDetail.getCheckPerson());
            sceneCheckRecord.setCheckItem(sceneCheckDetail.getCheckItem());
            sceneCheckRecord.setRectificationPerson(sceneCheckDetail.getCurrentRectificationPerson());
            sceneCheckRecord.setRectificationDescribe(sceneCheckDetail.getReformMsg());
            this.sceneCheckRecordService.save((Object)sceneCheckRecord);
            int count = 0;
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter("eq", (Object)sceneCheckDetail.getPid()));
            List detailList = this.queryList(param);
            for (SceneCheckDetailEntity detailEntity : detailList) {
                if (detailEntity.getIsReform() != Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())) continue;
                ++count;
            }
            if (count == detailList.size()) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)sceneCheckDetail.getPid());
                wrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_STATE.getCode()));
                wrapper.set(SceneCheckEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
                wrapper.set(SceneCheckEntity::getReformFinishDate, (Object)sdf.format(new Date()));
                this.service.update((Wrapper)wrapper);
                SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.service.selectById(sceneCheckDetail.getPid()));
                SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)sceneCheckEntity), SceneCheckVO.class);
                String reviewId = vo.getReviewId();
                if (StringUtils.isNotBlank((String)reviewId)) {
                    String[] review = reviewId.split(",");
                    vo.setMsgNum(Integer.valueOf(0));
                    vo.setMsgId(vo.getId());
                    vo.setMsgBillCode(vo.getBillCode());
                    this.logger.info("\u5f85\u6574\u6539\u5168\u90e8\u63d0\u4ea4\u5f00\u59cb------------------------MsgId = " + sceneCheckDetail.getPid() + ",MsgBillCode = " + vo.getBillCode());
                    this.checkMessageService.sendMsg(vo, review, NoticeEnum.REFORM_COMMIT);
                }
            }
        }
    }
}

