package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("review")
@Api(value = "待复检", tags = {"检查单主子表"})
public class ReviewController {

    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Autowired
    private CheckMessageService checkMessageService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;



    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation("待复检查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = service.selectById(id);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<SceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails))
        {
            sceneCheckDetailVOList.forEach(item->{
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询待复检单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的
        param.getParams().put("reform_status", new Parameter(QueryParam.IN, Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_FAILED_STATE.getCode())));
        param.getParams().put("review_id", new Parameter(QueryParam.LIKE, sessionManager.getUserContext().getUserId().toString()));
        IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("提交复查信息")
    @RequestMapping(value = "/submitReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> submitReviewNews(@ApiParam(name = "submitReviewNews", required = true) @RequestBody SceneCheckVO param) {
        SceneCheckEntity entity = BeanMapper.map(param, SceneCheckEntity.class);
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SceneCheckEntity::getId, entity.getId());
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List<Integer> reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            //提交是否复查不合格的话
            List<SceneCheckRecordEntity> list = new ArrayList<>();
            List<SceneCheckDetailEntity> sceneCheckDetailList = null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                //复检不合格的话，把整改状态设置为3
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgId(entity.getId());
                vo.setMsgBillCode(entity.getBillCode());
                vo.setMsgNum(sceneCheckDetailList.size());
                String reformDutyId = vo.getReformDutyId();
                if (reformDutyId!=null){
                    String[] reformDutyIds = reformDutyId.split(",");
                    checkMessageService.sendMsg(vo,reformDutyIds,NoticeEnum.REVIEW_COMMIT_UNPASS);
                }
            }
            //合格的个数
            int size = reviewResults.stream().filter(reviewResult -> reviewResult == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size();
            //合格的数等于检查项的数 全部合格
            if (size == sceneCheckDetails.size()) {
                //全部合格的话，整改状态该为reformStatus 设置为4 全部完成
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                //设置复检信息
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgBillCode(entity.getBillCode());
                String notifRelevantId = vo.getNotifRelevantId();
                if (notifRelevantId!=null) {
                    String[] notifRelevantIds = notifRelevantId.split(",");
                    vo.setMsgId(entity.getId());
                    vo.setMsgNum(0);
                    checkMessageService.sendMsg(vo,notifRelevantIds,NoticeEnum.REVIEW_COMMIT_PASS);
                }
            }
            //生成复查信息
            sceneCheckDetailList.forEach(item -> {
                if (item.getIsReform()==Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())) {
                    SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
                    sceneCheckRecord.setPid(item.getId());
                    sceneCheckRecord.setCheckId(item.getPid());
                    //设置操作状态
                    sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REVIEW_STATE.getCode()));
                    sceneCheckRecord.setReviewPerson(item.getActualReviewer());
                    sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                    sceneCheckRecord.setReviewResult(item.getReviewResult());
                    sceneCheckRecord.setImgIds(item.getReviewImgIds());
                    sceneCheckRecord.setImgUrl(item.getReviewImgUrl());
                    sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                    sceneCheckRecord.setCheckItem(item.getCheckItem());
                    sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                    sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                    list.add(sceneCheckRecord);
                }
            });
            if (CollectionUtils.isNotEmpty(list)) {
                sceneCheckRecordService.saveBatch(list, list.size());
            }




            //解除文件服务器和待整改的绑定
            sceneCheckDetails.forEach(sceneCheckitem->{
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter(QueryParam.EQ,sceneCheckitem.getId() ));
                queryParam.getOrderMap().put("createTime", QueryParam.DESC);
                queryParam.getParams().put("operation_type", new Parameter(QueryParam.EQ, Integer.parseInt(OperationState.REFORM_STATE.getCode())));

                List<SceneCheckRecordEntity> sceneCheckRecords = sceneCheckRecordService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(sceneCheckRecords)) {
                    System.out.println(sceneCheckRecords);
                    SceneCheckRecordEntity sceneCheckRecordEntity = sceneCheckRecords.get(0);
                    if (sceneCheckRecordEntity.getImgIds()!=null)
                    {
                        List<String> imgids = Arrays.asList(sceneCheckRecordEntity.getImgIds().split(","));
                        List<Long> attachIds = new ArrayList<>();
                        imgids.forEach(item->{
                            attachIds.add(Long.parseLong(item));
                        });
                        iAttachmentApi.updateAttachRef(sceneCheckRecordEntity.getId(), attachIds);
                    }
                }
            });


            //设置（检查结果）复查信息
            sceneCheckDetails.forEach(item -> {
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateReviewMsgWrapper = new LambdaUpdateWrapper<>();
                updateReviewMsgWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = df.format(new Date());
                String reviewDescribe = "";
                if (StringUtils.isNotEmpty(item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(SceneCheckDetailEntity::getReviewMsg, item.getActualReviewer() + "-" + dateTime + "-" + reviewDescribe);
                Integer reviewResult = item.getReviewResult();
                sceneCheckDetailService.update(updateReviewMsgWrapper);
            });
        }
        //复检结果为复查不合格或者合格  isModify 修改为1 待复检为 0
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != Integer.parseInt(ReviewState.REVIEW_STATE.getCode())) {
                LambdaUpdateWrapper<SceneCheckDetailEntity> isModifyWrapper = new LambdaUpdateWrapper<>();
                isModifyWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                isModifyWrapper.set(SceneCheckDetailEntity::getIsModify, Integer.parseInt(ModifyState.MODIFIED_STATE.getCode()));
                sceneCheckDetailService.update(isModifyWrapper);
            }
        });
        System.out.println("=============");
        System.out.println(sceneCheckDetails);
        //设置 整改状态  检查结果状态描述
        sceneCheckDetails.forEach(item -> {
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())) {
                LambdaUpdateWrapper<SceneCheckDetailEntity> sceneUpdateWrapper = new LambdaUpdateWrapper<>();
                sceneUpdateWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewDate,new Date());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewResult, ReviewState.REVIEW_FAILED_STATE.getCode());
                sceneCheckDetailService.update(sceneUpdateWrapper);
            }
            //合格设置为3
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())) {
                LambdaUpdateWrapper<SceneCheckDetailEntity> successWrapper = new LambdaUpdateWrapper<>();
                successWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                successWrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());

                successWrapper.set(SceneCheckDetailEntity::getReviewResult, ReviewState.REVIEW_FINISHED_STATE.getCode());
                successWrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode()));
                if (item.getReviewDate()==null)
                {
                    successWrapper.set(SceneCheckDetailEntity::getReviewDate,new Date());
                }
                sceneCheckDetailService.update(successWrapper);
            }
        });
        //分组
        Map<Integer, List<SceneCheckDetailEntity>> reviewMap = sceneCheckDetails.stream().filter(reviewItem -> reviewItem.getReviewResult() != null).collect(Collectors.groupingBy(SceneCheckDetailEntity::getReviewResult));

        //设置已提交
        updateWrapper.set(SceneCheckEntity::getReviewStatus, Integer.parseInt(SubmitState.IS_SUBMITTED.getCode()));
        if (!reviewMap.isEmpty()) {
            //设置已完成  合格的
            int reviewFinished = 0;
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                LambdaUpdateWrapper<SceneCheckEntity> revieweFinishedWrapper = new LambdaUpdateWrapper<>();
                reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                revieweFinishedWrapper.set(SceneCheckEntity::getReviewPass, reviewFinished);
                revieweFinishedWrapper.eq(SceneCheckEntity::getId, entity.getId());
                boolean update = service.update(revieweFinishedWrapper);
            }
            //设置已复查（合格不合格的）
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                LambdaUpdateWrapper<SceneCheckEntity> revieweFailedWrapper = new LambdaUpdateWrapper<>();
                int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                int size = reviewFinished + reviewFailed;
                revieweFailedWrapper.set(SceneCheckEntity::getReviewedNum, size);
                revieweFailedWrapper.eq(SceneCheckEntity::getId, entity.getId());
                boolean update = service.update(revieweFailedWrapper);
            }
        }

        boolean update = service.update(updateWrapper);
        if (update) {
            Long id = entity.getId();
            SceneCheckEntity checkenEntity = service.selectById(id);
            SceneCheckVO scenecheckvo = BeanMapper.map(checkenEntity, SceneCheckVO.class);
            return CommonResponse.success("提交成功！", scenecheckvo);
        }
        return CommonResponse.error("提交失败！");
    }


    @ApiOperation("保存复查信息")
    @RequestMapping(value = "/saveReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveReviewNews(@ApiParam(name = "saveReviewNews", required = true) @RequestBody SceneCheckVO param) {
        SceneCheckEntity entity = BeanMapper.map(param, SceneCheckEntity.class);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        //设置，复查结果，复查描述，复查图片 信息  /设置当前登录人为实际复查人
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
                String userName = sessionManager.getUserContext().getUserName();
                updateWrapper.set(SceneCheckDetailEntity::getActualReviewer, userName);
                updateWrapper.eq(SceneCheckDetailEntity::getId, sceneCheckDetail.getId());
                updateWrapper.set(SceneCheckDetailEntity::getReviewResult, sceneCheckDetail.getReviewResult());
                updateWrapper.set(SceneCheckDetailEntity::getReviewDescribe, sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgIds, sceneCheckDetail.getReviewImgIds());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgUrl, sceneCheckDetail.getReviewImgUrl());
                sceneCheckDetailService.update(updateWrapper);
            });
        }
        Long id = entity.getId();
        SceneCheckEntity sceneCheck = service.selectById(id);
        SceneCheckVO vo = BeanMapper.map(sceneCheck, SceneCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


}
