package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("review")
@Api(value = "待复检", tags = {"检查单主子表"})
public class ReviewController {

    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;



    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation("待复检查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = service.selectById(id);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<SceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails))
        {
            sceneCheckDetailVOList.forEach(item->{
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询待复检单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的
        param.getParams().put("reform_status", new Parameter(QueryParam.IN, Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_FAILED_STATE.getCode())));
        param.getParams().put("review_id", new Parameter(QueryParam.LIKE, sessionManager.getUserContext().getUserId().toString()));
        IPage<SceneCheckEntity> page = service.queryPage(param, false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("提交复查信息")
    @RequestMapping(value = "/submitReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> submitReviewNews(@ApiParam(name = "submitReviewNews", required = true) @RequestBody SceneCheckVO sceneCheckVO) {
        CommonResponse<SceneCheckVO> vo= service.submitReviewNews(sceneCheckVO);
        return vo;
    }


    @ApiOperation("保存复查信息")
    @RequestMapping(value = "/saveReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveReviewNews(@ApiParam(name = "saveReviewNews", required = true) @RequestBody SceneCheckVO param) {
        SceneCheckEntity entity = BeanMapper.map(param, SceneCheckEntity.class);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        //设置，复查结果，复查描述，复查图片 信息  /设置当前登录人为实际复查人
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
                String userName = sessionManager.getUserContext().getUserName();
                updateWrapper.set(SceneCheckDetailEntity::getActualReviewer, userName);
                updateWrapper.eq(SceneCheckDetailEntity::getId, sceneCheckDetail.getId());
                updateWrapper.set(SceneCheckDetailEntity::getReviewResult, sceneCheckDetail.getReviewResult());
                updateWrapper.set(SceneCheckDetailEntity::getReviewDescribe, sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgIds, sceneCheckDetail.getReviewImgIds());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgUrl, sceneCheckDetail.getReviewImgUrl());
                sceneCheckDetailService.update(updateWrapper);
            });
        }
        Long id = entity.getId();
        SceneCheckEntity sceneCheck = service.selectById(id);
        SceneCheckVO vo = BeanMapper.map(sceneCheck, SceneCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
}
