package com.ejianc.business.scene.service;

import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.scene.bean.SceneCheckEntity;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
public interface ISceneCheckService extends IBaseService<SceneCheckEntity> {


    /**
     *  检查单提交后的操作
     * @param billId 检查单id
     */
    public void checkSubmitHandle(Long billId);

    /**
     * 检查单弃审前的操作
     * @param billId
     */
    public boolean checkRevokeBeforeHandle(Long billId);

    /**
     * 检查单弃审后的操作
     * @param billId
     */
    public void checkRevokeAfterHandle(Long billId);

    /**
     *  修改逾期状态和检查结果状态描述
     */
    public void updateSceneCheckOverdue();
    /**
     *  修改逾期数量
     */
    public void updateSceneCheckOverdueNumber();

    CommonResponse<SceneCheckVO> submitReviewNews(SceneCheckVO sceneCheckVO);
}
