package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
@Service("sceneCheckService")
public class SceneCheckServiceImpl extends BaseServiceImpl<SceneCheckMapper, SceneCheckEntity> implements ISceneCheckService{

    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SceneCheckMapper sceneCheckMapper;
    @Autowired
    private CheckMessageService checkMessageService;
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     *  检查单提交后的操作
     * @param billId 检查单id
     */
    @Override
    public void checkSubmitHandle(Long billId) {

        if(billId != null){
            SceneCheckEntity sceneCheckEntity = this.selectById(billId);

            //检查单提交后，修改复查状态为 1
            LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckEntity::getId,billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus,Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem,sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus,Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update(updateWrapper);

            //检查单提交后 检查项状态改为待整改
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d->{
                LambdaUpdateWrapper<SceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(SceneCheckDetailEntity::getId,d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_STATE.getDescription());
                sceneCheckDetailService.update(wrapper);
            });


            List<SceneCheckRecordEntity> list = new ArrayList<>();
            List<SceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            //检查单提交后，生成检查信息记录
            sceneCheckDetaillist.forEach(item->{
                SceneCheckRecordEntity sceneCheckRecord=new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                //设置操作状态
                sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getProblemImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            sceneCheckRecordService.saveBatch(list,list.size());


            sceneCheckEntity = this.selectById(billId);
            SceneCheckVO vo = BeanMapper.map(sceneCheckEntity, SceneCheckVO.class);
            //待整改检查项发 送消息
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();

            vo.setMsgNum(vo.getSceneCheckDetails().size());
            vo.setMsgBillCode(vo.getBillCode());
            vo.setMsgId(vo.getId());

            if(StringUtils.isNotBlank(reformDutyId)){
                String[] reformDuty = reformDutyId.split(",");
                //发送消息给整改人
                checkMessageService.sendMsg(vo,reformDuty,NoticeEnum.CHECK_COMMIT_PASS);
            }
            if(StringUtils.isNotBlank(notifRelevantId)){
                String[] notifRelevant = notifRelevantId.split(",");
                //发送消息给需要通知人员
                checkMessageService.sendMsg(vo,notifRelevant,NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }


        }

    }

    /**
     * 检查单弃审前的操作
     * @param billId
     */
    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        //检查单弃审前，查询记录表中是否有整改记录
        SceneCheckEntity sceneCheckEntity = this.selectById(billId);
        QueryParam param = new QueryParam();
        /*LambdaUpdateWrapper<SceneCheckRecordEntity> wrapper = new LambdaUpdateWrapper<>();
        //检查单id
        wrapper.set(SceneCheckRecordEntity :: getCheckId,sceneCheckEntity.getId());
        //操作类型为：整改
        wrapper.set(SceneCheckRecordEntity :: getOperationType,Integer.parseInt(OperationState.REFORM_STATE.getCode()));*/

        param.getParams().put("checkId",new Parameter(QueryParam.EQ,sceneCheckEntity.getId()));
        param.getParams().put("operationType",new Parameter(QueryParam.EQ,Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List<SceneCheckRecordEntity> list = sceneCheckRecordService.queryList(param,false);
        //int count = sceneCheckRecordService.count(wrapper);
        if(list.size()>0){
            flag = false;
        }
        return flag;
    }

    /**
     * 检查单弃审后操作
     * @param billId 单据id
     */
    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if(billId != null){
            SceneCheckEntity sceneCheckEntity = this.selectById(billId);
            //检查单弃审后，修改复查状态为 0
            LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckEntity::getId,billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus,Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem,sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus,null);
            this.update(updateWrapper);

            //检查单弃审后 检查项状态改为默认值 0
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d->{
                LambdaUpdateWrapper<SceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(SceneCheckDetailEntity::getId,d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.DEFULT_STATE.getCode());
                sceneCheckDetailService.update(wrapper);
            });

            //检查单弃审后，要删除记录表中检查单的检查记录  检查单id 和 操作类型为检查
            LambdaUpdateWrapper<SceneCheckRecordEntity> deleteWrapper = new LambdaUpdateWrapper<>();
            deleteWrapper.set(SceneCheckRecordEntity :: getCheckId,sceneCheckEntity.getId());
            deleteWrapper.set(SceneCheckRecordEntity :: getOperationType,Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            sceneCheckRecordService.remove(deleteWrapper);
        }
    }

    @Override
    public void updateSceneCheckOverdue() {
        sceneCheckMapper.updateSceneCheckOverdue();
    }

    @Override
    public void updateSceneCheckOverdueNumber() {
      sceneCheckMapper.updateSceneCheckOverdueNumber();
    }
    /**
     * 待复检提交信息
     * @param sceneCheckVO 检查单vo
     */
    @Override
    public CommonResponse<SceneCheckVO> submitReviewNews(SceneCheckVO sceneCheckVO) {
        SceneCheckEntity entity = BeanMapper.map(sceneCheckVO, SceneCheckEntity.class);
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SceneCheckEntity::getId, entity.getId());
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List<Integer> reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            //提交是否复查不合格的话
            List<SceneCheckRecordEntity> list = new ArrayList<>();
            List<SceneCheckDetailEntity> sceneCheckDetailList = null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                //复检不合格的话，把整改状态设置为3
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgId(entity.getId());
                vo.setMsgBillCode(entity.getBillCode());
                vo.setMsgNum(sceneCheckDetailList.size());
                String reformDutyId = vo.getReformDutyId();
                if (reformDutyId!=null){
                    String[] reformDutyIds = reformDutyId.split(",");
                    checkMessageService.sendMsg(vo,reformDutyIds,NoticeEnum.REVIEW_COMMIT_UNPASS);
                }
            }
            //合格的个数
            int size = reviewResults.stream().filter(reviewResult -> reviewResult == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size();
            //合格的数等于检查项的数 全部合格
            if (size == sceneCheckDetails.size()) {
                //全部合格的话，整改状态该为reformStatus 设置为4 全部完成
                updateWrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                //设置复检信息
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgBillCode(entity.getBillCode());
                String notifRelevantId = vo.getNotifRelevantId();
                if (notifRelevantId!=null) {
                    String[] notifRelevantIds = notifRelevantId.split(",");
                    vo.setMsgId(entity.getId());
                    vo.setMsgNum(0);
                    checkMessageService.sendMsg(vo,notifRelevantIds,NoticeEnum.REVIEW_COMMIT_PASS);
                }
            }
            //生成复查信息
            sceneCheckDetailList.forEach(item -> {
                if (item.getIsReform()==Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())) {
                    SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
                    sceneCheckRecord.setPid(item.getId());
                    sceneCheckRecord.setCheckId(item.getPid());
                    //设置操作状态
                    sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REVIEW_STATE.getCode()));
                    sceneCheckRecord.setReviewPerson(item.getActualReviewer());
                    sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                    sceneCheckRecord.setReviewResult(item.getReviewResult());
                    sceneCheckRecord.setImgIds(item.getReviewImgIds());
                    sceneCheckRecord.setImgUrl(item.getReviewImgUrl());
                    sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                    sceneCheckRecord.setCheckItem(item.getCheckItem());
                    sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                    sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                    list.add(sceneCheckRecord);
                }
            });
            if (CollectionUtils.isNotEmpty(list)) {
                sceneCheckRecordService.saveBatch(list, list.size());
            }
            //解除文件服务器和待整改的绑定
            sceneCheckDetails.forEach(sceneCheckitem->{
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter(QueryParam.EQ,sceneCheckitem.getId() ));
                queryParam.getOrderMap().put("createTime", QueryParam.DESC);
                queryParam.getParams().put("operation_type", new Parameter(QueryParam.EQ, Integer.parseInt(OperationState.REFORM_STATE.getCode())));
                List<SceneCheckRecordEntity> sceneCheckRecords = sceneCheckRecordService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(sceneCheckRecords)) {
                    System.out.println(sceneCheckRecords);
                    SceneCheckRecordEntity sceneCheckRecordEntity = sceneCheckRecords.get(0);
                    if (sceneCheckRecordEntity.getImgIds()!=null) {
                        List<String> imgids = Arrays.asList(sceneCheckRecordEntity.getImgIds().split(","));
                        List<Long> attachIds = new ArrayList<>();
                        imgids.forEach(item->{
                            attachIds.add(Long.parseLong(item));
                        });
                        iAttachmentApi.updateAttachRef(sceneCheckRecordEntity.getId(), attachIds);
                    }
                }
            });
            //设置（检查结果）复查信息
            sceneCheckDetails.forEach(item -> {
                LambdaUpdateWrapper<SceneCheckDetailEntity> updateReviewMsgWrapper = new LambdaUpdateWrapper<>();
                updateReviewMsgWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = df.format(new Date());
                String reviewDescribe = "";
                if (org.apache.commons.lang.StringUtils.isNotEmpty(item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(SceneCheckDetailEntity::getReviewMsg, item.getActualReviewer() + "-" + dateTime + "-" + reviewDescribe);
                Integer reviewResult = item.getReviewResult();
                sceneCheckDetailService.update(updateReviewMsgWrapper);
            });
        }
        //复检结果为复查不合格或者合格  isModify 修改为1 待复检为 0
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != Integer.parseInt(ReviewState.REVIEW_STATE.getCode())) {
                LambdaUpdateWrapper<SceneCheckDetailEntity> isModifyWrapper = new LambdaUpdateWrapper<>();
                isModifyWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                isModifyWrapper.set(SceneCheckDetailEntity::getIsModify, Integer.parseInt(ModifyState.MODIFIED_STATE.getCode()));
                sceneCheckDetailService.update(isModifyWrapper);
            }
        });
        //设置 整改状态  检查结果状态描述
        sceneCheckDetails.forEach(item -> {
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())) {
                LambdaUpdateWrapper<SceneCheckDetailEntity> sceneUpdateWrapper = new LambdaUpdateWrapper<>();
                sceneUpdateWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewDate,new Date());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewResult, ReviewState.REVIEW_FAILED_STATE.getCode());
                sceneCheckDetailService.update(sceneUpdateWrapper);
            }
            //合格设置为3
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())) {
                LambdaUpdateWrapper<SceneCheckDetailEntity> successWrapper = new LambdaUpdateWrapper<>();
                successWrapper.eq(SceneCheckDetailEntity::getId, item.getId());
                successWrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());
                successWrapper.set(SceneCheckDetailEntity::getReviewResult, ReviewState.REVIEW_FINISHED_STATE.getCode());
                successWrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode()));
                if (item.getReviewDate()==null) {
                    successWrapper.set(SceneCheckDetailEntity::getReviewDate,new Date());
                }
                sceneCheckDetailService.update(successWrapper);
            }
        });
        //分组
        Map<Integer, List<SceneCheckDetailEntity>> reviewMap = sceneCheckDetails.stream().filter(reviewItem -> reviewItem.getReviewResult() != null).collect(Collectors.groupingBy(SceneCheckDetailEntity::getReviewResult));
        //设置已提交
        updateWrapper.set(SceneCheckEntity::getReviewStatus, Integer.parseInt(SubmitState.IS_SUBMITTED.getCode()));
        if (!reviewMap.isEmpty()) {
            //设置已完成  合格的
            int reviewFinished = 0;
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                LambdaUpdateWrapper<SceneCheckEntity> revieweFinishedWrapper = new LambdaUpdateWrapper<>();
                reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                revieweFinishedWrapper.set(SceneCheckEntity::getReviewPass, reviewFinished);
                revieweFinishedWrapper.eq(SceneCheckEntity::getId, entity.getId());
                 service.update(revieweFinishedWrapper);
            }
            //设置已复查（合格不合格的）
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                LambdaUpdateWrapper<SceneCheckEntity> revieweFailedWrapper = new LambdaUpdateWrapper<>();
                int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                int size = reviewFinished + reviewFailed;
                revieweFailedWrapper.set(SceneCheckEntity::getReviewedNum, size);
                revieweFailedWrapper.eq(SceneCheckEntity::getId, entity.getId());
                service.update(revieweFailedWrapper);
            }
        }
        service.update(updateWrapper);
        SceneCheckEntity checkenEntity = service.selectById(entity.getId());
        SceneCheckVO scenecheckvo = BeanMapper.map(checkenEntity, SceneCheckVO.class);
        return CommonResponse.success("提交成功！", scenecheckvo);
    }
}
