/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.XcjcsssjhzSeriesVO;
import com.ejianc.business.scene.vo.XcjcsssjhzVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bi"})
public class BiController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IProjectApi projectApi;
    @Resource
    private ISceneCheckService sceneCheckService;

    @GetMapping(value={"/xcjcsssjhz"})
    public CommonResponse<JSONObject> getXcjcsssjhz(@RequestParam(value="orgId") Long orgId, @RequestParam(value="dateIn") String dateIn, @RequestParam(value="projectStatus") String projectStatus, @RequestParam(value="jcxSort", defaultValue="desc") String jcxSort, @RequestParam(value="dzgSort", defaultValue="desc") String dzgSort, @RequestParam(value="yqwzgSort", defaultValue="desc") String yqwzgSort) {
        JSONObject js = new JSONObject();
        LinkedList<XcjcsssjhzSeriesVO> xcjcsssjhzSeriesVOS = new LinkedList<XcjcsssjhzSeriesVO>();
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo();
        filterOrgIdVo.setOrgId(orgId);
        filterOrgIdVo.setDateIn(dateIn);
        filterOrgIdVo.setProjectStatus(projectStatus);
        CommonResponse response = this.projectApi.queryFilterOrgIds(filterOrgIdVo);
        if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            this.logger.error("BI\u5927\u5c4f\u67e5\u8be2\u7ec4\u7ec7ids\u5931\u8d25, orgId={}, dateIn={}, projectStatus={}", new Object[]{orgId, dateIn, projectStatus});
            LinkedList<BigDecimal> zero = new LinkedList<BigDecimal>();
            zero.add(BigDecimal.ZERO);
            LinkedList<String> projectNames = new LinkedList<String>();
            projectNames.add("\u7a7a\u9879\u76ee");
            xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u68c0\u67e5\u9879").type("bar").data(zero).build());
            xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u5f85\u6574\u6539").type("bar").data(zero).build());
            xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u903e\u671f\u672a\u6574\u6539").type("bar").data(zero).build());
            js.put("xAxisData", projectNames);
            js.put("series", xcjcsssjhzSeriesVOS);
            return CommonResponse.success((Object)js);
        }
        List orgIds = (List)response.getData();
        List<XcjcsssjhzVO> xcjcsssjhzVOS = this.sceneCheckService.getXcjcsssjhz(orgIds, jcxSort, dzgSort, yqwzgSort);
        if (CollectionUtils.isEmpty(xcjcsssjhzVOS)) {
            this.logger.error("BI\u5927\u5c4f\u67e5\u8be2\u7ec4\u7ec7ids\u5931\u8d25, orgId={}, dateIn={}, projectStatus={}", new Object[]{orgId, dateIn, projectStatus});
            LinkedList<BigDecimal> zero = new LinkedList<BigDecimal>();
            zero.add(BigDecimal.ZERO);
            LinkedList<String> projectNames = new LinkedList<String>();
            projectNames.add("\u7a7a\u9879\u76ee");
            xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u68c0\u67e5\u9879").type("bar").data(zero).build());
            xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u5f85\u6574\u6539").type("bar").data(zero).build());
            xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u903e\u671f\u672a\u6574\u6539").type("bar").data(zero).build());
            js.put("xAxisData", projectNames);
            js.put("series", xcjcsssjhzSeriesVOS);
            return CommonResponse.success((Object)js);
        }
        LinkedList projectNames = xcjcsssjhzVOS.stream().map(XcjcsssjhzVO::getProjectName).collect(Collectors.toCollection(LinkedList::new));
        LinkedList jcxNum = xcjcsssjhzVOS.stream().map(XcjcsssjhzVO::getJcxNum).collect(Collectors.toCollection(LinkedList::new));
        LinkedList dzgNum = xcjcsssjhzVOS.stream().map(XcjcsssjhzVO::getJcxNum).collect(Collectors.toCollection(LinkedList::new));
        LinkedList yqwzgNum = xcjcsssjhzVOS.stream().map(XcjcsssjhzVO::getJcxNum).collect(Collectors.toCollection(LinkedList::new));
        xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u68c0\u67e5\u9879").type("bar").data(jcxNum).build());
        xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u5f85\u6574\u6539").type("bar").data(dzgNum).build());
        xcjcsssjhzSeriesVOS.add(XcjcsssjhzSeriesVO.builder().name("\u903e\u671f\u672a\u6574\u6539").type("bar").data(yqwzgNum).build());
        js.put("xAxisData", (Object)projectNames);
        js.put("series", xcjcsssjhzSeriesVOS);
        return CommonResponse.success((Object)js);
    }
}

