package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.XcjcsssjhzSeriesVO;
import com.ejianc.business.scene.vo.XcjcsssjhzVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * TODO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping("/bi")
public class BiController {
  private final Logger logger = LoggerFactory.getLogger(this.getClass());
  @Resource private IProjectApi projectApi;
  @Resource private ISceneCheckService sceneCheckService;

  /**
   * 现场检查实施数据汇总
   *
   * @param orgId 组织id
   * @param dateIn 时间
   * @param projectStatus 项目状态
   * @param jcxSort 检查项排序，默认降序
   * @param dzgSort 待整改排序，默认降序
   * @param yqwzgSort 逾期未整改排序，默认降序
   * @return {@link CommonResponse}<{@link JSONObject}>
   */
  @GetMapping("/xcjcsssjhz")
  public CommonResponse<JSONObject> getXcjcsssjhz(
      @RequestParam("orgId") Long orgId,
      @RequestParam("dateIn") String dateIn,
      @RequestParam("projectStatus") String projectStatus,
      @RequestParam(value = "jcxSort", defaultValue = "desc") String jcxSort,
      @RequestParam(value = "dzgSort", defaultValue = "desc") String dzgSort,
      @RequestParam(value = "yqwzgSort", defaultValue = "desc") String yqwzgSort) {
    JSONObject js = new JSONObject();
    LinkedList<XcjcsssjhzSeriesVO> xcjcsssjhzSeriesVOS = new LinkedList<>();
    FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo();
    filterOrgIdVo.setOrgId(orgId);
    filterOrgIdVo.setDateIn(dateIn);
    filterOrgIdVo.setProjectStatus(projectStatus);
    CommonResponse<List<Long>> response = projectApi.queryFilterOrgIds(filterOrgIdVo);
    if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
      logger.error(
          "BI大屏查询组织ids失败, orgId={}, dateIn={}, projectStatus={}", orgId, dateIn, projectStatus);
      LinkedList<BigDecimal> zero = new LinkedList<>();
      zero.add(BigDecimal.ZERO);
      LinkedList<String> projectNames = new LinkedList<>();
      projectNames.add("空项目");
      xcjcsssjhzSeriesVOS.add(
          XcjcsssjhzSeriesVO.builder().name("检查项").type("bar").data(zero).build());
      xcjcsssjhzSeriesVOS.add(
          XcjcsssjhzSeriesVO.builder().name("待整改").type("bar").data(zero).build());
      xcjcsssjhzSeriesVOS.add(
          XcjcsssjhzSeriesVO.builder().name("逾期未整改").type("bar").data(zero).build());

      js.put("xAxisData", projectNames);
      js.put("series", xcjcsssjhzSeriesVOS);
      js.put("sumJcxNum", BigDecimal.ZERO);
      js.put("sumDzgNum", BigDecimal.ZERO);
      js.put("sumYqwzgNum", BigDecimal.ZERO);
      return CommonResponse.success(js);
    }
    List<Long> orgIds = response.getData();
    List<XcjcsssjhzVO> xcjcsssjhzVOS =
        sceneCheckService.getXcjcsssjhz(orgIds, jcxSort, dzgSort, yqwzgSort);
    if (CollectionUtils.isEmpty(xcjcsssjhzVOS)) {
      logger.error(
          "BI大屏查询组织ids失败, orgId={}, dateIn={}, projectStatus={}", orgId, dateIn, projectStatus);
      LinkedList<BigDecimal> zero = new LinkedList<>();
      zero.add(BigDecimal.ZERO);
      LinkedList<String> projectNames = new LinkedList<>();
      projectNames.add("空项目");
      xcjcsssjhzSeriesVOS.add(
          XcjcsssjhzSeriesVO.builder().name("检查项").type("bar").data(zero).build());
      xcjcsssjhzSeriesVOS.add(
          XcjcsssjhzSeriesVO.builder().name("待整改").type("bar").data(zero).build());
      xcjcsssjhzSeriesVOS.add(
          XcjcsssjhzSeriesVO.builder().name("逾期未整改").type("bar").data(zero).build());

      js.put("xAxisData", projectNames);
      js.put("series", xcjcsssjhzSeriesVOS);
      js.put("sumJcxNum", BigDecimal.ZERO);
      js.put("sumDzgNum", BigDecimal.ZERO);
      js.put("sumYqwzgNum", BigDecimal.ZERO);
      return CommonResponse.success(js);
    }
    LinkedList<String> projectNames =
        xcjcsssjhzVOS.stream()
            .map(XcjcsssjhzVO::getProjectName)
            .collect(Collectors.toCollection(LinkedList::new));

    LinkedList<BigDecimal> jcxNum =
        xcjcsssjhzVOS.stream()
            .map(XcjcsssjhzVO::getJcxNum)
            .collect(Collectors.toCollection(LinkedList::new));

    LinkedList<BigDecimal> dzgNum =
        xcjcsssjhzVOS.stream()
            .map(XcjcsssjhzVO::getDzgNum)
            .collect(Collectors.toCollection(LinkedList::new));

    LinkedList<BigDecimal> yqwzgNum =
        xcjcsssjhzVOS.stream()
            .map(XcjcsssjhzVO::getYqwzgNum)
            .collect(Collectors.toCollection(LinkedList::new));

    xcjcsssjhzSeriesVOS.add(
        XcjcsssjhzSeriesVO.builder().name("检查项").type("bar").data(jcxNum).build());
    xcjcsssjhzSeriesVOS.add(
        XcjcsssjhzSeriesVO.builder().name("待整改").type("bar").data(dzgNum).build());
    xcjcsssjhzSeriesVOS.add(
        XcjcsssjhzSeriesVO.builder().name("逾期未整改").type("bar").data(yqwzgNum).build());

    js.put("xAxisData", projectNames);
    js.put("series", xcjcsssjhzSeriesVOS);
    js.put("sumJcxNum", jcxNum.stream().reduce(BigDecimal.ZERO, BigDecimal::add));
    js.put("sumDzgNum", dzgNum.stream().reduce(BigDecimal.ZERO, BigDecimal::add));
    js.put("sumYqwzgNum", yqwzgNum.stream().reduce(BigDecimal.ZERO, BigDecimal::add));
    return CommonResponse.success(js);
  }
}
