package com.ejianc.business.scene.controller;

import java.io.Serializable;

import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneDailyDetailEntity;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneDailyDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.scene.bean.SceneDailyEntity;
import com.ejianc.business.scene.service.ISceneDailyService;
import com.ejianc.business.scene.vo.SceneDailyVO;

/**
 * 日常检查主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("daily")
@Api(value = "日常检查主表", tags = {"日常检查主表"})
public class SceneDailyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "SCENE_Daily_CODE";//此处需要根据实际修改

    @Autowired
    private ISceneDailyService service;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneDailyVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SceneDailyVO saveorUpdateVO) {
    	SceneDailyEntity entity = BeanMapper.map(saveorUpdateVO, SceneDailyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

        List<SceneDailyDetailEntity> sceneDailyDetailList= entity.getSceneDailys();
        List<SceneDailyDetailVO> list = BeanMapper.mapList(sceneDailyDetailList, SceneDailyDetailVO.class);
        list.forEach((item)->{
            item.setBaseImgUrl(baseImgUrl);
        });
    	SceneDailyVO vo = BeanMapper.map(entity, SceneDailyVO.class);
        vo.setSceneDailys(list);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneDailyVO> queryDetail(@RequestParam Long id) {
    	SceneDailyEntity entity = service.selectById(id);
        List<SceneDailyDetailEntity> sceneDailyDetailList= entity.getSceneDailys();
        List<SceneDailyDetailVO> list = BeanMapper.mapList(sceneDailyDetailList, SceneDailyDetailVO.class);
        list.forEach((item)->{
            item.setBaseImgUrl(baseImgUrl);
        });
    	SceneDailyVO vo = BeanMapper.map(entity, SceneDailyVO.class);
        vo.setSceneDailys(list);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SceneDailyVO> vos) {
        service.removeByIds(vos.stream().map(SceneDailyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("列表查询")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneDailyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //移动端和pc端权限处理
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<SceneDailyEntity> page = service.queryPage(param,false);
        IPage<SceneDailyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneDailyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SceneDailyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SceneDaily-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSceneDailyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SceneDailyVO>> refSceneDailyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SceneDailyEntity> page = service.queryPage(param,false);
        IPage<SceneDailyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneDailyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
