package com.ejianc.business.scene.controller;

import java.io.Serializable;

import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.util.GetAutoCode;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.vo.SceneCheckVO;

/**
 * 检查单主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sceneCheck")
@Api(value = "检查单主表", tags = {"检查单主表"})
public class SceneCheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCENE_CHECK_CODE";//此处需要根据实际修改

    @Autowired
    private ISceneCheckService service;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;

    @Autowired
    ICommonBusinessService sceneCheck;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("测试消息")
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> test(@RequestParam Long id) {
        sceneCheck.afterApprovalProcessor(id, null, null);
        return CommonResponse.success("查询详情数据成功！");
    }



    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SceneCheckVO saveorUpdateVO) {
    	SceneCheckEntity entity = BeanMapper.map(saveorUpdateVO, SceneCheckEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //新增时整改状态设置为0
            entity.setReformStatus(Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
        }
        //获取子表
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
    	//子表赋值
        int count = 0;
        for (SceneCheckDetailEntity sceneCheckDetail:sceneCheckDetails) {
            if(sceneCheckDetail.getRowState() == null || !"del".equals(sceneCheckDetail.getRowState()) ){
                count++;
                if(StringUtils.isBlank(sceneCheckDetail.getBillCode())){
                    sceneCheckDetail.setBillCode(entity.getBillCode()+"-"+ GetAutoCode.getTowPipelineNumbers(count));
                }
            }
            //检查单名称
            if(StringUtils.isBlank(sceneCheckDetail.getCheckName())){
                sceneCheckDetail.setCheckName(entity.getCheckName());
            }
            //项目名称
            if(StringUtils.isBlank(sceneCheckDetail.getProjectName())){
                sceneCheckDetail.setProjectName(entity.getProjectName());
            }
            //检查项设置默认的整改标识
            if(sceneCheckDetail.getIsReform()==null){
                sceneCheckDetail.setIsReform(Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            }
            if(sceneCheckDetail.getCheckType()==null){
                sceneCheckDetail.setCheckType(entity.getCheckType());
                sceneCheckDetail.setCheckTypeName(entity.getCheckTypeName());
            }
            if(sceneCheckDetail.getReformNumber()==null){
                sceneCheckDetail.setReformNumber(0);
            }

            sceneCheckDetail.setCheckAttr(entity.getCheckAttr());
            sceneCheckDetail.setCheckAttrName(entity.getCheckAttrName());

        }
        entity.setReviewItem(count);
        service.saveOrUpdate(entity, false);

        List<SceneCheckDetailEntity> sceneCheckDetails1 = entity.getSceneCheckDetails();
        List<SceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails1, SceneCheckDetailVO.class);
        sceneCheckDetailVOList.forEach((item)->{
            item.setBaseImgUrl(baseImgUrl);
        });
        SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
    	SceneCheckEntity entity = service.selectById(id);
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<SceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)){
            sceneCheckDetailVOList.forEach((item)->{
                item.setBaseImgUrl(baseImgUrl);
            });
        }
    	SceneCheckVO vo = BeanMapper.map(entity, SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SceneCheckVO> vos) {
        service.removeByIds(vos.stream().map(SceneCheckVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("检查单列表查询")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<SceneCheckEntity> page = service.queryPage(param,false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SceneCheckEntity> list = service.queryList(param);
        List<SceneCheckVO> sceneCheckVOS = BeanMapper.mapList(list, SceneCheckVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckVOS)) {
            sceneCheckVOS.forEach(t -> {
                if (t.getCheckLevel() != null) {
                    t.setCheckLevelName(1 == t.getCheckLevel().intValue() ? "项目" : "公司");
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().exportWithTrans("SceneCheck-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSceneCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> refSceneCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SceneCheckEntity> page = service.queryPage(param,false);
        IPage<SceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneCheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
