/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckStatisticsVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"checkResult"})
@Api(value="\u68c0\u67e5\u7ed3\u679c", tags={"\u68c0\u67e5\u5355\u4e3b\u5b50\u8bb0\u5f55\u8868\u8868"})
public class SceneCheckResultController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u68c0\u67e5\u7ed3\u679c\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)this.service.selectById(id));
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        }
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        Map params = param.getParams();
        if (params.containsKey("overdueNum")) {
            String overdueNum = (String)((Parameter)params.get("overdueNum")).getValue();
            params.remove("overdueNum");
            if (overdueNum.equals("1")) {
                param.getParams().put("overdueNum", new Parameter("gt", (Object)0));
            }
            if (overdueNum.equals("0")) {
                param.getParams().put("overdueNum", new Parameter("eq", (Object)0));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List sceneCheckVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sceneCheckVOS = BeanMapper.mapList((Iterable)list, SceneCheckVO.class);
            sceneCheckVOS.forEach(vo -> vo.setReformName(ReformState.getEnumByStateCode((Integer)vo.getReformStatus()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("SceneCheckResult-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u7edf\u8ba1")
    @RequestMapping(value={"/getStatisticsNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckStatisticsVO> getStatisticsNum() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        SceneCheckStatisticsVO sceneCheckStatisticsVO = new SceneCheckStatisticsVO();
        List sceneCheckEntities = this.service.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)sceneCheckEntities)) {
            sceneCheckStatisticsVO.setTotal(Integer.valueOf(sceneCheckEntities.size()));
            List collect = sceneCheckEntities.stream().filter(s -> s.getReformStatus() == Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                sceneCheckStatisticsVO.setFinished(Integer.valueOf(collect.size()));
            } else {
                sceneCheckStatisticsVO.setFinished(Integer.valueOf(collect.size()));
            }
            List reformList = sceneCheckEntities.stream().filter(s -> s.getReformStatus() == Integer.parseInt(ReformState.REFORM_STATE.getCode()) || s.getReformStatus() == Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(reformList)) {
                sceneCheckStatisticsVO.setRectification(Integer.valueOf(reformList.size()));
            } else {
                sceneCheckStatisticsVO.setRectification(Integer.valueOf(0));
            }
            List overdueList = sceneCheckEntities.stream().filter(s -> s.getOverdueNum() != null && s.getOverdueNum() > 0).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(overdueList)) {
                List overdueReformList = overdueList.stream().filter(s -> s.getReformStatus() == Integer.parseInt(ReformState.REFORM_STATE.getCode()) || s.getReformStatus() == Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(overdueReformList)) {
                    sceneCheckStatisticsVO.setOverdueNum(Integer.valueOf(overdueReformList.size()));
                } else {
                    sceneCheckStatisticsVO.setOverdueNum(Integer.valueOf(0));
                }
            } else {
                sceneCheckStatisticsVO.setOverdueNum(Integer.valueOf(0));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7edf\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)sceneCheckStatisticsVO);
    }
}

