package com.ejianc.business.scene.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.scene.bean.SceneInspectionDetailEntity;
/**
 * 巡检表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scene_inspection")
public class SceneInspectionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名
    @TableField(value="inspection_date")
    private Date inspectionDate; // 检查日期
    @TableField(value="inspection_id")
    private Long inspectionId; // 巡检负责人
    @TableField(value="inspection_name")
    private String inspectionName; // 巡检负责人
    @TableField(value="total_score")
    private BigDecimal totalScore; // 综合得分
    @TableField(value="file_urls")
    private String fileUrls; // 巡检资料
    @TableField(value="memo")
    private String memo; // 巡检内容
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5审批中
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="sceneInspectionDetailService",pidName = "inspectionId")
    private List<SceneInspectionDetailEntity> sceneInspectionDetailList = new ArrayList<>(); // 巡检表-巡检内容
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getInspectionDate() {
        return inspectionDate;
    }

    public void setInspectionDate(Date inspectionDate) {
        this.inspectionDate = inspectionDate;
    }
    public Long getInspectionId() {
        return inspectionId;
    }

    public void setInspectionId(Long inspectionId) {
        this.inspectionId = inspectionId;
    }
    public String getInspectionName() {
        return inspectionName;
    }

    public void setInspectionName(String inspectionName) {
        this.inspectionName = inspectionName;
    }
    public BigDecimal getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(BigDecimal totalScore) {
        this.totalScore = totalScore;
    }
    public String getFileUrls() {
        return fileUrls;
    }

    public void setFileUrls(String fileUrls) {
        this.fileUrls = fileUrls;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<SceneInspectionDetailEntity> getSceneInspectionDetailList() {
        return sceneInspectionDetailList;
    }

    public void setSceneInspectionDetailList(List<SceneInspectionDetailEntity> sceneInspectionDetailList) {
        this.sceneInspectionDetailList = sceneInspectionDetailList;
    }
}
