/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneSafetyCheckCategoryEntity;
import com.ejianc.business.scene.bean.SceneSafetyCheckItemEntity;
import com.ejianc.business.scene.service.ISceneSafetyCheckCategoryService;
import com.ejianc.business.scene.service.ISceneSafetyCheckItemService;
import com.ejianc.business.scene.vo.SceneSafetyCheckCategoryVO;
import com.ejianc.business.scene.vo.SceneSafetyCheckItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"sceneSafetyCheckItem"})
public class SceneSafetyCheckItemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCENE_SAFETY_CHECK_ITEM";
    private static final String BILL_TYPE_CODE = "BT202310000009";
    @Autowired
    private ISceneSafetyCheckItemService service;
    @Autowired
    private ISceneSafetyCheckCategoryService checkCategoryService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneSafetyCheckItemVO> saveOrUpdate(@RequestBody SceneSafetyCheckItemVO saveOrUpdateVO) {
        SceneSafetyCheckItemEntity dbEntity;
        SceneSafetyCheckItemEntity entity = null;
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            entity = (SceneSafetyCheckItemEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SceneSafetyCheckItemEntity.class));
            if (StringUtils.isBlank((CharSequence)entity.getCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setCode((String)billCode.getData());
            } else {
                dbEntity = this.service.getByCode(saveOrUpdateVO.getCode());
                if (null != dbEntity) {
                    return CommonResponse.error((String)"\u7269\u8d44\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            }
            if (null == entity.getEnabled()) {
                entity.setEnabled(1);
            }
        } else {
            dbEntity = this.service.getByCode(saveOrUpdateVO.getCode());
            if (null != dbEntity && !dbEntity.getId().equals(saveOrUpdateVO.getId())) {
                return CommonResponse.error((String)"\u7269\u8d44\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
            entity = (SceneSafetyCheckItemEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
            entity.setEnabled(saveOrUpdateVO.getEnabled());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setName(saveOrUpdateVO.getName());
            entity.setSequence(saveOrUpdateVO.getSequence());
            entity.setDescription(saveOrUpdateVO.getDescription());
        }
        this.service.saveOrUpdate((Object)entity, false);
        SceneSafetyCheckItemVO vo = (SceneSafetyCheckItemVO)BeanMapper.map((Object)((Object)entity), SceneSafetyCheckItemVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneSafetyCheckItemVO> queryDetail(Long id) {
        SceneSafetyCheckItemEntity entity = (SceneSafetyCheckItemEntity)((Object)this.service.selectById(id));
        SceneSafetyCheckItemVO vo = (SceneSafetyCheckItemVO)BeanMapper.map((Object)((Object)entity), SceneSafetyCheckItemVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote(BILL_TYPE_CODE, id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneSafetyCheckItemVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneSafetyCheckItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SceneSafetyCheckItem-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"safety-check-item-import.xlsx", (String)"\u5b89\u5168\u68c0\u67e5\u9879\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelItemImport"})
    public CommonResponse<JSONObject> excelItemImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<SceneSafetyCheckItemVO> processList = new ArrayList<SceneSafetyCheckItemVO>();
        ArrayList<SceneSafetyCheckItemVO> successList = new ArrayList<SceneSafetyCheckItemVO>();
        ArrayList<SceneSafetyCheckItemVO> errorList = new ArrayList<SceneSafetyCheckItemVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u68c0\u67e5\u9879\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            SceneSafetyCheckItemVO importVO = null;
            List datas = null;
            HashMap<String, SceneSafetyCheckItemVO> codeCacheMap = new HashMap<String, SceneSafetyCheckItemVO>();
            for (int i = 0; i < result.size(); ++i) {
                datas = (List)result.get(i);
                importVO = new SceneSafetyCheckItemVO();
                importVO.setId(Long.valueOf(IdWorker.getId()));
                importVO.setCategoryCode((String)datas.get(0));
                importVO.setCode((String)datas.get(1));
                importVO.setName((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importVO.setDescription("\u68c0\u67e5\u9879\u5206\u7c7b\u7f16\u53f7\u4e3a\u7a7a\uff01");
                    errorList.add(importVO);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    importVO.setDescription("\u68c0\u67e5\u9879\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(importVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)importVO.getCode()) && codeCacheMap.containsKey(importVO.getCode())) {
                    importVO.setDescription("\u68c0\u67e5\u9879\u7f16\u53f7\u91cd\u590d\uff01");
                    errorList.add(importVO);
                    continue;
                }
                codeCacheMap.put(importVO.getCode(), importVO);
                processList.add(importVO);
            }
            Map<Object, Object> categoryCodeMap = new HashMap();
            if (CollectionUtils.isNotEmpty(processList)) {
                Set codes = processList.stream().map(SceneSafetyCheckItemVO::getCategoryCode).collect(Collectors.toSet());
                List<SceneSafetyCheckCategoryEntity> categoryList = this.checkCategoryService.queryByCodes(new ArrayList<String>(codes));
                if (CollectionUtils.isNotEmpty(categoryList)) {
                    categoryCodeMap = categoryList.stream().collect(Collectors.toMap(SceneSafetyCheckCategoryEntity::getCode, item -> item));
                }
                SceneSafetyCheckCategoryEntity category = null;
                for (SceneSafetyCheckItemVO item2 : processList) {
                    category = (SceneSafetyCheckCategoryEntity)((Object)categoryCodeMap.get(item2.getCategoryCode()));
                    if (null == category) {
                        item2.setDescription("\u6240\u5c5e\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
                        errorList.add(item2);
                        continue;
                    }
                    item2.setCategoryId(category.getId());
                    item2.setCategoryName(category.getName());
                    successList.add(item2);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/saveImportExcelItem"})
    public CommonResponse<String> saveImportExcelItem(@RequestBody List<SceneSafetyCheckItemVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List noCodeItems = importVOS.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(noCodeItems)) {
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid(), noCodeItems.size());
            if (!codeResp.isSuccess()) {
                this.logger.error("\u8d28\u91cf\u68c0\u67e5\u9879\u7f16\u7801\u751f\u6210\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)codeResp));
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\uff01");
            }
            List codes = (List)codeResp.getData();
            for (int i = 0; i < codes.size(); ++i) {
                ((SceneSafetyCheckItemVO)noCodeItems.get(i)).setCode((String)codes.get(i));
            }
        }
        this.service.saveOrUpdateBatch(BeanMapper.mapList(importVOS, SceneSafetyCheckItemEntity.class), importVOS.size(), false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refSceneQualityCheckItemData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SceneSafetyCheckItemVO>> refSceneQualityCheckItemData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject, @RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            List<SceneSafetyCheckCategoryVO> materialCategoryVos = this.checkCategoryService.queryAllByPid(categoryId);
            if (CollectionUtils.isEmpty(materialCategoryVos)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5206\u7c7b\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
            }
            param.getParams().put("category_id", new Parameter("in", materialCategoryVos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneSafetyCheckItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

