package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.scene.bean.SceneQualityCheckCategoryEntity;
import com.ejianc.business.scene.service.ISceneQualityCheckCategoryService;
import com.ejianc.business.scene.service.ISceneQualityCheckItemService;
import com.ejianc.business.scene.vo.SceneQualityCheckCategoryVO;
import com.ejianc.business.scene.vo.SceneQualityCheckItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 资源管理-质量检查分类实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("sceneQualityCheckCategory")
public class SceneQualityCheckCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCENE_QUALITY_CHECK_CATEGORY";
    @Autowired
    private ISceneQualityCheckCategoryService service;
    @Autowired
    private ISceneQualityCheckItemService qualityCheckItemService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SceneQualityCheckCategoryVO> saveOrUpdate(@RequestBody SceneQualityCheckCategoryVO saveOrUpdateVO) {
    	SceneQualityCheckCategoryEntity entity = null;
    	if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
    	    entity = BeanMapper.map(saveOrUpdateVO, SceneQualityCheckCategoryEntity.class);
            saveOrUpdateVO.setId(IdWorker.getId());
    	    if(StringUtils.isBlank(saveOrUpdateVO.getCode())) {
                //编码为空
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());
                }else{
                    return CommonResponse.success("网络异常， 编码生成失败， 请稍后再试");
                }
            } else {
                SceneQualityCheckCategoryEntity codeData = service.queryByCode(saveOrUpdateVO.getCode());
                if(codeData != null ){
                    return CommonResponse.error("分类编码已存在,请重新填写");
                }
            }
    	    if(null == saveOrUpdateVO.getEnabled()) {
                //默认启用
                entity.setEnabled(1);
            }
    	    //设置内码
    	    if(null != saveOrUpdateVO.getParentId()) {
                SceneQualityCheckCategoryEntity parent = service.selectById(saveOrUpdateVO.getParentId());
                entity.setInnerCode(parent.getInnerCode() + "|" + saveOrUpdateVO.getId());
            } else {
                entity.setInnerCode(saveOrUpdateVO.getId().toString());
            }
        } else {
            SceneQualityCheckCategoryEntity codeData = service.queryByCode(saveOrUpdateVO.getCode());
            if(codeData != null && !codeData.getId().equals(saveOrUpdateVO.getId())){
                return CommonResponse.error("分类编码已存在,请重新填写");
            }
            entity = service.selectById(saveOrUpdateVO.getId());
            entity.setEnabled(saveOrUpdateVO.getEnabled());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setName(saveOrUpdateVO.getName());
            entity.setDescription(saveOrUpdateVO.getDescription());
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
    	service.saveOrUpdate(entity, false);
    	SceneQualityCheckCategoryVO vo = BeanMapper.map(entity, SceneQualityCheckCategoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<SceneQualityCheckCategoryVO> queryDetail(Long id) {
    	SceneQualityCheckCategoryEntity entity = service.selectById(id);
    	SceneQualityCheckCategoryVO vo = BeanMapper.map(entity, SceneQualityCheckCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if(ListUtil.isNotEmpty(ids)){
            //分类下有档案项了不允许删除
            List<SceneQualityCheckItemVO> materialList = qualityCheckItemService.queryListByCategoryId(ids);
            if(CollectionUtils.isNotEmpty(materialList)) {
                Set<String> categoryNames = materialList.stream().map(SceneQualityCheckItemVO::getCategoryName).collect(Collectors.toSet());
                return CommonResponse.error("分类【" + StringUtils.join(categoryNames, ",") + "】下检查项，不允许删除");
            }

            //如果分类有子节点并且所有子节点也包含在删除项内，允许删除
            List<SceneQualityCheckCategoryEntity> children = service.queryListByPid(ids);
            if(CollectionUtils.isNotEmpty(children)) {
                List<SceneQualityCheckCategoryEntity> childIds = children.stream().filter(item -> !ids.contains(item.getId())).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(childIds)) {
                    return CommonResponse.error("待删除分类下有子分类不允许删除");
                }
            }

            service.removeByIds(ids,true);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:param.getParams().entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<SceneQualityCheckCategoryVO> dataList = service.queryList(condition);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success(jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 更新父节点状态，同时更新子节点状态
     *
     * @return
     */
    @RequestMapping(value = "/updateEnabledStatus", method = RequestMethod.POST)
    public CommonResponse<String> updateEnabled(@RequestBody SceneQualityCheckCategoryVO saveOrUpdateVO) {
        SceneQualityCheckCategoryEntity dbEntity = service.selectById(saveOrUpdateVO.getId());
        dbEntity.setEnabled(saveOrUpdateVO.getEnabled());
        service.saveOrUpdate(dbEntity, false);
        return CommonResponse.success("更新成功");
    }

    @GetMapping(value = "/lazyCategoryTree")
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required = false) String condition,
                                                      @RequestParam(required = false) Long pid,
                                                      @RequestParam(required = false) String searchText) {

        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(searchText)) {
            params.put("searchText", searchText);
        }
        if(null != pid) {
            params.put("parentId", pid);
        }

        List<SceneQualityCheckCategoryVO> dataList = service.queryList(params);
        List<Map> map = BeanMapper.mapList(dataList, Map.class);
        map.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
            } else {
                l.put("children", null);
            }
        });
        return ResultAsTree.createTreeData(map);
    }

    @RequestMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quality-check-category-import.xlsx", "质量检查分类导入模板");
    }

    @PostMapping(value = "/excelImport")
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;

        List<SceneQualityCheckCategoryVO> successList = new ArrayList<>();
        List<SceneQualityCheckCategoryVO> processList = new ArrayList<>();
        List<SceneQualityCheckCategoryVO> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("分类数据超过10000条，请分批上传！");
            }
            Map<String, SceneQualityCheckCategoryVO> codeMapCache = new HashMap<>();
            SceneQualityCheckCategoryVO importVo = null;
            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                importVo = new SceneQualityCheckCategoryVO();
                importVo.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                importVo.setCode(datas.get(0));
                importVo.setParentCode(datas.get(1));
                importVo.setName(datas.get(2));
                if(StringUtils.isBlank(datas.get(0))){
                    importVo.setDescription("分类编码为空！");
                    errorList.add(importVo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(2))){
                    importVo.setDescription("分类名称为空！");
                    errorList.add(importVo);
                    continue;
                }
                if(codeMapCache.containsKey(importVo.getCode())) {
                    importVo.setDescription("分类名称重复！");
                    errorList.add(importVo);
                    continue;
                }

                importVo.setId(IdWorker.getId());
                importVo.setEnabled(1);
                importVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                importVo.setCreateTime(new Date());
                importVo.setTenantId(InvocationInfoProxy.getTenantid());
                processList.add(importVo);
                codeMapCache.put(importVo.getCode(), importVo);
            }

            if(ListUtil.isNotEmpty(processList)){
                //检查编码是否重复
                List<SceneQualityCheckCategoryEntity> codeList = service.queryByCodes(new ArrayList<>(codeMapCache.keySet()));
                Set<String> pCodes = processList.stream().map(SceneQualityCheckCategoryVO::getParentCode).collect(Collectors.toSet());
                Map<String, SceneQualityCheckCategoryEntity> parentCodeMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(pCodes)) {
                    List<SceneQualityCheckCategoryEntity> parentListByCode = service.queryByCodes(new ArrayList<>(pCodes));
                    if(CollectionUtils.isNotEmpty(parentListByCode)) {
                        parentCodeMap = parentListByCode.stream().collect(Collectors.toMap(SceneQualityCheckCategoryEntity::getCode, item -> item));
                    }
                }

                if(CollectionUtils.isNotEmpty(codeList)) {
                    for(SceneQualityCheckCategoryEntity repeatCode : codeList) {
                        importVo = codeMapCache.get(repeatCode.getCode());
                        codeMapCache.remove(repeatCode.getCode());
                        processList.remove(importVo);
                        importVo.setDescription("分类名称重复！");
                        errorList.add(importVo);
                        continue;
                    }
                }

                for(SceneQualityCheckCategoryVO item : processList) {
                    if(StringUtils.isNotBlank(item.getParentCode())) {
                        if(parentCodeMap.containsKey(item.getParentCode())) {
                            item.setInnerCode(parentCodeMap.get(item.getParentCode()).getInnerCode() + "|" + item.getId());
                            item.setParentId(parentCodeMap.get(item.getParentCode()).getId());
                        } else if(codeMapCache.containsKey(item.getParentCode())) {
                            item.setInnerCode(codeMapCache.get(item.getParentCode()).getInnerCode() + "|" + item.getId());
                            item.setParentId(codeMapCache.get(item.getParentCode()).getId());
                        }

                        if(null == item.getParentId()) {
                            item.setDescription("父分类编码对应分类不存在！");
                            errorList.add(importVo);
                            continue;
                        }
                    } else {
                        item.setInnerCode(item.getId().toString());
                    }

                    successList.add(item);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveImportExcelCategory")
    public CommonResponse<String> saveImportExcelCategory(@RequestBody List<SceneQualityCheckCategoryVO> saveImportVos) {
        if(ListUtil.isEmpty(saveImportVos)){
            return CommonResponse.error("导入的数据为空！");
        }
        List<SceneQualityCheckCategoryEntity> saveList = BeanMapper.mapList(saveImportVos, SceneQualityCheckCategoryEntity.class);
        service.saveOrUpdateBatch(saveList, saveList.size(), false);
        return CommonResponse.success("保存成功！");
    }

}
