package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.progress.api.IProgressApi;
import com.ejianc.business.progress.vo.ProgressFilterVO;
import com.ejianc.business.scene.service.ISceneInspectionService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2023/10/26 10:16
 */
@RestController
@RequestMapping(value = "/dryingManage/")
public class DryingManageController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private ISceneInspectionService sceneInspectionService;

    @Autowired
    private IProgressApi progressApi;

    @PostMapping(value = "pageList")
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) throws Exception {
        Map<String, Parameter> params = queryParam.getParams();
        LinkedHashMap<String, String> orderMap = queryParam.getOrderMap();
        JSONObject resp = new JSONObject();
        resp.put("size", queryParam.getPageSize());
        resp.put("current", queryParam.getPageIndex());
        SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");

        if(null == params.get("checkMonth")) {
            //为空时，默认查询上月
            params.put("checkMonth", new Parameter(QueryParam.EQ, yyyyMM.format(DateUtil.subMonths(new Date(), 1))));
        }

        //项目查询参数
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo(InvocationInfoProxy.getOrgId(), null,
                null != params.get("projectStatus") ? params.get("projectStatus").getValue().toString() : null, queryParam.getSearchText(), null);

        List<Map> projects = null;
        if(null == params.get("project")) {
            //查询本下项目列表
            CommonResponse<List<ProjectRegisterVO>> projectMapListResp =  projectApi.queryFilterProjects(filterOrgIdVo);
            if(!projectMapListResp.isSuccess()) {
                return CommonResponse.error("查询失败，获取项目信息失败！");
            }
            projects = BeanMapper.mapList(projectMapListResp.getData(), Map.class);
        } else {
            projects = new ArrayList<>();
            projects.add(JSONObject.parseObject(params.get("project").getValue().toString(), Map.class));
        }

        if(CollectionUtils.isEmpty(projects)) {
            resp.put("total", 0);
            resp.put("records", new ArrayList<>());
            return CommonResponse.success(resp);
        }
        resp.put("total", projects.size());
        String checkDate = yyyyMMdd.format(DateUtil.endOfMonth(yyyyMM.parse(params.get("checkMonth").getValue().toString()))) + " 23:59:59";

        //需要以项目达成率排序时，优先查询项目达成率
        List<Long> projectIds = projects.stream().map(item -> Long.valueOf(item.get("id").toString())).collect(Collectors.toList());
        if(orderMap.containsKey("nodeArchiveRateInMonth")) {
            CommonResponse<List<JSONObject>> projectProgressInfoResp = progressApi.getProjectProgress(new ProgressFilterVO(projectIds, checkDate));
            if(!projectProgressInfoResp.isSuccess()) {
                logger.error("查询项目达成率失败：{}", JSONObject.toJSONString(projectProgressInfoResp));
            } else {
                List<JSONObject> projectProgressInfo = projectProgressInfoResp.getData();
                Map<String, Object> projectArchiveRateMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(projectProgressInfo)) {
                    projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get("projectId").toString(),
                            item -> item.get("rate"))));
                }
                projects.stream().forEach(item -> {
                    //借用字段存储项目达成率
                    if(projectArchiveRateMap.containsKey(item.get("id").toString())) {
                        item.put("nodeArchiveRateInMonth", new BigDecimal(projectArchiveRateMap.get(item.get("id").toString()).toString()));
                    } else {
                        item.put("nodeArchiveRateInMonth", BigDecimal.ZERO);
                    }
                });
            }
        }

        Map<String, Object> queryParams = new HashMap<>();

        queryParams.put("checkMonth", params.get("checkMonth").getValue().toString());
        queryParams.put("month", Integer.valueOf(params.get("checkMonth").getValue().toString().split("-")[1]));
        queryParams.put("checkDate", checkDate);
        queryParams.put("projects", projects);
        queryParams.put("pageSize", queryParam.getPageSize());
        queryParams.put("startLine", ( queryParam.getPageIndex() < 1 ? 0 : queryParam.getPageIndex() -1) * queryParam.getPageSize());
        queryParams.put("projectIds", projectIds);

        if(!orderMap.isEmpty()) {
            StringBuilder sp = new StringBuilder();
            for(String key : orderMap.keySet()) {
                sp.append(key).append(" ").append(orderMap.get(key)).append(",");
            }
            queryParams.put("order", sp.substring(0,sp.length()-1));
        }

        List<Map> pageList = sceneInspectionService.queryDryingList(queryParams);

        if(!orderMap.containsKey("nodeArchiveRateInMonth")) {
            //查询项目月度 节点达成率
            CommonResponse<List<JSONObject>> projectProgressInfoResp = progressApi.getProjectProgress(
                    new ProgressFilterVO(pageList.stream().map(item -> Long.valueOf(item.get("projectId").toString())).collect(Collectors.toList()),
                            checkDate));
            if(!projectProgressInfoResp.isSuccess()) {
                logger.error("查询项目达成率失败：{}", JSONObject.toJSONString(projectProgressInfoResp));
            } else {
                List<JSONObject> projectProgressInfo = projectProgressInfoResp.getData();
                Map<String, Object> projectArchiveRateMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(projectProgressInfo)) {
                    projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get("projectId").toString(),
                            item -> item.get("rate"))));
                }
                pageList.stream().forEach(item -> {
                    if(projectArchiveRateMap.containsKey(item.get("projectId").toString())) {
                        item.put("nodeArchiveRateInMonth", projectArchiveRateMap.get(item.get("projectId").toString()));
                    } else {
                        item.put("nodeArchiveRateInMonth", 0);
                    }
                });
            }
        }

        resp.put("records", pageList);

        return CommonResponse.success(resp);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) throws Exception {
        Map<String, Parameter> params = queryParam.getParams();
        LinkedHashMap<String, String> orderMap = queryParam.getOrderMap();
        SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> pageList = new ArrayList<>();

        if(null == params.get("checkMonth")) {
            //为空时，默认查询上月
            params.put("checkMonth", new Parameter(QueryParam.EQ, yyyyMM.format(DateUtil.subMonths(new Date(), 1))));
        }

        //项目查询参数
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo(InvocationInfoProxy.getOrgId(), null,
                null != params.get("projectStatus") ? params.get("projectStatus").getValue().toString() : null, queryParam.getSearchText(), null);

        List<Map> projects = null;
        if(null == params.get("project")) {
            //查询本下项目列表
            CommonResponse<List<ProjectRegisterVO>> projectMapListResp =  projectApi.queryFilterProjects(filterOrgIdVo);
            if(!projectMapListResp.isSuccess()) {
                throw new BusinessException("查询失败，获取项目信息失败！");
            }
            projects = BeanMapper.mapList(projectMapListResp.getData(), Map.class);
        } else {
            projects = new ArrayList<>();
            projects.add(JSONObject.parseObject(params.get("project").getValue().toString(), Map.class));
        }

        if(CollectionUtils.isNotEmpty(projects)) {
            String checkDate = yyyyMMdd.format(DateUtil.endOfMonth(yyyyMM.parse(params.get("checkMonth").getValue().toString()))) + " 23:59:59";

            //需要以项目达成率排序时，优先查询项目达成率
            List<Long> projectIds = projects.stream().map(item -> Long.valueOf(item.get("id").toString())).collect(Collectors.toList());
            if(orderMap.containsKey("nodeArchiveRateInMonth")) {
                CommonResponse<List<JSONObject>> projectProgressInfoResp = progressApi.getProjectProgress(new ProgressFilterVO(projectIds, checkDate));
                if(!projectProgressInfoResp.isSuccess()) {
                    logger.error("查询项目达成率失败：{}", JSONObject.toJSONString(projectProgressInfoResp));
                } else {
                    List<JSONObject> projectProgressInfo = projectProgressInfoResp.getData();
                    Map<String, Object> projectArchiveRateMap = new HashMap<>();
                    if(CollectionUtils.isNotEmpty(projectProgressInfo)) {
                        projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get("projectId").toString(),
                                item -> item.get("rate"))));
                    }
                    projects.stream().forEach(item -> {
                        //借用字段存储项目达成率
                        if(projectArchiveRateMap.containsKey(item.get("id").toString())) {
                            item.put("nodeArchiveRateInMonth", new BigDecimal(projectArchiveRateMap.get(item.get("id").toString()).toString()));
                        } else {
                            item.put("nodeArchiveRateInMonth", BigDecimal.ZERO);
                        }
                    });
                }
            }

            Map<String, Object> queryParams = new HashMap<>();

            queryParams.put("checkMonth", params.get("checkMonth").getValue().toString());
            queryParams.put("month", Integer.valueOf(params.get("checkMonth").getValue().toString().split("-")[1]));
            queryParams.put("checkDate", checkDate);
            queryParams.put("projects", projects);
            queryParams.put("projectIds", projectIds);

            if(!orderMap.isEmpty()) {
                StringBuilder sp = new StringBuilder();
                for(String key : orderMap.keySet()) {
                    sp.append(key).append(" ").append(orderMap.get(key)).append(",");
                }
                queryParams.put("order", sp.substring(0,sp.length()-1));
            }

            pageList = sceneInspectionService.queryDryingList(queryParams);

            if(!orderMap.containsKey("nodeArchiveRateInMonth")) {
                //查询项目月度 节点达成率
                CommonResponse<List<JSONObject>> projectProgressInfoResp = progressApi.getProjectProgress(
                        new ProgressFilterVO(pageList.stream().map(item -> Long.valueOf(item.get("projectId").toString())).collect(Collectors.toList()),
                                checkDate));
                if(!projectProgressInfoResp.isSuccess()) {
                    logger.error("查询项目达成率失败：{}", JSONObject.toJSONString(projectProgressInfoResp));
                } else {
                    List<JSONObject> projectProgressInfo = projectProgressInfoResp.getData();
                    Map<String, Object> projectArchiveRateMap = new HashMap<>();
                    if(CollectionUtils.isNotEmpty(projectProgressInfo)) {
                        projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get("projectId").toString(),
                                item -> item.get("rate"))));
                    }
                    pageList.stream().forEach(item -> {
                        if(projectArchiveRateMap.containsKey(item.get("projectId").toString())) {
                            item.put("nodeArchiveRateInMonth", projectArchiveRateMap.get(item.get("projectId").toString()));
                        } else {
                            item.put("nodeArchiveRateInMonth", 0);
                        }
                    });
                }
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageList);
        ExcelExport.getInstance().exportWithTrans("SceneDryingManage-export.xlsx", beans, response);
    }

}
