/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.NoticeEnum;
import com.ejianc.business.scene.util.OverdueState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/overdueWarn"})
public class OverdueWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private CheckMessageService checkMessageService;
    private static Integer INTERVAL = 2;

    @RequestMapping(value={"/overdue"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SceneCheckDetailVO>> overdue(HttpServletRequest request) {
        this.logger.info("\u63a5\u6536\u5230\u73b0\u573a\u7ba1\u7406Task\u53c2\u6570\uff1a{}", (Object)request);
        this.service.updateSceneCheckOverdue();
        this.service.updateSceneCheckOverdueNumber();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("is_overdue", new Parameter("ne", (Object)Integer.parseInt(OverdueState.OVERDUE_STATE.getCode())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.or();
        wrapper.apply("is_overdue is null", new Object[0]);
        List sceneCheckDetails = this.sceneCheckDetailService.list((Wrapper)wrapper);
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)sceneCheckDetails)) {
            sceneCheckDetails.forEach(item -> {
                String today;
                String finishDate = DateUtil.format((Date)item.getFinishDate(), (String)"yyyy-MM-dd");
                long finishTime = DateUtil.parse((String)finishDate).getTime();
                long l = (finishTime - DateUtil.parse((String)(today = DateUtil.today())).getTime()) / 86400000L;
                if (l <= 2L && finishTime - DateUtil.parse((String)today).getTime() > 0L) {
                    list.add(item);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(list)) {
            List sceneCheckVOList;
            List sceneCheckEntities;
            QueryParam reformQueryParam;
            List ids;
            List<SceneCheckDetailEntity> entityList;
            Map<Integer, List<SceneCheckDetailEntity>> map = list.stream().collect(Collectors.groupingBy(SceneCheckDetailEntity::getIsReform));
            if (map.containsKey(Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()))) {
                entityList = map.get(Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                ids = entityList.stream().map(SceneCheckDetailEntity::getPid).distinct().collect(Collectors.toList());
                reformQueryParam = new QueryParam();
                reformQueryParam.getParams().put("id", new Parameter("in", ids));
                sceneCheckEntities = this.service.queryList(reformQueryParam);
                if (CollectionUtils.isNotEmpty((Collection)sceneCheckEntities)) {
                    sceneCheckVOList = BeanMapper.mapList((Iterable)sceneCheckEntities, SceneCheckVO.class);
                    sceneCheckVOList.forEach(item -> {
                        String reformDutyId = item.getReformDutyId();
                        if (reformDutyId != null) {
                            String[] reformDutyIds = reformDutyId.split(",");
                            QueryParam queryDetailParam = new QueryParam();
                            queryDetailParam.getParams().put("pid", new Parameter("eq", (Object)item.getId()));
                            queryDetailParam.getParams().put("is_reform", new Parameter("eq", (Object)Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode())));
                            queryDetailParam.getParams().put("is_overdue", new Parameter("ne", (Object)Integer.parseInt(OverdueState.OVERDUE_STATE.getCode())));
                            int size = this.sceneCheckDetailService.queryList(queryDetailParam).size();
                            item.setMsgNum(Integer.valueOf(size));
                            item.setMsgBillCode("0");
                            item.setMsgId(Long.valueOf(Long.parseLong("0")));
                            this.checkMessageService.sendMsg((SceneCheckVO)item, reformDutyIds, NoticeEnum.REFORM_OVERTIME);
                        }
                    });
                }
            }
            if (map.containsKey(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()))) {
                entityList = map.get(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
                ids = entityList.stream().map(SceneCheckDetailEntity::getPid).distinct().collect(Collectors.toList());
                reformQueryParam = new QueryParam();
                reformQueryParam.getParams().put("id", new Parameter("in", ids));
                sceneCheckEntities = this.service.queryList(reformQueryParam);
                if (CollectionUtils.isNotEmpty((Collection)sceneCheckEntities)) {
                    sceneCheckVOList = BeanMapper.mapList((Iterable)sceneCheckEntities, SceneCheckVO.class);
                    sceneCheckVOList.forEach(item -> {
                        String reviewIds = item.getReviewId();
                        if (reviewIds != null) {
                            String[] reviewPersonIs = reviewIds.split(",");
                            QueryParam queryDetailParam = new QueryParam();
                            queryDetailParam.getParams().put("pid", new Parameter("eq", (Object)item.getId()));
                            queryDetailParam.getParams().put("is_reform", new Parameter("eq", (Object)Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())));
                            queryDetailParam.getParams().put("is_overdue", new Parameter("ne", (Object)Integer.parseInt(OverdueState.OVERDUE_STATE.getCode())));
                            int size = this.sceneCheckDetailService.queryList(queryDetailParam).size();
                            item.setMsgNum(Integer.valueOf(size));
                            item.setMsgBillCode("0");
                            item.setMsgId(Long.valueOf(Long.parseLong("0")));
                            this.checkMessageService.sendMsg((SceneCheckVO)item, reviewPersonIs, NoticeEnum.REVIEW_OVERTIME);
                        }
                    });
                }
            }
        }
        List SceneCheckList = BeanMapper.mapList((Iterable)sceneCheckDetails, SceneCheckDetailVO.class);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01", (Object)SceneCheckList);
    }
}

