package com.ejianc.business.scene.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.scene.vo.CheckDetailReportVO;
import com.ejianc.business.scene.vo.DangerReportVo;
import com.ejianc.business.scene.vo.NewProblemVo;
import com.ejianc.business.scene.vo.XcjcsssjhzVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.scene.bean.SceneCheckEntity;

import java.util.Date;
import java.util.List;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
public interface ISceneCheckService extends IBaseService<SceneCheckEntity> {


    /**
     *  检查单提交后的操作
     * @param billId 检查单id
     */
    public void checkSubmitHandle(Long billId);

    /**
     * 检查单弃审前的操作
     * @param billId
     */
    public boolean checkRevokeBeforeHandle(Long billId);

    /**
     * 检查单弃审后的操作
     * @param billId
     */
    public void checkRevokeAfterHandle(Long billId);

    /**
     *  修改逾期状态和检查结果状态描述
     */
    public void updateSceneCheckOverdue();
    /**
     *  修改逾期数量
     */
    public void updateSceneCheckOverdueNumber();

	List<XcjcsssjhzVO> getXcjcsssjhz(List<Long> orgIds, String jcxSort, String dzgSort, String yqwzgSort);

	/**
	 * @description: 现场检查台账
	 *
	 * @param page
	 * @param param
	 * @param orgIds
     * @return {@link List< CheckDetailReportVO>}
	 * @author songlx
	 * @date: 2023/10/25
	 */
    List<CheckDetailReportVO> queryCheckItemList(IPage<CheckDetailReportVO> page, QueryParam param, List<Long> orgIds);

    /**
     *  移动端-现场检查数量统计
     */
    JSONObject queryCheckItemCount(QueryParam param);

    List<NewProblemVo> queryNewProblemReport(String date);

    List<DangerReportVo> queryDangerReport(String date);

    JSONObject queryProblemTopN(Integer topN,Long projectId);

}
