package com.ejianc.business.scene.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 检查单主表
 *
 * @author generator
 */
@Service("sceneCheckService")
public class SceneCheckServiceImpl extends BaseServiceImpl<SceneCheckMapper, SceneCheckEntity>
    implements ISceneCheckService {

  @Autowired private ISceneCheckDetailService sceneCheckDetailService;

  @Autowired private ISceneCheckRecordService sceneCheckRecordService;
  @Autowired private SceneCheckMapper sceneCheckMapper;
  @Autowired private CheckMessageService checkMessageService;
    @Autowired
    private IOrgApi iOrgApi;

  @Value("${common.env.base-host}")
  private String baseHost;

  /**
   * 检查单提交后的操作
   *
   * @param billId 检查单id
   */
  @Override
  public void checkSubmitHandle(Long billId) {

    if (billId != null) {
      SceneCheckEntity sceneCheckEntity = this.selectById(billId);

      // 检查单提交后，修改复查状态为 1
      LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
      updateWrapper.eq(SceneCheckEntity::getId, billId);
      updateWrapper.set(
          SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REFORM_STATE.getCode()));
      updateWrapper.set(
          SceneCheckEntity::getReviewItem, sceneCheckEntity.getSceneCheckDetails().size());
      updateWrapper.set(
          SceneCheckEntity::getReviewStatus, Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
      this.update(updateWrapper);

      // 检查单提交后 检查项状态改为待整改
      List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
      sceneCheckDetails.forEach(
          d -> {
            LambdaUpdateWrapper<SceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(SceneCheckDetailEntity::getId, d.getId());
            wrapper.set(
                SceneCheckDetailEntity::getIsReform,
                Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
            wrapper.set(
                SceneCheckDetailEntity::getTaskState,
                CheckItemReformState.REFORM_STATE.getDescription());
            sceneCheckDetailService.update(wrapper);
          });

      List<SceneCheckRecordEntity> list = new ArrayList<>();
      List<SceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
      // 检查单提交后，生成检查信息记录
      sceneCheckDetaillist.forEach(
          item -> {
            SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
            sceneCheckRecord.setPid(item.getId());
            sceneCheckRecord.setCheckId(item.getPid());
            // 设置操作状态
            sceneCheckRecord.setOperationType(
                Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            sceneCheckRecord.setReviewPerson(item.getReviewPerson());
            sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
            sceneCheckRecord.setReviewResult(item.getReviewResult());
            sceneCheckRecord.setImgIds(item.getProblemImgIds());
            sceneCheckRecord.setCheckPerson(item.getCheckPerson());
            sceneCheckRecord.setCheckItem(item.getCheckItem());
            sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
            sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
            list.add(sceneCheckRecord);
          });
      sceneCheckRecordService.saveBatch(list, list.size());

      sceneCheckEntity = this.selectById(billId);
      SceneCheckVO vo = BeanMapper.map(sceneCheckEntity, SceneCheckVO.class);
      // 待整改检查项发 送消息
      String reformDutyId = vo.getReformDutyId();
      String notifRelevantId = vo.getNotifRelevantId();

      vo.setMsgNum(vo.getSceneCheckDetails().size());
      vo.setMsgBillCode(vo.getBillCode());
      vo.setMsgId(vo.getId());

      if (StringUtils.isNotBlank(reformDutyId)) {
        String[] reformDuty = reformDutyId.split(",");
        // 发送消息给整改人
        checkMessageService.sendMsg(vo, reformDuty, NoticeEnum.CHECK_COMMIT_PASS);
      }
      if (StringUtils.isNotBlank(notifRelevantId)) {
        String[] notifRelevant = notifRelevantId.split(",");
        // 发送消息给需要通知人员
        checkMessageService.sendMsg(vo, notifRelevant, NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
      }
    }
  }

  /**
   * 检查单弃审前的操作
   *
   * @param billId
   */
  @Override
  public boolean checkRevokeBeforeHandle(Long billId) {
    boolean flag = true;
    // 检查单弃审前，查询记录表中是否有整改记录
    SceneCheckEntity sceneCheckEntity = this.selectById(billId);
    QueryParam param = new QueryParam();
    param.getParams().put("checkId", new Parameter(QueryParam.EQ, sceneCheckEntity.getId()));
    param.getParams().put(
            "operationType",
            new Parameter(QueryParam.EQ, Integer.parseInt(OperationState.REFORM_STATE.getCode())));
    List<SceneCheckRecordEntity> list = sceneCheckRecordService.queryList(param, false);
    if (list.size() > 0) {
      flag = false;
    }
    return flag;
  }

  /**
   * 检查单弃审后操作
   *
   * @param billId 单据id
   */
  @Override
  public void checkRevokeAfterHandle(Long billId) {
    if (billId != null) {
      SceneCheckEntity sceneCheckEntity = this.selectById(billId);
      // 检查单弃审后，修改复查状态为 0
      LambdaUpdateWrapper<SceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
      updateWrapper.eq(SceneCheckEntity::getId, billId);
      updateWrapper.set(
          SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
      updateWrapper.set(
          SceneCheckEntity::getReviewItem, sceneCheckEntity.getSceneCheckDetails().size());
      updateWrapper.set(SceneCheckEntity::getReviewStatus, null);
      this.update(updateWrapper);

      // 检查单弃审后 检查项状态改为默认值 0
      List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
      sceneCheckDetails.forEach(
          d -> {
            LambdaUpdateWrapper<SceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(SceneCheckDetailEntity::getId, d.getId());
            wrapper.set(
                SceneCheckDetailEntity::getIsReform,
                Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            wrapper.set(
                SceneCheckDetailEntity::getTaskState, CheckItemReformState.DEFULT_STATE.getCode());
            sceneCheckDetailService.update(wrapper);
          });

      // 检查单弃审后，要删除记录表中检查单的检查记录  检查单id 和 操作类型为检查
      LambdaUpdateWrapper<SceneCheckRecordEntity> deleteWrapper = new LambdaUpdateWrapper<>();
      deleteWrapper.eq(SceneCheckRecordEntity::getCheckId, sceneCheckEntity.getId());
      deleteWrapper.set(
          SceneCheckRecordEntity::getOperationType,
          Integer.parseInt(OperationState.CHECK_STATE.getCode()));
      sceneCheckRecordService.remove(deleteWrapper);
    }
  }

  @Override
  public void updateSceneCheckOverdue() {
    sceneCheckMapper.updateSceneCheckOverdue();
  }

  @Override
  public void updateSceneCheckOverdueNumber() {
    sceneCheckMapper.updateSceneCheckOverdueNumber();
  }

  @Override
  public List<XcjcsssjhzVO> getXcjcsssjhz(
      List<Long> orgIds, String jcxSort, String dzgSort, String yqwzgSort) {
    return baseMapper.getXcjcsssjhz(orgIds, jcxSort, dzgSort, yqwzgSort);
  }

    /**
     * @description: 现场检查台账
     *
     * @param page
     * @param param
     * @param orgIds
     * @return {@link List< CheckDetailReportVO>}
     * @author songlx
     * @date: 2023/10/25
     */
    @Override
    public List<CheckDetailReportVO> queryCheckItemList(IPage<CheckDetailReportVO> page, QueryParam param, List<Long> orgIds) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<CheckDetailReportVO> list = baseMapper.queryCheckItemList(page, wrapper, orgIds);
        return list;
    }

    /**
     *  移动端-现场检查数量统计
     * @param param
     */
    @Override
    public JSONObject queryCheckItemCount(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        return baseMapper.queryCheckItemCount(wrapper);
    }

    @Override
    public List<NewProblemVo> queryNewProblemReport(String date) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        List<NewProblemVo> newProblemVos = baseMapper.queryNewProblemReport(date,tenantid);
        if (newProblemVos.size()>0){
            Map<Long, List<NewProblemVo>> collect = newProblemVos.stream().collect(Collectors.groupingBy(NewProblemVo::getCheckAttr));
            Long zhiLiangJianCha = Long.valueOf("1");
            Long anQuanJianCha = Long.valueOf("2");
            List<NewProblemVo> newProblemVosZhiLiang = collect.get(zhiLiangJianCha);
            List<NewProblemVo> newProblemVosAnquan = collect.get(anQuanJianCha);
            if (null!=newProblemVosZhiLiang){
                //当月新增总数量（质量检查）
                BigDecimal sumNumZhiLiang = newProblemVosZhiLiang.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                //当月未处理总数量（质量检查）
                BigDecimal sumUnProcessedZhiLiang = newProblemVosZhiLiang.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (NewProblemVo newProblemVo : collect.get(zhiLiangJianCha)) {
                    newProblemVo.setNewNumRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getNewNum(),sumNumZhiLiang,2)+"%");
                    newProblemVo.setUnProcessedRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getUnProcessed(),sumUnProcessedZhiLiang,2)+"%");
                }
            }
            if (null!=newProblemVosAnquan){
                //当月新增总数量（安全检查）
                BigDecimal sumNumAnQuan = newProblemVosAnquan.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                //当月未处理总数量（安全检查）
                BigDecimal sumUnProcessedAnQuan = newProblemVosAnquan.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (NewProblemVo newProblemVo : collect.get(anQuanJianCha)) {
                    newProblemVo.setNewNumRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getNewNum(),sumNumAnQuan,2)+"%");
                    newProblemVo.setUnProcessedRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getUnProcessed(),sumUnProcessedAnQuan,2)+"%");
                }
            }
        }
        return newProblemVos;
    }
    @Override
    public List<DangerReportVo> queryDangerReport(String date) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        List<DangerReportVo> dangerReportVos = baseMapper.queryDangerReport(date,tenantid);
        Map<Long, Long> collect = dangerReportVos.stream().collect(Collectors.groupingBy(DangerReportVo::getProjectId, Collectors.counting()));
        for (DangerReportVo dangerReportVo : dangerReportVos) {
            dangerReportVo.setCheckAttrName(dangerReportVo.getCheckAttrName()+"检查");
            Long projectId = dangerReportVo.getProjectId();
            if (collect.containsKey(projectId)){
                Long aLong = collect.get(projectId);
                dangerReportVo.setRowSpan(aLong.intValue());
                collect.remove(projectId);
            } else {
                dangerReportVo.setRowSpan(0);
            }
        }
        return dangerReportVos;
    }

    @Override
    public JSONObject queryProblemTopN(Integer topN,Long projectId) {
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        List<NewProblemVo> newProblemVos = baseMapper.queryProblemTopN(projectId,orgIds);
        JSONObject result = new JSONObject();
        if (ListUtil.isNotEmpty(newProblemVos)) {
            List<JSONObject> jsonObjectList1 = new ArrayList();
            List<JSONObject> jsonObjectList2 = new ArrayList();
            //计算占比
            //所有问题汇总
            BigDecimal allProblem = newProblemVos.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<NewProblemVo> problemTopList = newProblemVos.stream().limit(topN).collect(Collectors.toList());
            Integer top=1;
            for (NewProblemVo newProblemVo : problemTopList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("top", top);
                jsonObject.put("checkCategory", newProblemVo.getCheckCategory());
                jsonObject.put("num", newProblemVo.getNewNum());
                jsonObject.put("ratio", ComputeUtil.bigDecimalPercent(newProblemVo.getNewNum(), allProblem, 2) + "%");
                if (topN>top){
                    top++;
                }
                jsonObjectList1.add(jsonObject);
            }
            result.put("problemTotal", jsonObjectList1);
            //问题销项排序
            List<NewProblemVo> ratioList = newProblemVos.stream().sorted(Comparator.comparing(NewProblemVo::getUnProcessed).reversed()).collect(Collectors.toList());

            List<NewProblemVo> problemTopListLimit = ratioList.stream().limit(topN).collect(Collectors.toList());
            //计算问题未处理总数
            BigDecimal allUnProcessed = newProblemVos.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
            Integer top1=1;
            for (NewProblemVo newProblemVo : problemTopListLimit) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("top", top1);
                jsonObject.put("checkCategory", newProblemVo.getCheckCategory());
                jsonObject.put("num", newProblemVo.getUnProcessed());
                jsonObject.put("ratio", ComputeUtil.bigDecimalPercent(newProblemVo.getUnProcessed(), allUnProcessed, 2) + "%");
                if (topN>top1){
                    top1++;
                }
                jsonObjectList2.add(jsonObject);

            }
            result.put("unProblemRatio", jsonObjectList2);
        }
        return result;
    }


}
