/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneQualityCheckItemEntity;
import com.ejianc.business.scene.bean.SceneSafetyCheckItemEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.service.ISceneQualityCheckItemService;
import com.ejianc.business.scene.service.ISceneSafetyCheckItemService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.GetAutoCode;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.vo.CheckDetailReportVO;
import com.ejianc.business.scene.vo.DangerReportVo;
import com.ejianc.business.scene.vo.NewProblemVo;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"sceneCheck"})
@Api(value="\u68c0\u67e5\u5355\u4e3b\u8868", tags={"\u68c0\u67e5\u5355\u4e3b\u8868"})
public class SceneCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCENE_CHECK_CODE";
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService detailService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;
    @Autowired
    ICommonBusinessService sceneCheck;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ISceneSafetyCheckItemService safetyCheckItemService;
    @Autowired
    private ISceneQualityCheckItemService qualityCheckItemService;

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<SceneCheckEntity> checkList = new ArrayList<SceneCheckEntity>();
        ArrayList<SceneCheckDetailEntity> detailList = new ArrayList<SceneCheckDetailEntity>();
        if (result != null && result.size() > 0) {
            CommonResponse listCommonResponse = this.projectApi.queryProjectList(20);
            List list = (List)listCommonResponse.getData();
            LambdaQueryWrapper safetyItemWrapper = new LambdaQueryWrapper();
            safetyItemWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            List safeDocList = this.safetyCheckItemService.list((Wrapper)safetyItemWrapper);
            Map safeDocMap = safeDocList.stream().collect(Collectors.toMap(SceneSafetyCheckItemEntity::getCode, Function.identity()));
            LambdaQueryWrapper squlityItemWrapper = new LambdaQueryWrapper();
            squlityItemWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            List qualityDocList = this.qualityCheckItemService.list((Wrapper)squlityItemWrapper);
            Map qualityDocMap = qualityDocList.stream().collect(Collectors.toMap(SceneQualityCheckItemEntity::getCode, Function.identity()));
            Map projectMap = list.stream().collect(Collectors.toMap(ProjectRegisterVO::getName, Function.identity()));
            String importTs = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            int num = 1;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SceneCheckEntity checkEntity = new SceneCheckEntity();
                checkEntity.setId(IdWorker.getId());
                checkEntity.setImportTs(Long.valueOf(importTs));
                checkEntity.setBillState(1);
                String formatted = String.format("%04d", num);
                ++num;
                checkEntity.setBillCode("JC-" + importTs.substring(0, 6) + formatted);
                String projectName = ((String)datas.get(0)).trim();
                ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)projectMap.get(projectName);
                checkEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                checkEntity.setOrgName(projectRegisterVO.getName());
                checkEntity.setProjectId(projectRegisterVO.getId());
                checkEntity.setProjectName(projectRegisterVO.getName());
                String checkName = ((String)datas.get(1)).trim();
                checkEntity.setCheckName(checkName);
                String checkDateStr = ((String)datas.get(2)).trim();
                Date checkDate = HSSFDateUtil.getJavaDate((double)Double.valueOf(checkDateStr));
                checkEntity.setCheckDate(checkDate);
                String checkTypeName = ((String)datas.get(3)).trim();
                checkEntity.setCheckTypeName(checkTypeName);
                if (checkTypeName.equals("\u5b89\u5168\u68c0\u67e5")) {
                    checkEntity.setCheckType(1448208197734875138L);
                    checkEntity.setCheckAttr(2);
                    checkEntity.setCheckAttrName("\u5b89\u5168");
                } else {
                    checkEntity.setCheckType(1448208377016205313L);
                    checkEntity.setCheckAttr(1);
                    checkEntity.setCheckAttrName("\u8d28\u91cf");
                }
                String checkLevel = ((String)datas.get(4)).trim();
                checkEntity.setCheckLevel(checkLevel.equals("\u9879\u76ee") ? 1 : 2);
                String checkPerson = ((String)datas.get(5)).trim();
                checkEntity.setCheckPerson(checkPerson);
                String reform_duty_person = ((String)datas.get(6)).trim();
                checkEntity.setReformDutyPerson(reform_duty_person);
                String finishDateStr = ((String)datas.get(10)).trim();
                Date finishDate = HSSFDateUtil.getJavaDate((double)Double.valueOf(finishDateStr));
                checkEntity.setFinishDate(finishDate);
                SceneCheckDetailEntity sceneCheckDetailEntity = (SceneCheckDetailEntity)((Object)BeanMapper.map((Object)((Object)checkEntity), SceneCheckDetailEntity.class));
                sceneCheckDetailEntity.setId(IdWorker.getId());
                sceneCheckDetailEntity.setPid(checkEntity.getId());
                sceneCheckDetailEntity.setBillCode(checkEntity.getBillCode() + "-01");
                String itemCateCode = ((String)datas.get(8)).trim();
                SceneSafetyCheckItemEntity safetyCheckItemEntity = (SceneSafetyCheckItemEntity)((Object)safeDocMap.get(itemCateCode));
                if (safetyCheckItemEntity != null) {
                    sceneCheckDetailEntity.setCheckCategoryId(safetyCheckItemEntity.getCategoryId());
                    sceneCheckDetailEntity.setCheckCategory(safetyCheckItemEntity.getCategoryName());
                    sceneCheckDetailEntity.setCheckItemId(safetyCheckItemEntity.getId());
                    sceneCheckDetailEntity.setCheckItem(safetyCheckItemEntity.getName());
                } else {
                    SceneQualityCheckItemEntity qualityCheckItemEntity = (SceneQualityCheckItemEntity)((Object)qualityDocMap.get(itemCateCode));
                    sceneCheckDetailEntity.setCheckCategoryId(qualityCheckItemEntity.getCategoryId());
                    sceneCheckDetailEntity.setCheckCategory(qualityCheckItemEntity.getCategoryName());
                    sceneCheckDetailEntity.setCheckItemId(qualityCheckItemEntity.getId());
                    sceneCheckDetailEntity.setCheckItem(qualityCheckItemEntity.getName());
                }
                String danger_level = ((String)datas.get(9)).trim();
                if ("\u4e00\u822c".equals(danger_level)) {
                    sceneCheckDetailEntity.setDangerLevel(0);
                } else if ("\u4e25\u91cd".equals(danger_level)) {
                    sceneCheckDetailEntity.setDangerLevel(1);
                } else {
                    sceneCheckDetailEntity.setDangerLevel(2);
                }
                String part = ((String)datas.get(11)).trim();
                sceneCheckDetailEntity.setPart(part);
                String memo = ((String)datas.get(12)).trim();
                sceneCheckDetailEntity.setMemo(memo);
                checkEntity.setReviewItem(1);
                sceneCheckDetailEntity.setRectificationPerson(reform_duty_person);
                String taskState = "\u6574\u6539\u5408\u683c";
                String reformDateStr = ((String)datas.get(13)).trim();
                Date reformDate = HSSFDateUtil.getJavaDate((double)Double.valueOf(reformDateStr));
                String reformMsg = ((String)datas.get(14)).trim();
                String currentRectificationPerson = ((String)datas.get(15)).trim();
                String reviewDescribe = ((String)datas.get(16)).trim();
                String reviewDateStr = ((String)datas.get(17)).trim();
                Date reviewDate = HSSFDateUtil.getJavaDate((double)Double.valueOf(reviewDateStr));
                String actualReviewer = ((String)datas.get(18)).trim();
                checkEntity.setReviewPerson(actualReviewer);
                sceneCheckDetailEntity.setTaskState(taskState);
                if (sceneCheckDetailEntity.getTaskState().equals("\u5f85\u6574\u6539")) {
                    sceneCheckDetailEntity.setBillState(0);
                    sceneCheckDetailEntity.setIsReform(1);
                    sceneCheckDetailEntity.setReformNumber(0);
                    checkEntity.setReformStatus(1);
                    checkEntity.setReviewStatus(0);
                    sceneCheckDetailEntity.setReviewResult(0);
                } else if (sceneCheckDetailEntity.getTaskState().equals("\u5f85\u590d\u67e5")) {
                    sceneCheckDetailEntity.setBillState(1);
                    sceneCheckDetailEntity.setIsReform(2);
                    sceneCheckDetailEntity.setReformNumber(1);
                    sceneCheckDetailEntity.setCurrentRectificationPerson(currentRectificationPerson);
                    sceneCheckDetailEntity.setReformDate(reformDate);
                    checkEntity.setReformFinishDate(reformDate);
                    sceneCheckDetailEntity.setReformMsg(reformMsg);
                    sceneCheckDetailEntity.setReformNews(sceneCheckDetailEntity.getCurrentRectificationPerson() + "-" + DateUtil.formatDate((Date)sceneCheckDetailEntity.getReformDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReformMsg()).orElse(""));
                    sceneCheckDetailEntity.setReviewResult(0);
                    sceneCheckDetailEntity.setActualReviewer(actualReviewer);
                    sceneCheckDetailEntity.setReviewDate(reviewDate);
                    sceneCheckDetailEntity.setReviewDescribe(null);
                    sceneCheckDetailEntity.setReviewMsg(sceneCheckDetailEntity.getActualReviewer() + "-" + DateUtil.formatDate((Date)sceneCheckDetailEntity.getReviewDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReviewDescribe()).orElse(""));
                    checkEntity.setReformStatus(2);
                    checkEntity.setReviewStatus(0);
                } else if (sceneCheckDetailEntity.getTaskState().equals("\u6574\u6539\u5408\u683c")) {
                    sceneCheckDetailEntity.setBillState(1);
                    sceneCheckDetailEntity.setIsReform(3);
                    sceneCheckDetailEntity.setReformNumber(1);
                    sceneCheckDetailEntity.setCurrentRectificationPerson(currentRectificationPerson);
                    sceneCheckDetailEntity.setReformDate(reformDate);
                    checkEntity.setReformFinishDate(reformDate);
                    checkEntity.setReviewedNum(1);
                    checkEntity.setReviewPass(1);
                    checkEntity.setReviewStatus(1);
                    sceneCheckDetailEntity.setReformMsg(reformMsg);
                    sceneCheckDetailEntity.setReformNews(sceneCheckDetailEntity.getCurrentRectificationPerson() + "-" + DateUtil.formatDate((Date)sceneCheckDetailEntity.getReformDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReformMsg()).orElse(""));
                    sceneCheckDetailEntity.setReviewResult(1);
                    sceneCheckDetailEntity.setActualReviewer(actualReviewer);
                    sceneCheckDetailEntity.setReviewDate(reviewDate);
                    sceneCheckDetailEntity.setReviewDescribe(reviewDescribe);
                    sceneCheckDetailEntity.setReviewMsg(sceneCheckDetailEntity.getActualReviewer() + "-" + DateUtil.formatDate((Date)sceneCheckDetailEntity.getReviewDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReviewDescribe()).orElse(""));
                    checkEntity.setReformStatus(4);
                    checkEntity.setReviewStatus(1);
                    checkEntity.setReviewPass(1);
                } else if (sceneCheckDetailEntity.getTaskState().equals("\u6574\u6539\u4e0d\u5408\u683c")) {
                    sceneCheckDetailEntity.setBillState(0);
                    sceneCheckDetailEntity.setIsReform(4);
                    sceneCheckDetailEntity.setReformNumber(1);
                    sceneCheckDetailEntity.setCurrentRectificationPerson(currentRectificationPerson);
                    sceneCheckDetailEntity.setReformDate(reformDate);
                    checkEntity.setReformFinishDate(reformDate);
                    sceneCheckDetailEntity.setReformMsg(reformMsg);
                    sceneCheckDetailEntity.setReformNews(sceneCheckDetailEntity.getCurrentRectificationPerson() + "-" + DateUtil.formatDate((Date)sceneCheckDetailEntity.getReformDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReformMsg()).orElse(""));
                    sceneCheckDetailEntity.setReviewResult(2);
                    sceneCheckDetailEntity.setActualReviewer(actualReviewer);
                    sceneCheckDetailEntity.setReviewDate(reviewDate);
                    sceneCheckDetailEntity.setReviewDescribe(reviewDescribe);
                    sceneCheckDetailEntity.setReviewMsg(sceneCheckDetailEntity.getActualReviewer() + "-" + DateUtil.formatDate((Date)sceneCheckDetailEntity.getReviewDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReviewDescribe()).orElse(""));
                    checkEntity.setReformStatus(3);
                    checkEntity.setReviewStatus(1);
                }
                checkList.add(checkEntity);
                detailList.add(sceneCheckDetailEntity);
            }
            this.service.saveOrUpdateBatch(checkList);
            this.detailService.saveOrUpdateBatch(detailList);
        }
        return CommonResponse.success();
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6d88\u606f")
    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckVO> test(@RequestParam Long id) {
        this.sceneCheck.afterApprovalProcessor(id, null, null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryNewProblemReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<NewProblemVo>> queryNewProblemReport(@RequestParam String date, @RequestParam Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u65b0\u589e\u95ee\u9898\u5360\u6bd4\u8868", this.service.queryNewProblemReport(date, projectId));
    }

    @RequestMapping(value={"/queryDangerReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DangerReportVo>> queryDangerReport(@RequestParam String date) {
        return CommonResponse.success((String)"\u67e5\u8be2\u98ce\u9669\u8bc6\u522b\u6c47\u603b\u8868\u6210\u529f", this.service.queryDangerReport(date));
    }

    @RequestMapping(value={"/queryProblemTopN"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryProblemTopN(@RequestParam(value="topN", defaultValue="5") Integer topN, @RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u95ee\u9898TOP5\u6210\u529f", (Object)this.service.queryProblemTopN(topN, projectId));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SceneCheckVO saveorUpdateVO) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SceneCheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setReformStatus(Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
        }
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        int count = 0;
        for (SceneCheckDetailEntity sceneCheckDetail : sceneCheckDetails) {
            if (sceneCheckDetail.getRowState() == null || !"del".equals(sceneCheckDetail.getRowState())) {
                ++count;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sceneCheckDetail.getBillCode())) {
                    sceneCheckDetail.setBillCode(entity.getBillCode() + "-" + GetAutoCode.getTowPipelineNumbers((int)count));
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sceneCheckDetail.getCheckName())) {
                sceneCheckDetail.setCheckName(entity.getCheckName());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sceneCheckDetail.getProjectName())) {
                sceneCheckDetail.setProjectName(entity.getProjectName());
            }
            if (sceneCheckDetail.getIsReform() == null) {
                sceneCheckDetail.setIsReform(Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            }
            if (sceneCheckDetail.getCheckType() == null) {
                sceneCheckDetail.setCheckType(entity.getCheckType());
                sceneCheckDetail.setCheckTypeName(entity.getCheckTypeName());
            }
            if (sceneCheckDetail.getReformNumber() == null) {
                sceneCheckDetail.setReformNumber(0);
            }
            sceneCheckDetail.setCheckAttr(entity.getCheckAttr());
            sceneCheckDetail.setCheckAttrName(entity.getCheckAttrName());
        }
        entity.setReviewItem(count);
        this.service.saveOrUpdate((Object)entity, false);
        List<SceneCheckDetailEntity> sceneCheckDetails1 = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails1, SceneCheckDetailVO.class);
        sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)this.service.selectById(id));
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        }
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SceneCheckVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u68c0\u67e5\u5355\u5217\u8868\u67e5\u8be2")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List sceneCheckVOS = BeanMapper.mapList((Iterable)list, SceneCheckVO.class);
        if (CollectionUtils.isNotEmpty((Collection)sceneCheckVOS)) {
            sceneCheckVOS.forEach(t -> {
                if (t.getCheckLevel() != null) {
                    t.setCheckLevelName(1 == t.getCheckLevel() ? "\u9879\u76ee" : "\u516c\u53f8");
                }
            });
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().exportWithTrans("SceneCheck-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSceneCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> refSceneCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u73b0\u573a\u68c0\u67e5\u53f0\u8d26")
    @RequestMapping(value={"/queryCheckItemList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckDetailReportVO>> queryCheckItemList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<CheckDetailReportVO> list = this.service.queryCheckItemList((IPage<CheckDetailReportVO>)page, param, orgIds);
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ApiOperation(value="\u73b0\u573a\u68c0\u67e5\u53f0\u8d26- \u5bfc\u51fa")
    @RequestMapping(value={"/exportCheckItemList"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportCheckItemList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<CheckDetailReportVO> list = this.service.queryCheckItemList((IPage<CheckDetailReportVO>)page, param, orgIds);
        HashMap<String, List<CheckDetailReportVO>> beans = new HashMap<String, List<CheckDetailReportVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("CheckItemList-export.xlsx", beans, response);
    }

    @ApiOperation(value="queryCheckItemCount")
    @RequestMapping(value={"/queryCheckItemCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCheckItemCount(@RequestBody QueryParam param) {
        param.getParams().put("c.tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("c.orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("c.orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        JSONObject obj = this.service.queryCheckItemCount(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)obj);
    }

    public static void main(String[] args) {
        System.out.println("2023121309".substring(2, 8));
    }
}

