/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.bean.SceneQualityCheckCategoryEntity;
import com.ejianc.business.scene.bean.SceneSafetyCheckCategoryEntity;
import com.ejianc.business.scene.mapper.SceneCheckMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.service.ISceneQualityCheckCategoryService;
import com.ejianc.business.scene.service.ISceneSafetyCheckCategoryService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.DateUtil;
import com.ejianc.business.scene.util.NoticeEnum;
import com.ejianc.business.scene.util.OperationState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.util.SubmitState;
import com.ejianc.business.scene.vo.CheckDetailReportVO;
import com.ejianc.business.scene.vo.DangerReportVo;
import com.ejianc.business.scene.vo.NewProblemVo;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.vo.XcjcsssjhzVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sceneCheckService")
public class SceneCheckServiceImpl
extends BaseServiceImpl<SceneCheckMapper, SceneCheckEntity>
implements ISceneCheckService {
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SceneCheckMapper sceneCheckMapper;
    @Autowired
    private CheckMessageService checkMessageService;
    @Autowired
    private ISceneQualityCheckCategoryService sceneQualityCheckCategoryService;
    @Autowired
    private ISceneSafetyCheckCategoryService sceneSafetyCheckCategoryService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public void checkSubmitHandle(Long billId) {
        if (billId != null) {
            SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update((Wrapper)updateWrapper);
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REFORM_STATE.getDescription());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            ArrayList list = new ArrayList();
            List<SceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetaillist.forEach(item -> {
                SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getProblemImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            this.sceneCheckRecordService.saveBatch(list, list.size());
            sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)sceneCheckEntity), SceneCheckVO.class);
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();
            vo.setMsgNum(Integer.valueOf(vo.getSceneCheckDetails().size()));
            vo.setMsgBillCode(vo.getBillCode());
            vo.setMsgId(vo.getId());
            if (StringUtils.isNotBlank((CharSequence)reformDutyId)) {
                String[] reformDuty = reformDutyId.split(",");
                this.checkMessageService.sendMsg(vo, reformDuty, NoticeEnum.CHECK_COMMIT_PASS);
            }
            if (StringUtils.isNotBlank((CharSequence)notifRelevantId)) {
                String[] notifRelevant = notifRelevantId.split(",");
                this.checkMessageService.sendMsg(vo, notifRelevant, NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }
        }
    }

    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter("eq", (Object)sceneCheckEntity.getId()));
        param.getParams().put("operationType", new Parameter("eq", (Object)Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List list = this.sceneCheckRecordService.queryList(param, false);
        if (list.size() > 0) {
            flag = false;
        }
        return flag;
    }

    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if (billId != null) {
            SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus, null);
            this.update((Wrapper)updateWrapper);
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.DEFULT_STATE.getCode());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            LambdaUpdateWrapper deleteWrapper = new LambdaUpdateWrapper();
            deleteWrapper.eq(SceneCheckRecordEntity::getCheckId, (Object)sceneCheckEntity.getId());
            deleteWrapper.set(SceneCheckRecordEntity::getOperationType, (Object)Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            this.sceneCheckRecordService.remove((Wrapper)deleteWrapper);
        }
    }

    @Override
    public void updateSceneCheckOverdue() {
        this.sceneCheckMapper.updateSceneCheckOverdue();
    }

    @Override
    public void updateSceneCheckOverdueNumber() {
        this.sceneCheckMapper.updateSceneCheckOverdueNumber();
    }

    @Override
    public List<XcjcsssjhzVO> getXcjcsssjhz(List<Long> orgIds, String jcxSort, String dzgSort, String yqwzgSort) {
        return ((SceneCheckMapper)this.baseMapper).getXcjcsssjhz(orgIds, jcxSort, dzgSort, yqwzgSort);
    }

    @Override
    public List<CheckDetailReportVO> queryCheckItemList(IPage<CheckDetailReportVO> page, QueryParam param, List<Long> orgIds) {
        QueryWrapper wrapper = SceneCheckServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<CheckDetailReportVO> list = ((SceneCheckMapper)this.baseMapper).queryCheckItemList(page, wrapper, orgIds);
        return list;
    }

    @Override
    public JSONObject queryCheckItemCount(QueryParam param) {
        QueryWrapper wrapper = SceneCheckServiceImpl.changeToQueryWrapper((QueryParam)param);
        return ((SceneCheckMapper)this.baseMapper).queryCheckItemCount(wrapper);
    }

    @Override
    public JSONObject queryBoardCheckItemCount(QueryParam param) {
        QueryWrapper wrapper = SceneCheckServiceImpl.changeToQueryWrapper((QueryParam)param);
        return ((SceneCheckMapper)this.baseMapper).queryBoardCheckItemCount(wrapper);
    }

    @Override
    public List<NewProblemVo> queryNewProblemReport(String date, Long projectId) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        List<NewProblemVo> newProblemVos = ((SceneCheckMapper)this.baseMapper).queryNewProblemReport(date, tenantid, projectId);
        ArrayList res = new ArrayList();
        if (newProblemVos.size() > 0) {
            NewProblemVo newProblemVo;
            List result;
            Map<Long, String> collect2;
            List list2;
            LambdaQueryWrapper lambdaQueryWrapper1;
            ArrayList<Long> oldIdList;
            ArrayList<String> overTwoArrayList;
            HashMap<Long, Long> hashMapZhiLiang;
            List list;
            LambdaQueryWrapper lambdaQueryWrapper;
            Map<Long, List<NewProblemVo>> collect = newProblemVos.stream().collect(Collectors.groupingBy(NewProblemVo::getCheckAttr));
            Long zhiLiangJianCha = Long.valueOf("1");
            Long anQuanJianCha = Long.valueOf("2");
            List<NewProblemVo> newProblemVosZhiLiang = collect.get(zhiLiangJianCha);
            List<NewProblemVo> newProblemVosAnquan = collect.get(anQuanJianCha);
            if (null != newProblemVosZhiLiang) {
                List collectZhiLiangAll = newProblemVosZhiLiang.stream().map(NewProblemVo::getCheckCategoryId).collect(Collectors.toList());
                lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(BaseEntity::getId, collectZhiLiangAll);
                list = this.sceneQualityCheckCategoryService.list((Wrapper)lambdaQueryWrapper);
                hashMapZhiLiang = new HashMap<Long, Long>();
                overTwoArrayList = new ArrayList<String>();
                oldIdList = new ArrayList<Long>();
                for (SceneQualityCheckCategoryEntity sceneQualityCheckCategoryEntity : list) {
                    if (sceneQualityCheckCategoryEntity.getInnerCode().split("\\|").length <= 2) continue;
                    overTwoArrayList.add(sceneQualityCheckCategoryEntity.getInnerCode().split("\\|")[1]);
                    oldIdList.add(sceneQualityCheckCategoryEntity.getId());
                    hashMapZhiLiang.put(sceneQualityCheckCategoryEntity.getId(), Long.valueOf(sceneQualityCheckCategoryEntity.getInnerCode().split("\\|")[1]));
                }
                if (overTwoArrayList != null && overTwoArrayList.size() > 0) {
                    lambdaQueryWrapper1 = new LambdaQueryWrapper();
                    lambdaQueryWrapper1.in(BaseEntity::getId, overTwoArrayList);
                    list2 = this.sceneQualityCheckCategoryService.list((Wrapper)lambdaQueryWrapper1);
                    collect2 = list2.stream().collect(Collectors.toMap(BaseEntity::getId, SceneQualityCheckCategoryEntity::getName));
                    for (NewProblemVo newProblemVo2 : newProblemVosZhiLiang) {
                        if (!oldIdList.contains(newProblemVo2.getCheckCategoryId())) continue;
                        newProblemVo2.setCheckCategory(collect2.get(hashMapZhiLiang.get(newProblemVo2.getCheckCategoryId())));
                        newProblemVo2.setCheckCategoryId((Long)hashMapZhiLiang.get(newProblemVo2.getCheckCategoryId()));
                    }
                }
                result = newProblemVosZhiLiang.stream().collect(Collectors.toMap(NewProblemVo::getCheckCategoryId, a -> a, (o1, o2) -> {
                    o1.setNewNum(ComputeUtil.safeAdd((BigDecimal)o1.getNewNum(), (BigDecimal)o2.getNewNum()));
                    o1.setUnProcessed(ComputeUtil.safeAdd((BigDecimal)o1.getUnProcessed(), (BigDecimal)o2.getUnProcessed()));
                    return o1;
                })).values().stream().collect(Collectors.toList());
                BigDecimal sumNumZhiLiang = result.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumUnProcessedZhiLiang = result.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (NewProblemVo newProblemVo2 : result) {
                    newProblemVo2.setNewNumRatio(ComputeUtil.bigDecimalPercent((BigDecimal)newProblemVo2.getNewNum(), (BigDecimal)sumNumZhiLiang, (int)2) + "%");
                    newProblemVo2.setUnProcessedRatio(ComputeUtil.bigDecimalPercent((BigDecimal)newProblemVo2.getUnProcessed(), (BigDecimal)sumUnProcessedZhiLiang, (int)2) + "%");
                }
                newProblemVo = new NewProblemVo();
                newProblemVo.setCheckAttr(Long.valueOf(1L));
                newProblemVo.setNewNum(sumNumZhiLiang);
                newProblemVo.setUnProcessed(sumUnProcessedZhiLiang);
                result.add(newProblemVo);
                res.addAll(result);
            }
            if (null != newProblemVosAnquan) {
                List collectAnQuanAll = newProblemVosAnquan.stream().map(NewProblemVo::getCheckCategoryId).collect(Collectors.toList());
                lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(BaseEntity::getId, collectAnQuanAll);
                list = this.sceneSafetyCheckCategoryService.list((Wrapper)lambdaQueryWrapper);
                hashMapZhiLiang = new HashMap();
                overTwoArrayList = new ArrayList();
                oldIdList = new ArrayList();
                for (SceneSafetyCheckCategoryEntity sceneSafetyCheckCategoryEntity : list) {
                    if (sceneSafetyCheckCategoryEntity.getInnerCode().split("\\|").length <= 3) continue;
                    overTwoArrayList.add(sceneSafetyCheckCategoryEntity.getInnerCode().split("\\|")[2]);
                    oldIdList.add(sceneSafetyCheckCategoryEntity.getId());
                    hashMapZhiLiang.put(sceneSafetyCheckCategoryEntity.getId(), Long.valueOf(sceneSafetyCheckCategoryEntity.getInnerCode().split("\\|")[2]));
                }
                if (overTwoArrayList != null && overTwoArrayList.size() > 0) {
                    lambdaQueryWrapper1 = new LambdaQueryWrapper();
                    lambdaQueryWrapper1.in(BaseEntity::getId, overTwoArrayList);
                    list2 = this.sceneSafetyCheckCategoryService.list((Wrapper)lambdaQueryWrapper1);
                    collect2 = list2.stream().collect(Collectors.toMap(BaseEntity::getId, SceneSafetyCheckCategoryEntity::getName));
                    for (NewProblemVo newProblemVo2 : newProblemVosAnquan) {
                        if (!oldIdList.contains(newProblemVo2.getCheckCategoryId())) continue;
                        newProblemVo2.setCheckCategory(collect2.get(hashMapZhiLiang.get(newProblemVo2.getCheckCategoryId())));
                        newProblemVo2.setCheckCategoryId((Long)hashMapZhiLiang.get(newProblemVo2.getCheckCategoryId()));
                    }
                }
                result = newProblemVosAnquan.stream().collect(Collectors.toMap(NewProblemVo::getCheckCategoryId, a -> a, (o1, o2) -> {
                    o1.setNewNum(ComputeUtil.safeAdd((BigDecimal)o1.getNewNum(), (BigDecimal)o2.getNewNum()));
                    o1.setUnProcessed(ComputeUtil.safeAdd((BigDecimal)o1.getUnProcessed(), (BigDecimal)o2.getUnProcessed()));
                    return o1;
                })).values().stream().collect(Collectors.toList());
                BigDecimal sumNumAnQuan = result.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumUnProcessedAnQuan = result.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (NewProblemVo newProblemVo2 : collect.get(anQuanJianCha)) {
                    newProblemVo2.setNewNumRatio(ComputeUtil.bigDecimalPercent((BigDecimal)newProblemVo2.getNewNum(), (BigDecimal)sumNumAnQuan, (int)2) + "%");
                    newProblemVo2.setUnProcessedRatio(ComputeUtil.bigDecimalPercent((BigDecimal)newProblemVo2.getUnProcessed(), (BigDecimal)sumUnProcessedAnQuan, (int)2) + "%");
                }
                newProblemVo = new NewProblemVo();
                newProblemVo.setCheckAttr(Long.valueOf(2L));
                newProblemVo.setNewNum(sumNumAnQuan);
                newProblemVo.setUnProcessed(sumUnProcessedAnQuan);
                result.add(newProblemVo);
                res.addAll(result);
            }
        }
        List<Object> resLast = new ArrayList<NewProblemVo>();
        if (res != null) {
            resLast = res.stream().sorted(Comparator.comparing(NewProblemVo::getCheckAttr).reversed()).collect(Collectors.toList());
        }
        return resLast;
    }

    @Override
    public List<DangerReportVo> queryDangerReport(String date) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        List<DangerReportVo> dangerReportVos = ((SceneCheckMapper)this.baseMapper).queryDangerReport(date, tenantid);
        Map<Long, Long> collect = dangerReportVos.stream().collect(Collectors.groupingBy(DangerReportVo::getProjectId, Collectors.counting()));
        for (DangerReportVo dangerReportVo : dangerReportVos) {
            dangerReportVo.setCheckAttrName(dangerReportVo.getCheckAttrName() + "\u68c0\u67e5");
            Long projectId = dangerReportVo.getProjectId();
            if (collect.containsKey(projectId)) {
                Long aLong = collect.get(projectId);
                dangerReportVo.setRowSpan(Integer.valueOf(aLong.intValue()));
                collect.remove(projectId);
                continue;
            }
            dangerReportVo.setRowSpan(Integer.valueOf(0));
        }
        return dangerReportVos;
    }

    @Override
    public JSONObject queryProblemTopN(Integer topN, Long projectId) {
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        List<NewProblemVo> newProblemVos = ((SceneCheckMapper)this.baseMapper).queryProblemTopN(projectId, orgIds);
        JSONObject result = new JSONObject();
        if (ListUtil.isNotEmpty(newProblemVos)) {
            ArrayList<JSONObject> jsonObjectList1 = new ArrayList<JSONObject>();
            ArrayList<JSONObject> jsonObjectList2 = new ArrayList<JSONObject>();
            BigDecimal allProblem = newProblemVos.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            List problemTopList = newProblemVos.stream().limit(topN.intValue()).collect(Collectors.toList());
            Integer top = 1;
            for (NewProblemVo newProblemVo : problemTopList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("top", (Object)top);
                jsonObject.put("checkCategory", (Object)newProblemVo.getCheckCategory());
                jsonObject.put("num", (Object)newProblemVo.getNewNum());
                jsonObject.put("ratio", (Object)(ComputeUtil.bigDecimalPercent((BigDecimal)newProblemVo.getNewNum(), (BigDecimal)allProblem, (int)2) + "%"));
                if (topN > top) {
                    Integer n = top;
                    top = top + 1;
                    Integer n2 = top;
                }
                jsonObjectList1.add(jsonObject);
            }
            result.put("problemTotal", jsonObjectList1);
            List ratioList = newProblemVos.stream().sorted(Comparator.comparing(NewProblemVo::getUnProcessed).reversed()).collect(Collectors.toList());
            List problemTopListLimit = ratioList.stream().limit(topN.intValue()).collect(Collectors.toList());
            BigDecimal allUnProcessed = newProblemVos.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
            Integer top1 = 1;
            for (NewProblemVo newProblemVo : problemTopListLimit) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("top", (Object)top1);
                jsonObject.put("checkCategory", (Object)newProblemVo.getCheckCategory());
                jsonObject.put("num", (Object)newProblemVo.getUnProcessed());
                jsonObject.put("ratio", (Object)(ComputeUtil.bigDecimalPercent((BigDecimal)newProblemVo.getUnProcessed(), (BigDecimal)allUnProcessed, (int)2) + "%"));
                if (topN > top1) {
                    Integer n = top1;
                    Integer n3 = top1 = Integer.valueOf(top1 + 1);
                }
                jsonObjectList2.add(jsonObject);
            }
            result.put("unProblemRatio", jsonObjectList2);
        }
        return result;
    }

    @Override
    public JSONObject queryQualityOrSafeCount(Long projectId, String attrCode) {
        JSONObject obj = new JSONObject();
        ArrayList<Long> checkTypeIds = new ArrayList();
        CommonResponse defDocByDefId = this.defdocApi.getDefDocByDefId(Long.valueOf(503220284695396431L));
        if (!defDocByDefId.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List ddd = (List)defDocByDefId.getData();
        checkTypeIds = ddd.stream().filter(t -> attrCode.equals(t.getAttrCode())).map(BaseVO::getId).collect(Collectors.toList());
        List<XcjcsssjhzVO> xcjcsssjhzVOS = this.sceneCheckMapper.queryQualityOrSafeCount(projectId, checkTypeIds);
        if (CollectionUtils.isNotEmpty(xcjcsssjhzVOS)) {
            XcjcsssjhzVO xcjcsssjhzVO = xcjcsssjhzVOS.get(0);
            obj.put("totalJcxNum", (Object)xcjcsssjhzVO.getJcxNum());
            obj.put("totalDzgNum", (Object)xcjcsssjhzVO.getDzgNum());
            obj.put("totalDangerNum", (Object)xcjcsssjhzVO.getDangerNum());
            obj.put("totalDzgScale", (Object)ComputeUtil.bigDecimalPercent((BigDecimal)xcjcsssjhzVO.getDzgNum(), (BigDecimal)xcjcsssjhzVO.getJcxNum(), (int)2));
        } else {
            obj.put("totalJcxNum", (Object)BigDecimal.ZERO);
            obj.put("totalDzgNum", (Object)BigDecimal.ZERO);
            obj.put("totalDangerNum", (Object)BigDecimal.ZERO);
            obj.put("totalDzgScale", (Object)BigDecimal.ZERO);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, -5);
        Date time = cal.getTime();
        String startMonth = DateUtil.format((Date)time, (String)"yyyy-MM");
        String endMonth = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        List<XcjcsssjhzVO> xcjcsssjhzVOSList = this.sceneCheckMapper.queryQualityOrSafeByDate(projectId, checkTypeIds, startMonth, endMonth);
        Map<Object, Object> monthDataMap = new HashMap();
        if (CollectionUtils.isNotEmpty(xcjcsssjhzVOSList)) {
            monthDataMap = xcjcsssjhzVOSList.stream().collect(Collectors.toMap(XcjcsssjhzVO::getCheckMonth, Function.identity(), (e1, e2) -> e1));
        }
        LinkedList<JSONObject> dataList = new LinkedList<JSONObject>();
        List monthBetween = DateUtil.getMonthBetween((String)startMonth, (String)endMonth);
        for (String mon : monthBetween) {
            JSONObject js = new JSONObject();
            js.put("date", (Object)mon);
            XcjcsssjhzVO xcjcsssjhzVO = (XcjcsssjhzVO)monthDataMap.get(mon);
            if (xcjcsssjhzVO != null) {
                js.put("jcxNum", (Object)xcjcsssjhzVO.getJcxNum());
                js.put("dzgNum", (Object)xcjcsssjhzVO.getDzgNum());
                js.put("dangerNum", (Object)xcjcsssjhzVO.getDangerNum());
                js.put("dzgScale", (Object)ComputeUtil.bigDecimalPercent((BigDecimal)xcjcsssjhzVO.getDzgNum(), (BigDecimal)xcjcsssjhzVO.getJcxNum(), (int)2));
                js.put("dangerScale", (Object)ComputeUtil.bigDecimalPercent((BigDecimal)xcjcsssjhzVO.getDangerNum(), (BigDecimal)xcjcsssjhzVO.getJcxNum(), (int)2));
            } else {
                js.put("jcxNum", (Object)BigDecimal.ZERO);
                js.put("dzgNum", (Object)BigDecimal.ZERO);
                js.put("dangerNum", (Object)BigDecimal.ZERO);
                js.put("dzgScale", (Object)BigDecimal.ZERO);
                js.put("dangerScale", (Object)BigDecimal.ZERO);
            }
            dataList.add(js);
        }
        obj.put("dataList", dataList);
        return obj;
    }
}

