/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckRecordVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"reform"})
@Api(value="\u5f85\u590d\u67e5", tags={"\u68c0\u67e5\u5355\u4e3b\u5b50\u8868"})
public class ReformController {
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private ISceneCheckService sceneCheckService;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";

    @ApiOperation(value="\u5f85\u6574\u6539\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckDetailVO> queryDetail(@RequestParam Long id) {
        SceneCheckDetailEntity entity = (SceneCheckDetailEntity)((Object)this.sceneCheckDetailService.selectById(id));
        Long detailId = entity.getId();
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)detailId));
        param.getOrderMap().put("createTime", "desc");
        List sceneCheckRecordList = this.sceneCheckRecordService.queryList(param);
        List sceneCheckRecordVO = BeanMapper.mapList((Iterable)sceneCheckRecordList, SceneCheckRecordVO.class);
        SceneCheckDetailVO vo = (SceneCheckDetailVO)BeanMapper.map((Object)((Object)entity), SceneCheckDetailVO.class);
        vo.setSceneCheckRecords(sceneCheckRecordVO, this.baseHost);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u6574\u6539\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckDetailVO>> queryList(@RequestBody QueryParam param) {
        Map params = param.getParams();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkItem");
        fuzzyFields.add("checkPerson");
        fuzzyFields.add("checkName");
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        params.put("is_reform", new Parameter("in", Arrays.asList(CheckItemReformState.REFORM_STATE.getCode(), CheckItemReformState.REFORM_FAILED_STATE.getCode())));
        if (!params.containsKey("rectificationId") || !"all".equals(((Parameter)params.get("rectificationId")).getValue().toString())) {
            params.put("rectification_id", new Parameter("like", (Object)this.sessionManager.getUserContext().getUserId().toString()));
        }
        if (params.containsKey("projectId") && params.get("projectId") != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SceneCheckEntity::getProjectId, (Object)Long.valueOf(((Parameter)params.get("projectId")).toString()));
            List list = this.sceneCheckService.list((Wrapper)queryWrapper);
            List<Object> pids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(pids)) {
                pids = Arrays.asList(1L);
            }
            params.put("pid", new Parameter("in", pids));
            params.remove("projectId");
        }
        IPage page = this.sceneCheckDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckDetailVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SceneCheckDetailVO saveorUpdateVO) {
        return this.sceneCheckDetailService.insertOrUpdate(saveorUpdateVO);
    }
}

