package com.ejianc.business.scientific.sci.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 科研项目立项-历史-项目成员
 * 
 * @author generator
 * 
 */
public class SciProjectHistoryUserVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 主表主键
    private Long userId; // 人员主键
    private String userName; // 人员名称
    private String userMobile; // 联系方式
    private Long postId; // 职务主键
    private String postName; // 职务名称
    private String memo; // 备注
    private String professional; // 职称
    private String duty; // 课题内职务
    private BigDecimal planHour; // 计划工时(月)
    private Long sourceId; // 来源主键
    private String taskDivision; // 课题任务分工

    private List<SciProjectHistoryUserHourVO> hourList = new ArrayList<>(); // 科研项目立项-历史-项目成员-计划工时

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getUserId() {
        return userId;
    }

    @ReferDeserialTransfer
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getUserMobile() {
        return userMobile;
    }

    public void setUserMobile(String userMobile) {
        this.userMobile = userMobile;
    }

    @ReferSerialTransfer(referCode = "idm_post")
    public Long getPostId() {
        return postId;
    }

    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getProfessional() {
        return professional;
    }

    public void setProfessional(String professional) {
        this.professional = professional;
    }
    public String getDuty() {
        return duty;
    }

    public void setDuty(String duty) {
        this.duty = duty;
    }
    public BigDecimal getPlanHour() {
        return planHour;
    }

    public void setPlanHour(BigDecimal planHour) {
        this.planHour = planHour;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getTaskDivision() {
        return taskDivision;
    }

    public void setTaskDivision(String taskDivision) {
        this.taskDivision = taskDivision;
    }

    public List<SciProjectHistoryUserHourVO> getHourList() {
        return hourList;
    }

    public void setHourList(List<SciProjectHistoryUserHourVO> hourList) {
        this.hourList = hourList;
    }
}
