package com.ejianc.business.scientific.result;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 专利管理-奖项管理
 * 
 * @author generator
 * 
 */
public class PatentAwardVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // projectName
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // orgName
    private Long parentOrgId; // 父级组织(二级单位Id)
    private String parentOrgCode; // 父级组织编码(二级单位code)
    private String parentOrgName; // 父级组织(二级单位name)
    private Integer billState; // 单据状态（审批必须字段）
    private String billStateName; // 单据状态（审批必须字段）
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String awardName; // 奖项名称
    private Integer awardType; // 奖项类型 0 -科技 1-质量,2-BIM,3-环保, 4-安全,5-其他
    private String awardTypeName; // 奖项类型 0 -科技 1-质量,2-BIM,3-环保, 4-安全,5-其他
    private String awardProjectName; // 获奖项目名称
    private String awardUnit; // 获奖单位
    private String awardOrg; // 获奖组织
    private String awardPerson; // 获奖人员
    private String awardCode; // 奖项证书编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date awardDate; // 奖项日期
    private String awardMemo; // 获奖说明

    public String getAwardTypeName() {
        return awardTypeName;
    }

    public void setAwardTypeName(String awardTypeName) {
        this.awardTypeName = awardTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getAwardName() {
        return awardName;
    }

    public void setAwardName(String awardName) {
        this.awardName = awardName;
    }
    public Integer getAwardType() {
        return awardType;
    }

    public void setAwardType(Integer awardType) {
        this.awardType = awardType;
    }
    public String getAwardProjectName() {
        return awardProjectName;
    }

    public void setAwardProjectName(String awardProjectName) {
        this.awardProjectName = awardProjectName;
    }
    public String getAwardUnit() {
        return awardUnit;
    }

    public void setAwardUnit(String awardUnit) {
        this.awardUnit = awardUnit;
    }
    public String getAwardOrg() {
        return awardOrg;
    }

    public void setAwardOrg(String awardOrg) {
        this.awardOrg = awardOrg;
    }
    public String getAwardPerson() {
        return awardPerson;
    }

    public void setAwardPerson(String awardPerson) {
        this.awardPerson = awardPerson;
    }
    public String getAwardCode() {
        return awardCode;
    }

    public void setAwardCode(String awardCode) {
        this.awardCode = awardCode;
    }
    public Date getAwardDate() {
        return awardDate;
    }

    public void setAwardDate(Date awardDate) {
        this.awardDate = awardDate;
    }
    public String getAwardMemo() {
        return awardMemo;
    }

    public void setAwardMemo(String awardMemo) {
        this.awardMemo = awardMemo;
    }
    
}
