package com.ejianc.business.scientific.sci.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.scientific.sci.bean.SciProjectHistoryUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectHistoryBudgetEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectHistoryTargetEntity;
/**
 * 科研项目立项-历史
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scientific_project_history")
public class SciProjectHistoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 项目编码
    @TableField(value="name")
    private String name; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织
    @TableField(value="entrust_org")
    private String entrustOrg; // 委托单位
    @TableField(value="execute_org")
    private String executeOrg; // 实际执行单位
    @TableField(value="project_type")
    private String projectType; // 科研项目类型:1-横向科研(委托外单位) 2-纵向科研(政府)
    @TableField(value="period")
    private String period; // 研究周期
    @TableField(value="manager_id")
    private Long managerId; // 项目负责人主键
    @TableField(value="manager_name")
    private String managerName; // 项目负责人
    @TableField(value="employee_id")
    private Long employeeId; // 经办人主键
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="dept_id")
    private Long deptId; // 经办部门主键
    @TableField(value="dept_name")
    private String deptName; // 经办部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source_type")
    private String sourceType; // 单据来源：1-内部 2-外部
    @TableField(value="project_status")
    private String projectStatus; // 项目状态：0-未验收 1-已验收
    @TableField(value="budget_mny")
    private BigDecimal budgetMny; // 经费预算
    @TableField(value="plan_hour")
    private BigDecimal planHour; // 计划总工时(月)
    @TableField(value="myself_mny")
    private BigDecimal myselfMny; // 自筹经费
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请经费
    @TableField(value="project_date")
    private Date projectDate; // 立项日期
    @TableField(value="technical_index")
    private String technicalIndex; // 技术指标
    @TableField(value="expect_result")
    private String expectResult; // 预期成果
    @TableField(value="background")
    private String background; // 研究背景
    @TableField(value="research_area")
    private String researchArea; // 主要研究内容
    @TableField(value="technology")
    private String technology; // 关键技术及解决途径
    @TableField(value="intellectual")
    private String intellectual; // 知识产权策划
    @TableField(value="forecast")
    private String forecast; // 经济与设备效益预测
    @TableField(value="feasibility")
    private String feasibility; // 可行性研究
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_status")
    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="project_code")
    private String projectCode; // 立项编号
    @TableField(value="source_id")
    private Long sourceId; // 来源主键
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="sciProjectHistoryUserService")//此处有pid="xxx"，默认值pid="pid"
    private List<SciProjectHistoryUserEntity> userList = new ArrayList<>(); // 科研项目立项-历史-项目成员
    @TableField(exist=false)
    @SubEntity(serviceName="sciProjectHistoryBudgetService")//此处有pid="xxx"，默认值pid="pid"
    private List<SciProjectHistoryBudgetEntity> budgetList = new ArrayList<>(); // 科研项目立项-历史-经费预算
    @TableField(exist=false)
    @SubEntity(serviceName="sciProjectHistoryTargetService")//此处有pid="xxx"，默认值pid="pid"
    private List<SciProjectHistoryTargetEntity> targetList = new ArrayList<>(); // 科研项目立项-历史-阶段目标
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getEntrustOrg() {
        return entrustOrg;
    }

    public void setEntrustOrg(String entrustOrg) {
        this.entrustOrg = entrustOrg;
    }
    public String getExecuteOrg() {
        return executeOrg;
    }

    public void setExecuteOrg(String executeOrg) {
        this.executeOrg = executeOrg;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }
    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getPlanHour() {
        return planHour;
    }

    public void setPlanHour(BigDecimal planHour) {
        this.planHour = planHour;
    }
    public BigDecimal getMyselfMny() {
        return myselfMny;
    }

    public void setMyselfMny(BigDecimal myselfMny) {
        this.myselfMny = myselfMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public Date getProjectDate() {
        return projectDate;
    }

    public void setProjectDate(Date projectDate) {
        this.projectDate = projectDate;
    }
    public String getTechnicalIndex() {
        return technicalIndex;
    }

    public void setTechnicalIndex(String technicalIndex) {
        this.technicalIndex = technicalIndex;
    }
    public String getExpectResult() {
        return expectResult;
    }

    public void setExpectResult(String expectResult) {
        this.expectResult = expectResult;
    }
    public String getBackground() {
        return background;
    }

    public void setBackground(String background) {
        this.background = background;
    }
    public String getResearchArea() {
        return researchArea;
    }

    public void setResearchArea(String researchArea) {
        this.researchArea = researchArea;
    }
    public String getTechnology() {
        return technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }
    public String getIntellectual() {
        return intellectual;
    }

    public void setIntellectual(String intellectual) {
        this.intellectual = intellectual;
    }
    public String getForecast() {
        return forecast;
    }

    public void setForecast(String forecast) {
        this.forecast = forecast;
    }
    public String getFeasibility() {
        return feasibility;
    }

    public void setFeasibility(String feasibility) {
        this.feasibility = feasibility;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public List<SciProjectHistoryUserEntity> getUserList() {
        return userList;
    }

    public void setUserList(List<SciProjectHistoryUserEntity> userList) {
        this.userList = userList;
    }

    public List<SciProjectHistoryBudgetEntity> getBudgetList() {
        return budgetList;
    }

    public void setBudgetList(List<SciProjectHistoryBudgetEntity> budgetList) {
        this.budgetList = budgetList;
    }

    public List<SciProjectHistoryTargetEntity> getTargetList() {
        return targetList;
    }

    public void setTargetList(List<SciProjectHistoryTargetEntity> targetList) {
        this.targetList = targetList;
    }
}
