/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.result.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.result.MethodApproveVO;
import com.ejianc.business.scientific.result.bean.MethodApproveEntity;
import com.ejianc.business.scientific.result.service.IMethodApproveService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"methodApprove"})
public class MethodApproveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "METHOD_APPROVE";
    @Autowired
    private IMethodApproveService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MethodApproveVO> saveOrUpdate(@RequestBody MethodApproveVO saveOrUpdateVO) {
        MethodApproveEntity entity = (MethodApproveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MethodApproveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MethodApproveVO vo = (MethodApproveVO)BeanMapper.map((Object)((Object)entity), MethodApproveVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MethodApproveVO> queryDetail(Long id) {
        MethodApproveEntity entity = (MethodApproveEntity)((Object)this.service.selectById(id));
        MethodApproveVO vo = (MethodApproveVO)BeanMapper.map((Object)((Object)entity), MethodApproveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MethodApproveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MethodApproveVO methodApproveVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"queryMethodApproveList"})
    @ResponseBody
    public CommonResponse<List<MethodApproveVO>> queryMethodApproveList(@RequestParam(value="methodApproveDetailId") Long methodApproveDetailId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(MethodApproveEntity::getMethodApproveDetailId, (Object)methodApproveDetailId);
        List methodApproveEntities = this.service.list((Wrapper)lambda);
        List methodApproveVOS = BeanMapper.mapList((Iterable)methodApproveEntities, MethodApproveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)methodApproveVOS);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MethodApproveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("methodName");
        fuzzyFields.add("methodPersonName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        param.getParams().put("approveId", new Parameter("eq", (Object)userId));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List methodApproveVOS = BeanMapper.mapList((Iterable)page.getRecords(), MethodApproveVO.class);
        for (MethodApproveVO e : methodApproveVOS) {
            String s;
            long days = this.getDays(new Date(), e.getExpirationDate());
            if (e.getApproveStatus().equals(1)) {
                e.setApproveStatusName("\u672a\u8bc4\u5ba1");
                e.setApproveStatusPc(Integer.valueOf(1));
            }
            if (e.getApproveStatus().equals(2)) {
                e.setApproveStatusName("\u5df2\u8bc4\u5ba1");
                e.setApproveStatusPc(Integer.valueOf(2));
            }
            if (e.getApproveStatus().equals(1) && days <= 10L && days >= 0L) {
                s = "\u672a\u8bc4\u5ba1(\u8fd8\u6709" + days + "\u5929\u5230\u671f)";
                e.setApproveStatusName(s);
                e.setApproveStatusPc(Integer.valueOf(3));
            }
            if (!e.getApproveStatus().equals(1) || days >= 0L) continue;
            s = "\u672a\u8bc4\u5ba1(\u5df2\u5230\u671f)";
            e.setApproveStatusName(s);
            e.setApproveStatusPc(Integer.valueOf(4));
        }
        pageData.setRecords(methodApproveVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private long getDays(Date date, Date date2) {
        LocalDate localDate1 = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long diffDays = localDate2.toEpochDay() - localDate1.toEpochDay();
        return diffDays;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("methodName");
        fuzzyFields.add("methodPersonName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List methodApplyVOS = BeanMapper.mapList((Iterable)list, MethodApproveVO.class);
        methodApplyVOS.forEach(e -> {
            String s;
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            if (e.getMethodType().equals(1)) {
                e.setMethodTypeName("\u571f\u6728\u5de5\u7a0b");
            }
            if (e.getMethodType().equals(2)) {
                e.setMethodTypeName("\u623f\u5c4b\u5efa\u7b51\u5de5\u7a0b");
            }
            if (e.getMethodType().equals(3)) {
                e.setMethodTypeName("\u5de5\u4e1a\u5b89\u88c5\u5de5\u7a0b");
            }
            long days = this.getDays(new Date(), e.getExpirationDate());
            if (e.getApproveStatus().equals(1)) {
                e.setApproveStatusName("\u672a\u8bc4\u5ba1");
                e.setApproveStatusPc(Integer.valueOf(1));
            }
            if (e.getApproveStatus().equals(2)) {
                e.setApproveStatusName("\u5df2\u8bc4\u5ba1");
                e.setApproveStatusPc(Integer.valueOf(2));
            }
            if (e.getApproveStatus().equals(1) && days <= 10L && days >= 0L) {
                s = "\u672a\u8bc4\u5ba1(\u8fd8\u6709" + days + "\u5929\u5230\u671f)";
                e.setApproveStatusName(s);
                e.setApproveStatusPc(Integer.valueOf(3));
            }
            if (e.getApproveStatus().equals(1) && days < 0L) {
                s = "\u672a\u8bc4\u5ba1(\u5df2\u5230\u671f)";
                e.setApproveStatusName(s);
                e.setApproveStatusPc(Integer.valueOf(4));
            }
        });
        beans.put("records", methodApplyVOS);
        ExcelExport.getInstance().export("MethodApprove-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMethodApproveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MethodApproveVO>> refMethodApproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MethodApproveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

