/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.result.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.scientific.result.MethodReviewVO;
import com.ejianc.business.scientific.result.bean.MethodApplyEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewDetailEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewEntity;
import com.ejianc.business.scientific.result.mapper.MethodReviewMapper;
import com.ejianc.business.scientific.result.service.IMethodApplyService;
import com.ejianc.business.scientific.result.service.IMethodReviewDetailService;
import com.ejianc.business.scientific.result.service.IMethodReviewService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="methodReviewService")
public class MethodReviewServiceImpl
extends BaseServiceImpl<MethodReviewMapper, MethodReviewEntity>
implements IMethodReviewService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMethodApplyService methodApplyService;
    @Autowired
    private IMethodReviewDetailService methodReviewDetailService;
    private static final String BILL_CODE = "METHOD_REVIEW";

    @Override
    @Transactional
    public MethodReviewVO saveOrUpdate(MethodReviewVO saveOrUpdateVO) {
        MethodReviewEntity methodReviewEntity;
        List<MethodReviewDetailEntity> methodReviewDetailList;
        MethodReviewEntity entity = (MethodReviewEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MethodReviewEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveOrUpdateVO.getId() != null && CollectionUtils.isNotEmpty(methodReviewDetailList = (methodReviewEntity = (MethodReviewEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()))).getMethodReviewDetailList())) {
            List methodIds = methodReviewDetailList.stream().map(MethodReviewDetailEntity::getMethodId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.in(BaseEntity::getId, methodIds);
            List methodApplyEntities = this.methodApplyService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)methodApplyEntities)) {
                for (MethodApplyEntity methodApplyEntity : methodApplyEntities) {
                    methodApplyEntity.setUseStatus(0);
                }
                this.methodApplyService.updateBatchById(methodApplyEntities);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        List<MethodReviewDetailEntity> methodReviewDetailList2 = entity.getMethodReviewDetailList();
        if (CollectionUtils.isNotEmpty(methodReviewDetailList2)) {
            List methodIds = methodReviewDetailList2.stream().map(MethodReviewDetailEntity::getMethodId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.in(BaseEntity::getId, methodIds);
            List methodApplyEntities = this.methodApplyService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)methodApplyEntities)) {
                for (MethodApplyEntity methodApplyEntity : methodApplyEntities) {
                    methodApplyEntity.setUseStatus(1);
                }
                this.methodApplyService.updateBatchById(methodApplyEntities);
            }
        }
        MethodReviewVO vo = (MethodReviewVO)BeanMapper.map((Object)((Object)entity), MethodReviewVO.class);
        return vo;
    }

    @Override
    @Transactional
    public void delete(List<MethodReviewVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper methodReviewDetailLambdaWrapper = new LambdaQueryWrapper();
        methodReviewDetailLambdaWrapper.in(BaseEntity::getId, ids);
        List methodReviewDetailEntities = this.methodReviewDetailService.list((Wrapper)methodReviewDetailLambdaWrapper);
        List methodIds = methodReviewDetailEntities.stream().map(MethodReviewDetailEntity::getMethodId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(BaseEntity::getId, methodIds);
        List methodApplyEntities = this.methodApplyService.list((Wrapper)lambda);
        for (MethodApplyEntity methodApplyEntity : methodApplyEntities) {
            methodApplyEntity.setUseStatus(0);
        }
        this.methodApplyService.updateBatchById(methodApplyEntities);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

