/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.bean.SciProjectChangeEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserHourEntity;
import com.ejianc.business.scientific.sci.mapper.SciProjectChangeMapper;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeService;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.utils.EntityUtil;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeUserHourVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeUserVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sciProjectChangeService")
public class SciProjectChangeServiceImpl
extends BaseServiceImpl<SciProjectChangeMapper, SciProjectChangeEntity>
implements ISciProjectChangeService {
    @Autowired
    private ISciProjectService projectService;
    @Autowired
    private ISciProjectUserService userService;
    @Autowired
    private ISciProjectUserHourService hourService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public SciProjectChangeVO queryDetailChange(Long id) {
        SciProjectEntity entity = (SciProjectEntity)((Object)this.projectService.selectById(id));
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            List ids = entity.getUserList().stream().map(x -> x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter("in", ids));
            List hourList = this.hourService.queryList(param);
            Map<Long, List<SciProjectUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x -> x.getPid()));
            for (SciProjectUserEntity user : entity.getUserList()) {
                user.setHourList(hourMap.get(user.getId()));
            }
        }
        SciProjectChangeVO vo = (SciProjectChangeVO)BeanMapper.map((Object)((Object)entity), SciProjectChangeVO.class);
        for (SciProjectChangeUserVO detail : vo.getUserList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
            for (SciProjectChangeUserHourVO hour : detail.getHourList()) {
                hour.setSourceId(hour.getId());
                hour.setRowState("add");
                EntityUtil.clearInvalidData(hour);
            }
        }
        for (SciProjectChangeUserVO detail : vo.getBudgetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        for (SciProjectChangeUserVO detail : vo.getTargetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        vo.setSourceId(vo.getId());
        vo.setBillState(null);
        vo.setChangeReason(null);
        vo.setCode(null);
        vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion() + 1));
        vo.setChangeDate(new Date());
        EntityUtil.clearInvalidData(vo);
        vo.setId(Long.valueOf(IdWorker.getId()));
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202502000014", "attachMgr", String.valueOf(vo.getId()), "EJCBT202502000015", "attachMgr");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202502000014", "proposal", String.valueOf(vo.getId()), "EJCBT202502000015", "proposal");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202502000014", "meet", String.valueOf(vo.getId()), "EJCBT202502000015", "meet");
        return vo;
    }

    @Override
    public List<SciProjectChangeVO> queryChangeHistory(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter("eq", (Object)id));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("changeVersion", "desc");
        List list = super.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<SciProjectChangeVO>();
        }
        List result = BeanMapper.mapList((Iterable)list, SciProjectChangeVO.class);
        for (SciProjectChangeVO vo : result) {
            String historyBillCode = vo.getCode() + "-" + (vo.getChangeVersion() - 1);
            vo.setHistoryBillCode(historyBillCode);
        }
        return result;
    }
}

