package com.ejianc.business.scientific.sci.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.sci.bean.SciProjectChangeEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectChangeUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectChangeUserHourEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.cons.CommonConstant;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeService;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeUserService;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 科研项目立项-变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sciProjectChange")
public class SciProjectChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "IN_SCI_PROJECT_CHANGE";//此处需要根据实际修改

    @Autowired
    private ISciProjectChangeService service;

    @Autowired
    private ISciProjectChangeUserService userService;

    @Autowired
    private ISciProjectChangeUserHourService hourService;

    @Autowired
    private ISciProjectService projectService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SciProjectChangeVO> saveOrUpdate(@RequestBody SciProjectChangeVO saveOrUpdateVO) {
        SciProjectChangeVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SciProjectChangeVO> queryDetail(Long id) {
    	SciProjectChangeEntity entity = service.selectById(id);
        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            List<Long> ids = entity.getUserList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
            List<SciProjectChangeUserHourEntity> hourList = hourService.queryList(param);
            Map<Long, List<SciProjectChangeUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x->x.getPid()));
            for(SciProjectChangeUserEntity user : entity.getUserList()){
                user.setHourList(hourMap.get(user.getId()));
            }
        }
    	SciProjectChangeVO vo = BeanMapper.map(entity, SciProjectChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SciProjectChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SciProjectChangeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(SciProjectChangeVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<SciProjectChangeEntity> list = service.queryList(param);
        for (SciProjectChangeEntity vo : list) {
            LambdaUpdateWrapper<SciProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (vo.getChangeVersion() == 2) {
                updateWrapper.set(SciProjectEntity::getChangeStatus, CommonConstant.CHANGE_NO);
            } else {
                updateWrapper.set(SciProjectEntity::getChangeStatus, CommonConstant.CHANGE_OVER);
            }
            updateWrapper.eq(SciProjectEntity::getId, vo.getSourceId());
            projectService.update(updateWrapper);
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SciProjectChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SciProjectChangeEntity> page = service.queryPage(param,false);
        IPage<SciProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SciProjectChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SciProjectChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SciProjectChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSciProjectChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SciProjectChangeVO>> refSciProjectChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SciProjectChangeEntity> page = service.queryPage(param,false);
        IPage<SciProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SciProjectChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 根据原单据主键查询变更单信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SciProjectChangeVO> queryDetailChange(@RequestParam Long id) {
        SciProjectChangeVO vo = service.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    /**
     * 变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SciProjectChangeVO>> queryChangeHistory(@RequestParam Long id) {
        List<SciProjectChangeVO> vo = service.queryChangeHistory(id);
        return CommonResponse.success(vo);
    }
}
