package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserHourEntity;
import com.ejianc.business.scientific.sci.cons.CommonConstant;
import com.ejianc.business.scientific.sci.service.ISciProjectUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.utils.DateUtil;
import com.ejianc.business.scientific.sci.vo.SciProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.mapper.SciProjectMapper;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 科研项目立项
 * 
 * @author generator
 * 
 */
@Service("sciProjectService")
public class SciProjectServiceImpl extends BaseServiceImpl<SciProjectMapper, SciProjectEntity> implements ISciProjectService{

    private static final String BILL_CODE_IN = "IN_SCI_PROJECT";//此处需要根据实际修改
    private static final String BILL_CODE_OUT = "OUT_SCI_PROJECT";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISciProjectUserService userService;

    @Autowired
    private ISciProjectUserHourService hourService;

    @Override
    public SciProjectVO saveOrUpdate(SciProjectVO saveOrUpdateVO) {
        SciProjectEntity entity = BeanMapper.map(saveOrUpdateVO, SciProjectEntity.class);
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            for(SciProjectUserEntity user : entity.getUserList()){
                for(SciProjectUserHourEntity hour : user.getHourList()){
                    hour.setUserId(user.getUserId());
                    hour.setUserName(user.getUserName());
                    if("del".equals(user.getRowState())){
                        hour.setRowState("del");
                    }
                }
            }
        }
        // 校验人员工时
        this.validateHourByUser(entity.getUserList());

        if(entity.getId() == null || entity.getId() == 0){
            String rule = CommonConstant.STRING_YES.equals(entity.getSourceType()) ? BILL_CODE_IN : BILL_CODE_OUT;
            BillCodeParam billCodeParam = BillCodeParam.build(rule, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            for(SciProjectUserEntity user : entity.getUserList()){
                userService.saveOrUpdate(user, false);
            }
        }
        super.saveOrUpdate(entity, false);
        SciProjectVO vo = BeanMapper.map(entity, SciProjectVO.class);
        return vo;
    }

    /**
     * 校验人员工时
     * @param userList
     */
    private void validateHourByUser(List<SciProjectUserEntity> userList) {
        if(CollectionUtils.isEmpty(userList)){
            return;
        }
        List<SciProjectUserEntity> list = userList.stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        List<SciProjectUserHourEntity> saveList = list.stream().map(x->x.getHourList()).flatMap(Collection::stream).
                filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(saveList)){
            return;
        }
        List<Long> userIds = list.stream().map(x->x.getUserId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter(QueryParam.IN, userIds));
        List<Long> ids = saveList.stream().map(x->x.getId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            param.getParams().put("id", new Parameter(QueryParam.NOT_IN, ids));
        }
        List<SciProjectUserHourEntity> dataList = hourService.queryList(param);
        dataList = CollectionUtils.isNotEmpty(dataList) ? dataList : new ArrayList<>();
        dataList.addAll(saveList);
        Map<Long, Map<String, List<SciProjectUserHourEntity>>> userMap = dataList.stream().collect(
                Collectors.groupingBy(x->x.getUserId(), Collectors.groupingBy(x->DateUtil.getYearStr(x.getPlanYear()))));
        StringBuilder message = new StringBuilder();
        for(Long userId : userMap.keySet()){
            Map<String, List<SciProjectUserHourEntity>> yearMap = userMap.get(userId);
            for(String year : yearMap.keySet()){
                BigDecimal hour = yearMap.get(year).stream().map(x->x.getPlanHour()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                if(ComputeUtil.isGreaterThan(hour, ComputeUtil.toBigDecimal("12"))){
                    message.append("【" + yearMap.get(year).get(0).getUserName() + "】");
                    message.append("在【" + year + "年】参与的所有科研项目立项中的计划工时累计值已超12个月；/n");
                }
            }
        }
        if(message.length() > 0){
            throw new BusinessException(message.toString());
        }
    }
}
