package com.ejianc.business.scientific.sci.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.mapper.SciProjectUserMapper;
import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;

import java.util.List;

/**
 * 科研项目立项-项目成员
 * 
 * @author generator
 * 
 */
@Service("sciProjectUserService")
public class SciProjectUserServiceImpl extends BaseServiceImpl<SciProjectUserMapper, SciProjectUserEntity> implements ISciProjectUserService{

    @Override
    public List<SciProjectUserEntity> getAllByPid(Long projectId) {
        QueryWrapper<SciProjectUserEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_DELETED);
        query.eq("pid", projectId);

        return super.list(query);
    }
}
