/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.utils;

import com.ejianc.framework.core.kit.base.annotation.NotNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    public static final String CURRENT_YEAR = DateUtil.getCurrentYear();

    public static Integer getSubDay(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(sdf.format(startDate)));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(sdf.format(endDate)));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time1 - time2) / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Integer days = Integer.parseInt(String.valueOf(betweenDays));
        return days < 0 ? days - 1 : days + 1;
    }

    public static int compareDate(Date dt1, Date dt2) {
        try {
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static int compareDay(Date dt1, Date dt2) {
        dt1 = DateUtil.parseDate(DateUtil.formatDate(dt1));
        dt2 = DateUtil.parseDate(DateUtil.formatDate(dt2));
        return DateUtil.compareDate(dt1, dt2);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtil.formatDate(date1).equals(DateUtil.formatDate(date2));
    }

    public static boolean isSameWeek(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(3) == cal2.get(3);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtil.formatDate(date1, "yyyy-MM").equals(DateUtil.formatDate(date2, "yyyy-MM"));
    }

    public static boolean isSameMonth(Date date1, String date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtil.formatDate(date1, "yyyy-MM").equals(date2);
    }

    public static Date beginOfWeek(@NotNull Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(7, -1);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date beginOfMonth(@NotNull Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date beginOfYear(@NotNull Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date endOfWeek(@NotNull Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(7, -1);
        cal.set(7, 2);
        cal.add(7, 6);
        return DateUtil.endOfDate(cal.getTime());
    }

    public static Date endOfMonth(@NotNull Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        cal.set(5, 0);
        return DateUtil.endOfDate(cal.getTime());
    }

    public static Date endOfLastYear(@NotNull Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(6, 0);
        return DateUtil.endOfDate(cal.getTime());
    }

    public static Date endOfDate(@NotNull Date date) {
        return new Date(DateUtil.nextDate(date).getTime() - 1L);
    }

    public static Date nextDate(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)5);
    }

    public static int daysOfMonth(@NotNull Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.get(5);
    }

    public static Date maxDate(Date date1, Date date2, Boolean flag) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (flag.booleanValue()) {
            if (DateUtil.compareDate(date1, date2) < 0) {
                return date2;
            }
            return date1;
        }
        if (DateUtil.compareDate(date1, date2) < 0) {
            return date1;
        }
        return date2;
    }

    public static int compareDateStr(String t1, String t2) {
        int trr2;
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        if (trr1 > (trr2 = Integer.parseInt(t2.replaceAll("-", "")))) {
            return 1;
        }
        if (trr1 < trr2) {
            return -1;
        }
        return 0;
    }

    public static String getMonthStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        return String.format("%02d", month);
    }

    public static String getYearStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String year = String.valueOf(cal.get(1));
        return year;
    }

    public static String getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String year = String.valueOf(cal.get(1));
        return year;
    }

    public static int getLastYear() {
        Calendar cal = Calendar.getInstance();
        int i = cal.get(1) - 1;
        return i;
    }

    public static String getCurrentMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(cal.getTime());
    }

    public static String getLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        return sdf.format(cal.getTime());
    }

    public static Integer turnZnDayOfWeek(Integer day) {
        return (day = Integer.valueOf(day + 1)) > 7 ? day - 6 : day;
    }

    public static Integer turnZnDayOfMonth(Integer day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (day > cal.getActualMaximum(5)) {
            cal.add(5, 1);
            day = cal.get(5);
            return day;
        }
        return day == 30 ? cal.getActualMaximum(5) : day.intValue();
    }

    public static String formatDateString(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat bsdf = new SimpleDateFormat(DateUtil.getDateFormat(str));
        String dateStr = null;
        try {
            dateStr = sdf.format(bsdf.parse(str));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String getDateFormat(String str) {
        boolean year = false;
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if (pattern.matcher(str.substring(0, 4)).matches()) {
            year = true;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        if (!year) {
            if (str.contains("\u6708") || str.contains("-") || str.contains("/")) {
                if (Character.isDigit(str.charAt(0))) {
                    index = 1;
                }
            } else {
                index = 3;
            }
        }
        for (int i = 0; i < str.length(); ++i) {
            char lastChar;
            char chr = str.charAt(i);
            if (Character.isDigit(chr)) {
                if (index == 0) {
                    sb.append("y");
                }
                if (index == 1) {
                    sb.append("M");
                }
                if (index == 2) {
                    sb.append("d");
                }
                if (index == 3) {
                    sb.append("H");
                }
                if (index == 4) {
                    sb.append("m");
                }
                if (index == 5) {
                    sb.append("s");
                }
                if (index != 6) continue;
                sb.append("S");
                continue;
            }
            if (i > 0 && Character.isDigit(lastChar = str.charAt(i - 1))) {
                ++index;
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    public static Date addDays(@NotNull Date date, int amount) {
        return DateUtils.addDays((Date)date, (int)amount);
    }

    public static Date addMonths(@NotNull Date date, int amount) {
        return DateUtils.addMonths((Date)date, (int)amount);
    }

    public static Date parseDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String formatSeconds(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static void main(String[] args) {
        String date1 = "2023-07-02 23:59:59";
        String date2 = "2025-03-01";
        System.out.println(DateUtil.beginOfYear(DateUtil.parseDate(date1)));
        System.out.println(DateUtil.formatDate(DateUtil.beginOfYear(DateUtil.parseDate(date1))));
    }
}

