/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.work.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeDetailEntity;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeEntity;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeDetailService;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workTimeDetail"})
public class WorkTimeDetailController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWorkTimeDetailService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IWorkTimeService workTimeService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkTimeDetailVO> queryDetail(Long id) {
        WorkTimeDetailEntity entity = (WorkTimeDetailEntity)((Object)this.service.selectById(id));
        WorkTimeDetailVO vo = (WorkTimeDetailVO)BeanMapper.map((Object)((Object)entity), WorkTimeDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkTimeDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkTimeDetailVO workTimeDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WorkTimeDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkTimeDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkTimeDetailVO>> refWorkTimeDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkTimeDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUserTotalHour"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<WorkTimeDetailVO>> queryUserTotalHour(@RequestBody QueryParam param) {
        ArrayList resp = new ArrayList();
        List dbList = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            List workTimeEntities = (List)this.workTimeService.listByIds(new ArrayList(dbList.stream().map(WorkTimeDetailEntity::getPid).collect(Collectors.toSet())));
            resp.addAll(BeanMapper.mapList((Iterable)dbList, WorkTimeDetailVO.class));
            Map workTimeMap = workTimeEntities.stream().collect(Collectors.toMap(item -> item.getId(), Function.identity()));
            resp.forEach(item -> {
                item.setBillId(item.getPid());
                item.setBillCode(((WorkTimeEntity)((Object)((Object)workTimeMap.get(item.getPid())))).getBillCode());
                item.setProjectName(((WorkTimeEntity)((Object)((Object)workTimeMap.get(item.getPid())))).getProjectName());
                item.setBillState(((WorkTimeEntity)((Object)((Object)workTimeMap.get(item.getPid())))).getBillState());
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }
}

