package com.ejianc.business.scientific.result.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.scientific.result.MethodReviewVO;
import com.ejianc.business.scientific.result.bean.MethodApplyEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewDetailEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewEntity;
import com.ejianc.business.scientific.result.mapper.MethodReviewMapper;
import com.ejianc.business.scientific.result.service.IMethodApplyService;
import com.ejianc.business.scientific.result.service.IMethodReviewDetailService;
import com.ejianc.business.scientific.result.service.IMethodReviewService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 工法管理-工法评审主表
 * 
 * @author generator
 * 
 */
@Service("methodReviewService")
public class MethodReviewServiceImpl extends BaseServiceImpl<MethodReviewMapper, MethodReviewEntity> implements IMethodReviewService{

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMethodApplyService methodApplyService;
    @Autowired
    private IMethodReviewDetailService methodReviewDetailService;

    private static final String BILL_CODE = "METHOD_REVIEW";//此处需要根据实际修改

    @Transactional
    @Override
    public MethodReviewVO saveOrUpdate(MethodReviewVO saveOrUpdateVO) {
        MethodReviewEntity entity = BeanMapper.map(saveOrUpdateVO, MethodReviewEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //同步引用状态
        if (saveOrUpdateVO.getId() != null){
            MethodReviewEntity methodReviewEntity = super.selectById(saveOrUpdateVO.getId());
            List<MethodReviewDetailEntity> methodReviewDetailList = methodReviewEntity.getMethodReviewDetailList();
            if (CollectionUtils.isNotEmpty(methodReviewDetailList)){
                List<Long> methodIds = methodReviewDetailList.stream().map(MethodReviewDetailEntity::getMethodId).collect(Collectors.toList());
                LambdaQueryWrapper<MethodApplyEntity> lambda = new LambdaQueryWrapper();
                lambda.in(MethodApplyEntity::getId, methodIds);
                List<MethodApplyEntity> methodApplyEntities = methodApplyService.list(lambda);
                if (CollectionUtils.isNotEmpty(methodApplyEntities)){
                    for (MethodApplyEntity methodApplyEntity : methodApplyEntities){
                        methodApplyEntity.setUseStatus(0);
                    }
                    methodApplyService.updateBatchById(methodApplyEntities);
                }
            }
        }

        super.saveOrUpdate(entity, false);

        List<MethodReviewDetailEntity> methodReviewDetailList = entity.getMethodReviewDetailList();
        if (CollectionUtils.isNotEmpty(methodReviewDetailList)){
            List<Long> methodIds = methodReviewDetailList.stream().map(MethodReviewDetailEntity::getMethodId).collect(Collectors.toList());
            LambdaQueryWrapper<MethodApplyEntity> lambda = new LambdaQueryWrapper();
            lambda.in(MethodApplyEntity::getId, methodIds);
            List<MethodApplyEntity> methodApplyEntities = methodApplyService.list(lambda);
            if (CollectionUtils.isNotEmpty(methodApplyEntities)){
                for (MethodApplyEntity methodApplyEntity : methodApplyEntities){
                    methodApplyEntity.setUseStatus(1);
                }
                methodApplyService.updateBatchById(methodApplyEntities);
            }

        }

        MethodReviewVO vo = BeanMapper.map(entity, MethodReviewVO.class);
        return vo;
    }

    @Transactional
    @Override
    public void delete(List<MethodReviewVO> vos) {
        List<Long> ids = vos.stream().map(MethodReviewVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<MethodReviewDetailEntity> methodReviewDetailLambdaWrapper = new LambdaQueryWrapper();
        methodReviewDetailLambdaWrapper.in(MethodReviewDetailEntity::getMid, ids);
        List<MethodReviewDetailEntity> methodReviewDetailEntities = methodReviewDetailService.list(methodReviewDetailLambdaWrapper);
        List<Long> methodIds = methodReviewDetailEntities.stream().map(MethodReviewDetailEntity::getMethodId).collect(Collectors.toList());
        LambdaQueryWrapper<MethodApplyEntity> lambda = new LambdaQueryWrapper();
        lambda.in(MethodApplyEntity::getId, methodIds);
        List<MethodApplyEntity> methodApplyEntities = methodApplyService.list(lambda);
        for (MethodApplyEntity methodApplyEntity : methodApplyEntities){
            methodApplyEntity.setUseStatus(0);
        }
        methodApplyService.updateBatchById(methodApplyEntities);

        super.removeByIds(vos.stream().map(MethodReviewVO::getId).collect(Collectors.toList()),true);
    }
}
