package com.ejianc.business.scientific.sci.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.vo.SciProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 科研项目立项
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sciProject")
public class SciProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE_IN = "IN_SCI_PROJECT";//此处需要根据实际修改
    private static final String BILL_CODE_OUT = "OUT_SCI_PROJECT";//此处需要根据实际修改

    @Autowired
    private ISciProjectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SciProjectVO> saveOrUpdate(@RequestBody SciProjectVO saveOrUpdateVO) {
        SciProjectVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SciProjectVO> queryDetail(Long id) {
    	SciProjectVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SciProjectVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SciProjectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "orgName", "name", "managerName", "employeeName", "deptName", "entrustOrg", "executeOrg"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SciProjectEntity> page = service.queryPage(param,false);
        IPage<SciProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SciProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "orgName", "name", "managerName", "employeeName", "deptName", "entrustOrg", "executeOrg"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SciProjectEntity> list = service.queryList(param);
        List<SciProjectVO> records = BeanMapper.mapList(list, SciProjectVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        String sourceType = null;
        if(param.getParams().containsKey("sourceType")){
            sourceType = String.valueOf(param.getParams().get("sourceType").getValue());
        }
        if("1".equals(sourceType)){// 内部
            ExcelExport.getInstance().exportWithTrans("SciProject-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().exportWithTrans("OutSciProject-export.xlsx", beans, response);
        }
    }

    /**
     * 科研项目类型参照树
     * @return
     */
    @RequestMapping(value = "/queryTypeTree", method = RequestMethod.GET)
    @ResponseBody
    public JSONArray queryTypeTree() {
        JSONArray result = new JSONArray();
        JSONObject parent1 = new JSONObject();
        parent1.put("id", "1,2");
        parent1.put("name", "外部科研项目");

        JSONArray child1 = new JSONArray();
        JSONObject child11 = new JSONObject();
        child11.put("id", "1");
        child11.put("name", "横向科研项目");
        child11.put("parentId", parent1.getString("id"));
        child1.add(child11);

        JSONObject child12 = new JSONObject();
        child12.put("id", "2");
        child12.put("name", "纵向科研项目");
        child12.put("parentId", parent1.getString("id"));
        child1.add(child12);

        parent1.put("children", child1);
        result.add(parent1);

        JSONObject parent2 = new JSONObject();
        parent2.put("id", "3,4");
        parent2.put("name", "内部科研项目");

        JSONArray child2 = new JSONArray();
        JSONObject child21 = new JSONObject();
        child21.put("id", "3");
        child21.put("name", "建设公司科研项目");
        child21.put("parentId", parent2.getString("id"));
        child2.add(child21);

        JSONObject child22 = new JSONObject();
        child22.put("id", "4");
        child22.put("name", "二级单位科研项目");
        child22.put("parentId", parent2.getString("id"));
        child2.add(child22);

        parent2.put("children", child2);
        result.add(parent2);
        return result;
    }

    /**
     * @Description 参照
     * @param condition orgId默认当期登录组织，{range： "up"}，选择本上，sourceType-单据来源：1-内部 2-外部
     * @Return void
     */
    @RequestMapping(value = "/refSciProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SciProjectVO>> refSciProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode,
                String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "orgName", "name", "managerName", "employeeName", "deptName", "entrustOrg", "executeOrg"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("orgId")){
                orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }
            if(_con.containsKey("range") && "up".equals(_con.getString("range"))){
                List<Long> orgIds = iOrgApi.findParentsByOrgId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
            }
            if(_con.containsKey("sourceType")){
                param.getParams().put("sourceType", new Parameter(QueryParam.EQ, _con.getString("sourceType")));
            }
            if(_con.containsKey("projectStatus")){
                param.getParams().put("projectStatus", new Parameter(QueryParam.IN, _con.getString("projectStatus")));
            }
        }
        if(StringUtils.isNotBlank(relyCondition)){
            String projectType = relyCondition.split("=")[1];
            param.getParams().put("projectType",new Parameter(QueryParam.IN, projectType));
        }
        IPage<SciProjectEntity> page = service.queryPage(param,false);
        IPage<SciProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SciProjectVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/updateProjectCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SciProjectVO> updateProjectCode(@RequestParam("id") Long id, @RequestParam("projectCode") String projectCode) {
        SciProjectEntity entity = service.selectById(id);
        entity.setProjectCode(projectCode);
        service.saveOrUpdate(entity, false);
        SciProjectVO vo = BeanMapper.map(entity, SciProjectVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryAllDetail 查询审批后详情
     * @param id
     */
    @RequestMapping(value = "/queryAllDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryAllDetail(Long id) {
        JSONObject result = service.queryAllDetail(id);
        return CommonResponse.success(result);
    }

    /**
     * 科研项目台账
     * @param param
     * projectType-科研项目类型:1-横向科研 2-纵向科研 3-建设公司科研项目 4-二级单位科研项目，projectStatus-项目状态：0-未验收 1-已验收，projectDate-立项日期
     * 模糊查询具体关键字，searchObject 是普通JSON格式字符串，如{code:"001"} 则会拼接 and code like '%001%'
     * 排序放入orderMap
     * @return
     */
    @RequestMapping(value = "/sciProjectReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> sciProjectReport(@RequestBody QueryParam param) {
        JSONObject result = service.sciProjectReport(param);
        return CommonResponse.success(result);
    }

    /**
     * 科研项目台账导出
     * @param param
     * projectType-科研项目类型:1-横向科研 2-纵向科研 3-建设公司科研项目 4-二级单位科研项目，projectStatus-项目状态：0-未验收 1-已验收，projectDate-立项日期
     * 模糊查询具体关键字，searchObject 是普通JSON格式字符串，如{code:"001"} 则会拼接 and code like '%001%'
     * 排序放入orderMap
     * @return
     */
    @RequestMapping(value = "/sciProjectReportExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> sciProjectReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        JSONObject result = service.sciProjectReport(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result.getJSONArray("records"));
        ExcelExport.getInstance().export("sci-project-report-export.xlsx", beans, response);
        return CommonResponse.success(result);
    }
}
