package com.ejianc.business.scientific.sci.work.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 科研管理-科研工时填报
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scientific_work_time")
public class WorkTimeEntity extends BaseEntity {

    private static final long serialVersionUID = -268604911508551788L;
    @TableField(value="bill_state")
    private Integer billState; // 单据状态

    @TableField(value = "bill_code")
    private String billCode;//单据编码
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织
    @TableField(value="project_id")
    private Long projectId; // 科研项目主键
    @TableField(value="project_name")
    private String projectName; // 科研项目名称
    @TableField(value="project_type")
    private String projectType; // 科研项目类型:1-横向科研 2-纵向科研
    @TableField(value="manager_id")
    private Long managerId; // 项目负责人主键
    @TableField(value="manager_name")
    private String managerName; // 项目负责人
    @TableField(value="employee_id")
    private Long employeeId; // 经办人主键
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门主键
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="year_month")
    private String yearMonth; // 月份
    @TableField(value="plan_total_work_time_month")
    private BigDecimal planTotalWorkTimeMonth; // 计划总工时(月)
    @TableField(value="project_total_work_time_month")
    private BigDecimal projectTotalWorkTimeMonth; // 累计总工时(月),该科研项目所有已生效的科研工时填报单【本月总工时(月)】合计值
    @TableField(value="bill_total_work_time")
    private BigDecimal billTotalWorkTime; // 本月总工时(月),子表【本月工时】合计值

    @TableField(value="source_type")
    private String sourceType; // 单据来源：1-内部 2-外部

    @TableField(exist = false)
    @SubEntity(serviceName = "workTimeDetailService")
    private List<WorkTimeDetailEntity> detailList = new ArrayList<>(); //项目成员

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<WorkTimeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<WorkTimeDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getYearMonth() {
        return yearMonth;
    }

    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
    }

    public BigDecimal getPlanTotalWorkTimeMonth() {
        return planTotalWorkTimeMonth;
    }

    public void setPlanTotalWorkTimeMonth(BigDecimal planTotalWorkTimeMonth) {
        this.planTotalWorkTimeMonth = planTotalWorkTimeMonth;
    }
    public BigDecimal getProjectTotalWorkTimeMonth() {
        return projectTotalWorkTimeMonth;
    }

    public void setProjectTotalWorkTimeMonth(BigDecimal projectTotalWorkTimeMonth) {
        this.projectTotalWorkTimeMonth = projectTotalWorkTimeMonth;
    }
    public BigDecimal getBillTotalWorkTime() {
        return billTotalWorkTime;
    }

    public void setBillTotalWorkTime(BigDecimal billTotalWorkTime) {
        this.billTotalWorkTime = billTotalWorkTime;
    }
    
}
