package com.ejianc.business.scientific.sci.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.scientific.result.*;
import com.ejianc.business.scientific.result.service.*;
import com.ejianc.business.scientific.sci.bean.*;
import com.ejianc.business.scientific.sci.cons.CommonConstant;
import com.ejianc.business.scientific.sci.cons.ProjectTypeEnum;
import com.ejianc.business.scientific.sci.service.*;
import com.ejianc.business.scientific.sci.utils.DateUtil;
import com.ejianc.business.scientific.sci.utils.JSONUtils;
import com.ejianc.business.scientific.sci.utils.ListCallable;
import com.ejianc.business.scientific.sci.vo.*;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.mapper.SciProjectMapper;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 科研项目立项
 * 
 * @author generator
 * 
 */
@Service("sciProjectService")
public class SciProjectServiceImpl extends BaseServiceImpl<SciProjectMapper, SciProjectEntity> implements ISciProjectService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE_IN = "IN_SCI_PROJECT";//此处需要根据实际修改
    private static final String BILL_CODE_OUT = "OUT_SCI_PROJECT";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ISciProjectUserService userService;

    @Autowired
    private ISciProjectUserHourService hourService;

    @Autowired
    private ISciProjectBudgetService budgetService;

    @Autowired
    private ISciProjectBudgetYearService yearService;

    @Autowired
    private ISciProjectChangeService changeService;

    @Autowired
    private IExecuteService executeService;

    @Autowired
    private ICheckAcceptService checkService;

    @Autowired
    private IFeeConfirmService feeService;

    @Autowired
    private IWorkTimeService workTimeService;

    @Autowired
    private IMethodApplyService methodApplyService;

    @Autowired
    private IPatentRegisterService patentRegisterService;

    @Autowired
    private ISoftRegisterService softRegisterService;

    @Autowired
    private IPaperRegisterService paperRegisterService;

    @Autowired
    private IResultEvaluateService resultEvaluateService;

    @Autowired
    private IMethodRegisterService methodRegisterService;

    @Override
    public SciProjectVO saveOrUpdate(SciProjectVO saveOrUpdateVO) {
        SciProjectEntity entity = BeanMapper.map(saveOrUpdateVO, SciProjectEntity.class);
        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            for(SciProjectUserEntity user : entity.getUserList()){
                for(SciProjectUserHourEntity hour : user.getHourList()){
                    hour.setUserId(user.getUserId());
                    hour.setUserName(user.getUserName());
                    if("del".equals(user.getRowState())){
                        hour.setRowState("del");
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getBudgetList())){
            for(SciProjectBudgetEntity budget : entity.getBudgetList()){
                for(SciProjectBudgetYearEntity year : budget.getYearList()){
                    year.setFeeId(budget.getFeeId());
                    year.setFeeName(budget.getFeeName());
                    if("del".equals(budget.getRowState())){
                        year.setRowState("del");
                    }
                }
            }
        }
        // 校验人员工时
        this.validateHourByUser(entity.getUserList());

        if(entity.getId() == null || entity.getId() == 0){
            String rule = CommonConstant.STRING_YES.equals(entity.getSourceType()) ? BILL_CODE_IN : BILL_CODE_OUT;
            BillCodeParam billCodeParam = BillCodeParam.build(rule, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setChangeStatus("1");
            entity.setProjectStatus("0");
        }
        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            for(SciProjectUserEntity user : entity.getUserList()){
                userService.saveOrUpdate(user, false);
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getBudgetList())){
            for(SciProjectBudgetEntity budget : entity.getBudgetList()){
                budgetService.saveOrUpdate(budget, false);
            }
        }
        if(null == entity.getProjectDate()) {
            entity.setProjectDate(new Date());
        }
        super.saveOrUpdate(entity, false);
        SciProjectVO vo = BeanMapper.map(entity, SciProjectVO.class);
        return vo;
    }

    @Override
    public Boolean delete(List<SciProjectVO> vos) {
        if(CollectionUtils.isEmpty(vos)){
            return true;
        }
        List<Long> ids = vos.stream().map(x->x.getId()).collect(Collectors.toList());

        // 处理孙表
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
        List<SciProjectUserEntity> userList = userService.queryList(param);
        if(CollectionUtils.isNotEmpty(userList)){
            List<Long> uids = userList.stream().map(x->x.getId()).collect(Collectors.toList());
            userService.removeByIds(uids, true);
        }
        List<SciProjectBudgetEntity> budgetList = budgetService.queryList(param);
        if(CollectionUtils.isNotEmpty(budgetList)){
            List<Long> bids = budgetList.stream().map(x->x.getId()).collect(Collectors.toList());
            budgetService.removeByIds(bids, true);
        }

        super.removeByIds(ids,true);
        return true;
    }

    @Override
    public SciProjectVO queryDetail(Long id) {
        SciProjectEntity entity = super.selectById(id);
        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            List<Long> ids = entity.getUserList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
            List<SciProjectUserHourEntity> hourList = hourService.queryList(param);
            Map<Long, List<SciProjectUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x->x.getPid()));
            for(SciProjectUserEntity user : entity.getUserList()){
                if(hourMap.containsKey(user.getId())){
                    user.setHourList(hourMap.get(user.getId()));
                }
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getBudgetList())){
            List<Long> ids = entity.getBudgetList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
            List<SciProjectBudgetYearEntity> yearList = yearService.queryList(param);
            Map<Long, List<SciProjectBudgetYearEntity>> yearMap = yearList.stream().collect(Collectors.groupingBy(x->x.getPid()));
            for(SciProjectBudgetEntity budget : entity.getBudgetList()){
                if(yearMap.containsKey(budget.getId())){
                    budget.setYearList(yearMap.get(budget.getId()));
                }
            }
        }
        SciProjectVO vo = BeanMapper.map(entity, SciProjectVO.class);
        return vo;
    }

    @Override
    public JSONObject queryAllDetail(Long id) {
        JSONObject result = new JSONObject();
        SciProjectVO projectVO = this.queryDetail(id);
        result.put("projectVO", projectVO);// 基本信息

        List<SciProjectChangeVO> changeList = changeService.queryChangeHistory(id);
        result.put("changeList", changeList);// 变更情况

        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, id));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        QueryParam resultParam = new QueryParam();
        resultParam.getParams().put("scientificProjectId", new Parameter(QueryParam.EQ, id));
        resultParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(10);
//        QueryParam param1 = Utils.deepCopy(param);// 深拷贝

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param, executeService);// 执行情况
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param, checkService);// 验收情况
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param, feeService);// 经费情况
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param, workTimeService);// 工时情况
        Future<JSONArray> future5 = ListCallable.excute(threadPool, resultParam, methodApplyService);// 工法申请
        Future<JSONArray> future6 = ListCallable.excute(threadPool, resultParam, patentRegisterService);// 专利登记
        Future<JSONArray> future7 = ListCallable.excute(threadPool, resultParam, softRegisterService);// 软著登记
        Future<JSONArray> future8 = ListCallable.excute(threadPool, resultParam, paperRegisterService);// 论文登记
        Future<JSONArray> future9 = ListCallable.excute(threadPool, resultParam, resultEvaluateService);// 成果评价
        Future<JSONArray> future10 = ListCallable.excute(threadPool, resultParam, methodRegisterService);// 省市级工法登记

        JSONArray executeList = new JSONArray();// 执行情况
        JSONArray checkList = new JSONArray();// 验收情况
        JSONArray feeList = new JSONArray();// 经费情况
        JSONArray workTimeList = new JSONArray();// 工时情况
        JSONArray methodApplyList = new JSONArray();// 工法申请
        JSONArray patentRegisterList = new JSONArray();// 专利登记
        JSONArray softRegisterList = new JSONArray();// 软著登记
        JSONArray paperRegisterList = new JSONArray();// 论文登记
        JSONArray resultEvaluateList = new JSONArray();// 成果评价
        JSONArray methodRegisterList = new JSONArray();// 省市级工法登记
        try {
            executeList = future1.get();
            checkList = future2.get();
            feeList = future3.get();
            workTimeList = future4.get();
            methodApplyList = future5.get();
            patentRegisterList = future6.get();
            softRegisterList = future7.get();
            paperRegisterList = future8.get();
            resultEvaluateList = future9.get();
            methodRegisterList = future10.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        result.put("executeList", JSONUtils.mapList(executeList, ExecuteVO.class));// 执行情况
        result.put("checkList", JSONUtils.mapList(checkList, CheckAcceptVO.class));// 验收情况
        result.put("feeList", JSONUtils.mapList(feeList, FeeConfirmVO.class));// 经费情况
        result.put("workTimeList", JSONUtils.mapList(workTimeList, WorkTimeVO.class));// 工时情况
        result.put("methodApplyList", JSONUtils.mapList(methodApplyList, MethodApplyVO.class));// 工法申请
        result.put("patentRegisterList", JSONUtils.mapList(patentRegisterList, PatentRegisterVO.class));// 专利登记
        result.put("softRegisterList", JSONUtils.mapList(softRegisterList, SoftRegisterVO.class));// 软著登记
        result.put("paperRegisterList", JSONUtils.mapList(paperRegisterList, PaperRegisterVO.class));// 论文登记
        result.put("resultEvaluateList", JSONUtils.mapList(resultEvaluateList, ResultEvaluateVO.class));// 成果评价
        result.put("methodRegisterList", JSONUtils.mapList(methodRegisterList, MethodRegisterVO.class));// 省市级工法登记

        BigDecimal sumApplyMny = feeList.stream().map(x->((JSONObject)x).getBigDecimal("applyMny")).
                filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.put("budgetMny", projectVO.getBudgetMny());// 经费预算
        result.put("sumApplyMny", sumApplyMny);// 累计申请金额

        BigDecimal sumHour = workTimeList.stream().map(x->((JSONObject)x).getBigDecimal("billTotalWorkTime")).
                filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.put("planHour", projectVO.getPlanHour());// 计划工时(月)
        result.put("sumHour", sumHour);// 实际总工时(月)

        // 成果情况
        JSONArray resultList = new JSONArray();
        for(Object o : methodApplyList){
            JSONObject obj = (JSONObject)o;
            JSONObject vo = new JSONObject();
            vo.put("billCode", obj.getString("billCode"));
            vo.put("id", obj.getString("id"));
            vo.put("billType", "工法申请");
            vo.put("billName", obj.getString("methodName"));
            vo.put("employeeName", obj.getString("employeeName"));
            vo.put("createTime", DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add(vo);
        }
        for(Object o : patentRegisterList){
            JSONObject obj = (JSONObject)o;
            JSONObject vo = new JSONObject();
            vo.put("billCode", obj.getString("billCode"));
            vo.put("id", obj.getString("id"));
            vo.put("billType", "专利");
            vo.put("billName", obj.getString("patentName"));
            vo.put("employeeName", obj.getString("employeeName"));
            vo.put("createTime", DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add(vo);
        }
        for(Object o : softRegisterList){
            JSONObject obj = (JSONObject)o;
            JSONObject vo = new JSONObject();
            vo.put("billCode", obj.getString("billCode"));
            vo.put("id", obj.getString("id"));
            vo.put("billType", "软著");
            vo.put("billName", obj.getString("softName"));
            vo.put("employeeName", obj.getString("employeeName"));
            vo.put("createTime", DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add(vo);
        }
        for(Object o : paperRegisterList){
            JSONObject obj = (JSONObject)o;
            JSONObject vo = new JSONObject();
            vo.put("billCode", obj.getString("billCode"));
            vo.put("id", obj.getString("id"));
            vo.put("billType", "论文");
            vo.put("billName", obj.getString("paperName"));
            vo.put("employeeName", obj.getString("employeeName"));
            vo.put("createTime", DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add(vo);
        }
        for(Object o : resultEvaluateList){
            JSONObject obj = (JSONObject)o;
            JSONObject vo = new JSONObject();
            vo.put("billCode", obj.getString("billCode"));
            vo.put("id", obj.getString("id"));
            vo.put("billType", "成果评价");
            vo.put("billName", obj.getString("resultName"));
            vo.put("employeeName", obj.getString("employeeName"));
            vo.put("createTime", DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add(vo);
        }
        for(Object o : methodRegisterList){
            JSONObject obj = (JSONObject)o;
            JSONObject vo = new JSONObject();
            vo.put("billCode", obj.getString("billCode"));
            vo.put("id", obj.getString("id"));
            vo.put("billType", "省市级工法登记");
            vo.put("billName", obj.getString("methodName"));
            vo.put("employeeName", obj.getString("employeeName"));
            vo.put("createTime", DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add(vo);
        }
        result.put("resultList", resultList);// 成果情况
        return result;
    }

    @Override
    public JSONObject sciProjectReport(QueryParam queryParam) {
        // 默认排序
        LinkedHashMap<String, String> orderMap = queryParam.getOrderMap();
        if(!orderMap.containsKey("orgName")){
            orderMap.put("orgName", QueryParam.ASC);
        }
        if(!orderMap.containsKey("projectDate")){
            orderMap.put("projectDate", QueryParam.DESC);
        }
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId())
                .getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SciProjectEntity> pageData = super.queryPage(queryParam);
        List<SciProjectEntity> projectList = pageData.getRecords();
        JSONObject page = new JSONObject();
        page.put("current", "" + pageData.getCurrent());
        page.put("size", "" + pageData.getSize());
        page.put("records", pageData.getRecords());
        page.put("total", "" + pageData.getTotal());
        page.put("pages", "" + pageData.getPages());
        if(CollectionUtils.isEmpty(projectList)){
            return page;
        }
        List<Long> projectIds = projectList.stream().map(x->x.getId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        QueryParam resultParam = new QueryParam();
        resultParam.getParams().put("scientificProjectId", new Parameter(QueryParam.IN, projectIds));
        resultParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(10);
//        QueryParam param1 = Utils.deepCopy(param);// 深拷贝

        Future<JSONArray> future2 = ListCallable.excute(threadPool, param, checkService);// 验收情况
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param, feeService);// 经费情况
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param, workTimeService);// 工时情况
        Future<JSONArray> future5 = ListCallable.excute(threadPool, resultParam, methodApplyService);// 工法申请
        Future<JSONArray> future6 = ListCallable.excute(threadPool, resultParam, patentRegisterService);// 专利登记
        Future<JSONArray> future7 = ListCallable.excute(threadPool, resultParam, softRegisterService);// 软著登记
        Future<JSONArray> future8 = ListCallable.excute(threadPool, resultParam, paperRegisterService);// 论文登记
        Future<JSONArray> future9 = ListCallable.excute(threadPool, resultParam, resultEvaluateService);// 成果评价
        Future<JSONArray> future10 = ListCallable.excute(threadPool, resultParam, methodRegisterService);// 省市级工法登记

        JSONArray checkList = new JSONArray();// 验收情况
        JSONArray feeList = new JSONArray();// 经费情况
        JSONArray workTimeList = new JSONArray();// 工时情况
        JSONArray methodApplyList = new JSONArray();// 工法申请
        JSONArray patentRegisterList = new JSONArray();// 专利登记
        JSONArray softRegisterList = new JSONArray();// 软著登记
        JSONArray paperRegisterList = new JSONArray();// 论文登记
        JSONArray resultEvaluateList = new JSONArray();// 成果评价
        JSONArray methodRegisterList = new JSONArray();// 省市级工法登记
        try {
            checkList = future2.get();
            feeList = future3.get();
            workTimeList = future4.get();
            methodApplyList = future5.get();
            patentRegisterList = future6.get();
            softRegisterList = future7.get();
            paperRegisterList = future8.get();
            resultEvaluateList = future9.get();
            methodRegisterList = future10.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        Map<Long, String> checkMap = checkList.stream().map(x->(JSONObject)x).collect(Collectors.toMap(
                x->x.getLong("projectId"), x->DateUtil.formatDate(x.getDate("checkDate"))));
        Map<Long, BigDecimal> feeMap = feeList.stream().map(x->((JSONObject)x)).collect(Collectors.groupingBy(x->x.getLong("projectId"),
                Collectors.reducing(BigDecimal.ZERO, x->x.getBigDecimal("applyMny"), ComputeUtil::safeAdd)));
        Map<Long, BigDecimal> hourMap = workTimeList.stream().map(x->((JSONObject)x)).collect(Collectors.groupingBy(x->x.getLong("projectId"),
                Collectors.reducing(BigDecimal.ZERO, x->x.getBigDecimal("billTotalWorkTime"), ComputeUtil::safeAdd)));
        Map<Long, Long> methodApplyMap = methodApplyList.stream().map(x->((JSONObject)x)).collect(
                Collectors.groupingBy(x->x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> patentRegisterMap = patentRegisterList.stream().map(x->((JSONObject)x)).collect(
                Collectors.groupingBy(x->x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> softRegisterMap = softRegisterList.stream().map(x->((JSONObject)x)).collect(
                Collectors.groupingBy(x->x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> paperRegisterMap = paperRegisterList.stream().map(x->((JSONObject)x)).collect(
                Collectors.groupingBy(x->x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> resultEvaluateMap = resultEvaluateList.stream().map(x->((JSONObject)x)).collect(
                Collectors.groupingBy(x->x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> methodRegisterMap = methodRegisterList.stream().map(x->((JSONObject)x)).collect(
                Collectors.groupingBy(x->x.getLong("scientificProjectId"), Collectors.counting()));

        JSONArray array = new JSONArray();
        for(SciProjectEntity project : projectList){
            Long projectId = project.getId();
            JSONObject obj = new JSONObject();
            obj.put("projectId", projectId);// 科研项目主键
            obj.put("orgName", project.getOrgName());// 所属组织
            obj.put("projectType", project.getProjectType());// 科研项目类型:1-横向科研 2-纵向科研 3-建设公司科研项目 4-二级单位科研项目
            obj.put("projectTypeName", ProjectTypeEnum.getEnumByCode(project.getProjectType()).getName());
            obj.put("projectStatus", project.getProjectStatus());// 项目状态：0-未验收 1-已验收
            obj.put("projectDate", DateUtil.formatDate(project.getProjectDate()));// 立项日期
            obj.put("name", project.getName());// 科研项目名称
            obj.put("managerName", project.getManagerName());// 项目负责人
            obj.put("period", project.getPeriod());// 研究周期
            obj.put("budgetMny", ComputeUtil.scaleTwo(project.getBudgetMny()));// 经费预算(元)
            obj.put("planHour", ComputeUtil.scale(project.getPlanHour(), 1));// 计划总工时(月)
            obj.put("sourceType", project.getSourceType());// 单据来源：1-内部 2-外部
            obj.put("billState", project.getBillState());
            if(checkMap.containsKey(projectId)){
                obj.put("checkDate", checkMap.get(projectId));// 验收日期
            }
            if(feeMap.containsKey(projectId)){
                obj.put("actualMny", ComputeUtil.scaleTwo(feeMap.get(projectId)));// 实际经费(元)
            }
            if(hourMap.containsKey(projectId)){
                obj.put("actualHour", ComputeUtil.scale(hourMap.get(projectId), 1));// 实际总工时
            }
            Integer num = 0;
            if(methodApplyMap.containsKey(projectId)){
                num = num + methodApplyMap.get(projectId).intValue();
            }
            if(patentRegisterMap.containsKey(projectId)){
                num = num + patentRegisterMap.get(projectId).intValue();
            }
            if(softRegisterMap.containsKey(projectId)){
                num = num + softRegisterMap.get(projectId).intValue();
            }
            if(paperRegisterMap.containsKey(projectId)){
                num = num + paperRegisterMap.get(projectId).intValue();
            }
            if(resultEvaluateMap.containsKey(projectId)){
                num = num + resultEvaluateMap.get(projectId).intValue();
            }
            if(methodRegisterMap.containsKey(projectId)){
                num = num + methodRegisterMap.get(projectId).intValue();
            }
            obj.put("num", num);// 科研成果数量
            array.add(obj);
        }
        page.put("records", array);
        return page;
    }

    /**
     * 校验人员工时
     * @param userList
     */
    private void validateHourByUser(List<SciProjectUserEntity> userList) {
        if(CollectionUtils.isEmpty(userList)){
            return;
        }
        List<SciProjectUserEntity> list = userList.stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        List<SciProjectUserHourEntity> saveList = list.stream().map(x->x.getHourList()).flatMap(Collection::stream).
                filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(saveList)){
            return;
        }
        List<Long> userIds = list.stream().map(x->x.getUserId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter(QueryParam.IN, userIds));
        List<Long> ids = saveList.stream().map(x->x.getId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            param.getParams().put("id", new Parameter(QueryParam.NOT_IN, ids));
        }
        List<SciProjectUserHourEntity> dataList = hourService.queryList(param);
        dataList = CollectionUtils.isNotEmpty(dataList) ? dataList : new ArrayList<>();
        dataList.addAll(saveList);
        Map<Long, Map<String, List<SciProjectUserHourEntity>>> userMap = dataList.stream().collect(
                Collectors.groupingBy(x->x.getUserId(), Collectors.groupingBy(x->x.getPlanYear())));
        StringBuilder message = new StringBuilder();
        for(Long userId : userMap.keySet()){
            Map<String, List<SciProjectUserHourEntity>> yearMap = userMap.get(userId);
            for(String year : yearMap.keySet()){
                BigDecimal hour = yearMap.get(year).stream().map(x->x.getPlanHour()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                if(ComputeUtil.isGreaterThan(hour, ComputeUtil.toBigDecimal("12"))){
                    message.append("【" + yearMap.get(year).get(0).getUserName() + "】");
                    message.append("在【" + year + "年】参与的所有科研项目立项中的计划工时累计值已超12个月；/n");
                }
            }
        }
        if(message.length() > 0){
            throw new BusinessException(message.toString());
        }
    }
}
