package com.ejianc.business.scientific.sci.work.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scientific.sci.work.bean.UserMonthWorkTimeStaticDetailEntity;
import com.ejianc.business.scientific.sci.work.service.IUserMonthWorkTimeStaticDetailService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.work.mapper.UserMonthWorkTimeStaticMapper;
import com.ejianc.business.scientific.sci.work.bean.UserMonthWorkTimeStaticEntity;
import com.ejianc.business.scientific.sci.work.service.IUserMonthWorkTimeStaticService;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 员工月度工时统计主表
 * 
 * @author generator
 * 
 */
@Service("userMonthWorkTimeStaticService")
public class UserMonthWorkTimeStaticServiceImpl extends BaseServiceImpl<UserMonthWorkTimeStaticMapper, UserMonthWorkTimeStaticEntity> implements IUserMonthWorkTimeStaticService{

    @Autowired
    private IUserMonthWorkTimeStaticDetailService detailService;

    @Autowired
    private UserMonthWorkTimeStaticMapper mapper;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public UserMonthWorkTimeStaticEntity getByYearMonth(String yearMonth) {
        QueryWrapper<UserMonthWorkTimeStaticEntity> query = new QueryWrapper<>();
        query.eq("year_month", yearMonth);
        UserMonthWorkTimeStaticEntity dbEntity = super.getOne(query);

        if(null != dbEntity) {
            List<UserMonthWorkTimeStaticDetailEntity> detailList = detailService.getByPid(dbEntity.getId());
            dbEntity.setDetailList(detailList);
        }
        return dbEntity;
    }

    @Override
    public UserMonthWorkTimeStaticEntity staticByYearMonth(String yearMonth) {
        UserContext user =sessionManager.getUserContext();

        UserMonthWorkTimeStaticEntity resp = new UserMonthWorkTimeStaticEntity();
        resp.setEmployeeId(InvocationInfoProxy.getUserid());
        resp.setEmployeeName(user.getEmployeeName());

        List<UserMonthWorkTimeStaticDetailEntity> detailList = detailService.staticByYearMonth(yearMonth);
        //查询人员信息
        List<Long> userIds = detailList.stream().map(UserMonthWorkTimeStaticDetailEntity::getUserId).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(userIds)) {
            CommonResponse<List<EmployeeVO>> empResp = employeeApi.getJustByIds(userIds);
            if(!empResp.isSuccess()) {
                throw new BusinessException("操作失败，获取人员信息失败！");
            }

            List<EmployeeVO> empList = empResp.getData();
            Map<Long, EmployeeVO> empMap = empList.stream().collect(Collectors.toMap(EmployeeVO::getUserId, Function.identity()));
            detailList.parallelStream().forEach(detail -> {
                detail.setId(detail.getUserId());
                if(empMap.containsKey(detail.getUserId())) {
                    detail.setDeptName(empMap.get(detail.getUserId()).getDeptName());
                    detail.setUserSex(null != empMap.get(detail.getUserId()).getSex() ? 1 == empMap.get(detail.getUserId()).getSex() ? "男" : "女" : "男");
                }
            });
        }

        resp.setDetailList(detailList);

        return resp;
    }
}
