package com.ejianc.business.scientific.result.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scientific.result.bean.SoftApplyEntity;
import com.ejianc.business.scientific.result.service.ISoftApplyService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.result.mapper.SoftRegisterMapper;
import com.ejianc.business.scientific.result.bean.SoftRegisterEntity;
import com.ejianc.business.scientific.result.service.ISoftRegisterService;

import java.util.List;

/**
 * 专利管理-软著登记
 * 
 * @author generator
 * 
 */
@Service("softRegisterService")
public class SoftRegisterServiceImpl extends BaseServiceImpl<SoftRegisterMapper, SoftRegisterEntity> implements ISoftRegisterService{

    @Autowired
    private ISoftApplyService applyService;

    @Override
    public boolean updateReferUseFlag(List<Long> referIds, Integer flag) {
        if(CollectionUtils.isEmpty(referIds)){
            return true;
        }
        LambdaUpdateWrapper<SoftApplyEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.in(SoftApplyEntity::getId, referIds);
        wrapper.set(SoftApplyEntity::getUseFlag, flag);
        applyService.update(wrapper);
        return true;
    }
}
