/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.result.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.scientific.result.MethodFileVO;
import com.ejianc.business.scientific.result.bean.MethodApplyEntity;
import com.ejianc.business.scientific.result.bean.MethodFileDetailEntity;
import com.ejianc.business.scientific.result.bean.MethodFileEntity;
import com.ejianc.business.scientific.result.mapper.MethodFileMapper;
import com.ejianc.business.scientific.result.service.IMethodApplyService;
import com.ejianc.business.scientific.result.service.IMethodFileDetailService;
import com.ejianc.business.scientific.result.service.IMethodFileService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="methodFileService")
public class MethodFileServiceImpl
extends BaseServiceImpl<MethodFileMapper, MethodFileEntity>
implements IMethodFileService {
    private static final String BILL_CODE = "SCIENTIFIC-METHOD-FILE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMethodApplyService methodApplyService;
    @Autowired
    private IMethodFileDetailService methodFileDetailService;

    @Override
    public MethodFileVO saveOrUpdate(MethodFileVO saveOrUpdateVO) {
        MethodFileEntity methodFileEntity;
        List<MethodFileDetailEntity> methodFileDetailList;
        MethodFileEntity entity = (MethodFileEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MethodFileEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveOrUpdateVO.getId() != null && CollectionUtils.isNotEmpty(methodFileDetailList = (methodFileEntity = (MethodFileEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()))).getMethodFileDetailList())) {
            List methodIds = methodFileDetailList.stream().map(MethodFileDetailEntity::getMethodId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.in(BaseEntity::getId, methodIds);
            List methodApplyEntities = this.methodApplyService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)methodApplyEntities)) {
                for (MethodApplyEntity methodApplyEntity : methodApplyEntities) {
                    methodApplyEntity.setFileUseStatus(0);
                }
                this.methodApplyService.updateBatchById(methodApplyEntities);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        List<MethodFileDetailEntity> methodFileDetailList2 = entity.getMethodFileDetailList();
        if (CollectionUtils.isNotEmpty(methodFileDetailList2)) {
            List methodIds = methodFileDetailList2.stream().map(MethodFileDetailEntity::getMethodId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.in(BaseEntity::getId, methodIds);
            List methodApplyEntities = this.methodApplyService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)methodApplyEntities)) {
                for (MethodApplyEntity methodApplyEntity : methodApplyEntities) {
                    methodApplyEntity.setFileUseStatus(1);
                }
                this.methodApplyService.updateBatchById(methodApplyEntities);
            }
        }
        MethodFileVO vo = (MethodFileVO)BeanMapper.map((Object)((Object)entity), MethodFileVO.class);
        return vo;
    }

    @Override
    public void delete(List<MethodFileVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper methodFileDetailLambdaWrapper = new LambdaQueryWrapper();
        methodFileDetailLambdaWrapper.in(MethodFileDetailEntity::getMid, ids);
        List methodFileDetailEntities = this.methodFileDetailService.list((Wrapper)methodFileDetailLambdaWrapper);
        List methodIds = methodFileDetailEntities.stream().map(MethodFileDetailEntity::getMethodId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(BaseEntity::getId, methodIds);
        List methodApplyEntities = this.methodApplyService.list((Wrapper)lambda);
        for (MethodApplyEntity methodApplyEntity : methodApplyEntities) {
            methodApplyEntity.setFileUseStatus(0);
        }
        this.methodApplyService.updateBatchById(methodApplyEntities);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

