/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.work.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeEntity;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeDetailVO;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeReportVO;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workTime"})
public class WorkTimeController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWorkTimeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISciProjectUserService projectUserService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkTimeVO> saveOrUpdate(@RequestBody WorkTimeVO saveOrUpdateVO) {
        WorkTimeVO resp = this.service.saveOrUpdate(saveOrUpdateVO);
        if (StringUtils.isNotBlank((CharSequence)resp.getCheckMsg())) {
            return CommonResponse.error((String)resp.getCheckMsg());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/checkProject"})
    @ResponseBody
    public CommonResponse<List<WorkTimeDetailVO>> checkProject(@RequestBody WorkTimeVO saveOrUpdateVO) {
        String msg = this.service.checkProject(saveOrUpdateVO);
        return StringUtils.isNotBlank((CharSequence)msg) ? CommonResponse.error((String)msg) : CommonResponse.success((String)"\u8be5\u9879\u76ee\u4e0b\u5f53\u524d\u6708\u4efd\u672a\u5236\u5355\uff0c\u9879\u76ee\u53ef\u9009\uff01");
    }

    @PostMapping(value={"/checkUserWorkTime"})
    @ResponseBody
    public CommonResponse<List<WorkTimeDetailVO>> checkUserWorkTime(@RequestBody WorkTimeVO saveOrUpdateVO) {
        List<WorkTimeDetailVO> resp = this.service.checkUserWorkTime(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkTimeVO> queryDetail(Long id) {
        WorkTimeEntity entity = (WorkTimeEntity)((Object)this.service.selectById(id));
        WorkTimeVO vo = (WorkTimeVO)BeanMapper.map((Object)((Object)entity), WorkTimeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkTimeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkTimeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List vos = BeanMapper.mapList((Iterable)list, WorkTimeVO.class);
        vos.stream().forEach(item -> item.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription()));
        beans.put("records", vos);
        ExcelExport.getInstance().export("SciWorkTime-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkTimeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> refWorkTimeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkTimeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUserWorkTime"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<WorkTimeDetailVO>> queryUserWorkTime(@RequestBody WorkTimeVO workTimeVO) {
        ArrayList<WorkTimeDetailVO> resp = new ArrayList<WorkTimeDetailVO>();
        List<SciProjectUserEntity> projectUserList = this.projectUserService.getAllByPid(workTimeVO.getProjectId());
        Map<Long, BigDecimal> userWorkTimeMap = this.service.getUserWorkTime(new ArrayList<Long>(projectUserList.stream().map(item -> item.getUserId()).collect(Collectors.toSet())), null, workTimeVO.getProjectId());
        WorkTimeDetailVO tmp = null;
        for (SciProjectUserEntity user : projectUserList) {
            tmp = new WorkTimeDetailVO();
            tmp.setUserId(user.getUserId());
            tmp.setUserName(user.getUserName());
            tmp.setUserMobile(user.getUserMobile());
            tmp.setDuty(user.getDuty());
            tmp.setPostId(user.getPostId());
            tmp.setPostName(user.getPostName());
            tmp.setProfessional(user.getProfessional());
            tmp.setUserPlanTotalHour(user.getPlanHour());
            tmp.setUserTotalHour(new BigDecimal("0"));
            tmp.setUserHour(new BigDecimal("0"));
            tmp.setSourceId(user.getPid());
            tmp.setSourceDetailId(user.getId());
            if (userWorkTimeMap.containsKey(tmp.getUserId())) {
                tmp.setUserTotalHour(userWorkTimeMap.get(tmp.getUserId()));
            }
            tmp.setUserTotalHourContainsSelf(tmp.getUserTotalHour());
            resp.add(tmp);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    @RequestMapping(value={"/pageReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkTimeReportVO>> pageReport(@RequestBody QueryParam param) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            params.put("orgIds", commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            params.put("orgIds", departmentIds);
        }
        for (String key : param.getParams().keySet()) {
            params.put(key, ((Parameter)param.getParams().get(key)).getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            params.put("searchText", param.getSearchText());
        }
        params.put("pageSize", param.getPageSize());
        params.put("startLine", param.getPageIndex() < 1 ? 0 : (param.getPageIndex() - 1) * param.getPageSize());
        Long count = this.service.countReport(params);
        Page resp = new Page((long)param.getPageIndex(), (long)param.getPageSize(), count.longValue());
        if (count == 0L) {
            resp.setRecords(new ArrayList());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        List<WorkTimeReportVO> page = this.service.pageReport((WorkTimeReportVO)JSONObject.parseObject((String)JSONObject.toJSONString(params), WorkTimeReportVO.class));
        resp.setRecords(page);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/excelReport"}, method={RequestMethod.POST})
    public void excelReport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            params.put("orgIds", commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            params.put("orgIds", departmentIds);
        }
        for (String key : param.getParams().keySet()) {
            params.put(key, ((Parameter)param.getParams().get(key)).getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            params.put("searchText", param.getSearchText());
        }
        List<WorkTimeReportVO> page = this.service.pageReport((WorkTimeReportVO)JSONObject.parseObject((String)JSONObject.toJSONString(params), WorkTimeReportVO.class));
        HashMap<String, List<WorkTimeReportVO>> beans = new HashMap<String, List<WorkTimeReportVO>>();
        beans.put("records", page);
        ExcelExport.getInstance().export("SciWorkTimeReport-export.xlsx", beans, response);
    }
}

