/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.work.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scientific.sci.work.bean.UserMonthWorkTimeStaticDetailEntity;
import com.ejianc.business.scientific.sci.work.bean.UserMonthWorkTimeStaticEntity;
import com.ejianc.business.scientific.sci.work.mapper.UserMonthWorkTimeStaticMapper;
import com.ejianc.business.scientific.sci.work.service.IUserMonthWorkTimeStaticDetailService;
import com.ejianc.business.scientific.sci.work.service.IUserMonthWorkTimeStaticService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userMonthWorkTimeStaticService")
public class UserMonthWorkTimeStaticServiceImpl
extends BaseServiceImpl<UserMonthWorkTimeStaticMapper, UserMonthWorkTimeStaticEntity>
implements IUserMonthWorkTimeStaticService {
    @Autowired
    private IUserMonthWorkTimeStaticDetailService detailService;
    @Autowired
    private UserMonthWorkTimeStaticMapper mapper;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public UserMonthWorkTimeStaticEntity getByYearMonth(String yearMonth) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_month", (Object)yearMonth);
        UserMonthWorkTimeStaticEntity dbEntity = (UserMonthWorkTimeStaticEntity)((Object)super.getOne((Wrapper)query));
        if (null != dbEntity) {
            List<UserMonthWorkTimeStaticDetailEntity> detailList = this.detailService.getByPid(dbEntity.getId());
            dbEntity.setDetailList(detailList);
        }
        return dbEntity;
    }

    @Override
    public UserMonthWorkTimeStaticEntity staticByYearMonth(String yearMonth) {
        UserContext user = this.sessionManager.getUserContext();
        UserMonthWorkTimeStaticEntity resp = new UserMonthWorkTimeStaticEntity();
        List<UserMonthWorkTimeStaticDetailEntity> detailList = this.detailService.staticByYearMonth(yearMonth);
        List userIds = detailList.stream().map(UserMonthWorkTimeStaticDetailEntity::getUserId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userIds)) {
            CommonResponse empResp = this.employeeApi.getJustByIds(userIds);
            if (!empResp.isSuccess()) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List empList = (List)empResp.getData();
            Map empMap = empList.stream().collect(Collectors.toMap(EmployeeVO::getUserId, Function.identity()));
            detailList.parallelStream().forEach(detail -> {
                detail.setId(detail.getUserId());
                if (empMap.containsKey(detail.getUserId())) {
                    detail.setDeptName(((EmployeeVO)empMap.get(detail.getUserId())).getDeptName());
                    detail.setUserSex(null != ((EmployeeVO)empMap.get(detail.getUserId())).getSex() ? (1 == ((EmployeeVO)empMap.get(detail.getUserId())).getSex() ? "\u7537" : "\u5973") : "\u7537");
                }
            });
        }
        resp.setDetailList(detailList);
        return resp;
    }
}

