package com.ejianc.integration.sdbjmaterial.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import com.ejianc.integration.sdbjmaterial.workflow.Flow;
import com.ejianc.integration.sdbjmaterial.workflow.Item;
import com.ejianc.integration.sdbjmaterial.workflow.Node;

public class XmlUtils {
	
	public static void main(String[] args) {
		String xmlContent = "<process name=\"8abc662a4cd6bce1014cdb06579e1bec\" displayName=\"PM_物资领用出库\"><end layout=\"560,80,50,50\" name=\"end\"></end><task layout=\"279,94,100,50\" name=\"rect3r1\" displayName=\"项目设备物资办负责人\" form=\"8abc662a4cb87f50014cbacbc8a615b8\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"rect4r1\" name=\"path3r1\" /></task><task layout=\"279,94,100,50\" name=\"rect4r1\" displayName=\"项目设备物资办负责人\" form=\"8abc662a4cb87f50014cbacbc8a615b8\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"end\" name=\"path4r1\" /></task><task layout=\"279,94,100,50\" name=\"rect2r1\" displayName=\"项目设备物资办负责人\" form=\"8abc662a4cb87f50014cbacbc8a615b8\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"rect3r1\" name=\"path2r1\" /></task><start layout=\"28,79,50,50\" name=\"start\"><transition offset=\"0,-10\" to=\"rect1r1\" name=\"path1\" /></start><task layout=\"130,90,100,50\" name=\"rect1r1\" displayName=\"项目库管员\" form=\"8abc662a50d343ac0150d6bcc3697af4\" taskType=\"Major\" performType=\"1\"><transition offset=\"0,-10\" to=\"rect2r1\" name=\"path1r1\" /></task></process>";	
		
		Flow flow = parse(xmlContent);
		flow.getNodes().get(0).getItem().setMan("guoming");
		flow.getNodes().get(0).getItem().setManid("9999999999999999999999999");
		
		System.out.println(flow);
		
		System.out.println(convertXml(flow));
	}
	
	/**
	 * 流程实体转xml
	 * 
	 * @param flow
	 * @return
	 */
	public static String convertXml(Flow flow) {
		String xml = "<?xml version=\"1.0\"?><flow name=\""+flow.getName()+"\" isedit=\""+flow.getIsedit()+"\">";
		if(flow.getNodes() != null && flow.getNodes().size() > 0) {
			for(Node node:flow.getNodes()) {
				Item item = node.getItem();
				xml += "<node orders=\""+node.getOrders()+"\">";
				if(StringUtils.isNotBlank(item.getMan())) {
					xml += "<item orders=\""+item.getOrders()+"\" man=\""+item.getMan()+"\" manid=\""+item.getManid()+"\" handlemode=\""+item.getHandlemode()+"\" roleid=\""+item.getRoleid()+"\" rolename=\""+item.getRolename()+"\"/>";
				}else{
					xml += "<item orders=\""+item.getOrders()+"\" man=\"\" manid=\"\" handlemode=\""+item.getHandlemode()+"\" roleid=\""+item.getRoleid()+"\" rolename=\""+item.getRolename()+"\"/>";
				}
				xml += "</node>";
			}
		}
		xml += "</flow>";
		return xml;
	}
	
	/**
	 * 流程xml转实体
	 * 
	 * @param xmlContent
	 * @return
	 */
	public static Flow parse(String xmlContent) {
		try {
			Document document = DocumentHelper.parseText(xmlContent.trim());
			Element rootElement = document.getRootElement();
			Flow flow = new Flow();
			flow.setProcessid(rootElement.attributeValue("name"));
			flow.setName(rootElement.attributeValue("displayName"));
			flow.setIsedit(true);
			
			List<Node> nodes = toNodeList(rootElement);
			
			flow.setNodes(nodes);
			
			return flow;
		} catch (DocumentException e) {
			e.printStackTrace();
		}
		return null;
	}

	private static List<Node> toNodeList(Element element) {
		List<Node> nodes = new ArrayList<Node>();
		Element startElements = element.element("start");
		if(null == startElements) {
			return nodes;
		}
		String toName = startElements.element("transition").attributeValue("to");
		
		List<Element> taskElements = element.elements("task");
		for(Element taskElement:taskElements) {
			if(toName.equals(taskElement.attributeValue("name"))){
				taskElements.remove(taskElement);
				
				loopNodes(taskElements,nodes,taskElement);
				break;
			}
		}
		
		return nodes;
	}
	
	
	private static void loopNodes(List<Element> taskElements, List<Node> nodes,Element element) {
		String toName = element.element("transition").attributeValue("to");
		
		Node node = new Node();
		Item item = new Item();
		item.setOrders(nodes.size()+1);
		if(StringUtils.isNotBlank(element.attributeValue("assignee"))) {
			item.setMan(element.attributeValue("assigneeDisplay"));
			item.setManid(element.attributeValue("assignee"));
		}
		item.setHandlemode("1");
		item.setRoleid(element.attributeValue("form"));
		item.setRolename(element.attributeValue("displayName"));
		node.setItem(item);
		node.setOrders(nodes.size()+1);
		nodes.add(node);
		
		if(!"end".equals(toName)) {
			for(Element taskElement:taskElements) {
				if(toName.equals(taskElement.attributeValue("name"))){
					taskElements.remove(taskElement);
					
					loopNodes(taskElements, nodes,taskElement);
					break;
				}
			}
		}
	}

}
