package com.ejianc.integration.sdbjmaterial.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 领料出库子表
 *
 * @author generator
 *
 */
@TableName("out_store_detail")
public class OutstoreDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="model")
    private String model; // 规格型号
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="price")
    private BigDecimal price; // 单价/租赁单价
    @TableField(value="out_num")
    private BigDecimal outNum; // 申请数量/出库数量
    @TableField(value="amount")
    private BigDecimal amount; // 金额
    @TableField(value="adjust_num")
    private BigDecimal adjustNum; // 调差额
    @TableField(value="user_for")
    private String useFor; // 用途
    @TableField(value="now_store_amount")
    private BigDecimal nowStoreAmount; // 当前库存金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="pid")
    private Long pid; // 主表id
    @TableField(value="lease_back_date")
    private java.util.Date leaseBackDate; // 租赁交回时间
    @TableField(value="lease_id")
    private Long leaseId; // 租赁单位Id
    @TableField(value="lease_unit")
    private String leaseUnit; // 租赁单位名称
    @TableField(value="allo_adjust_num")
    private BigDecimal alloAdjustNum; // 调拨调差额
    @TableField(value="origin_adjust_num")
    private BigDecimal originAdjustNum; // 原调差额
    @TableField(value="allo_amount")
    private BigDecimal alloAmount; // 调拨额
    @TableField(value="origin_amount")
    private BigDecimal originAmount; // 原金额
    @TableField(value="allo_num")
    private BigDecimal alloNum; // 调拨量
    @TableField(value="allo_price")
    private BigDecimal alloPrice; // 调拨价
    @TableField(value="store_num")
    private BigDecimal storeNum; // 库存量
    @TableField(value="origin_price")
    private BigDecimal originPrice; // 原单价(入库单单价)
    @TableField(value="eprjname")
    private String eprjname; // 安全费用项目名称
    @TableField(value="eprjid")
    private String eprjid; // 安全费用项目id

    public String getEprjname() {
        return eprjname;
    }

    public void setEprjname(String eprjname) {
        this.eprjname = eprjname;
    }

    public String getEprjid() {
        return eprjid;
    }

    public void setEprjid(String eprjid) {
        this.eprjid = eprjid;
    }

    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 规格型号
     */
    public String getModel() {
        return model;
    }

    /**
     * 规格型号
     */
    public void setModel(String model) {
        this.model = model;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单价/租赁单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价/租赁单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 申请数量/出库数量
     */
    public BigDecimal getOutNum() {
        return outNum;
    }

    /**
     * 申请数量/出库数量
     */
    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }
    /**
     * 金额
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * 金额
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    /**
     * 调差额
     */
    public BigDecimal getAdjustNum() {
        return adjustNum;
    }

    /**
     * 调差额
     */
    public void setAdjustNum(BigDecimal adjustNum) {
        this.adjustNum = adjustNum;
    }
    /**
     * 用途
     */
    public String getUseFor() {
        return useFor;
    }

    /**
     * 用途
     */
    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }
    /**
     * 当前库存金额
     */
    public BigDecimal getNowStoreAmount() {
        return nowStoreAmount;
    }

    /**
     * 当前库存金额
     */
    public void setNowStoreAmount(BigDecimal nowStoreAmount) {
        this.nowStoreAmount = nowStoreAmount;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    /**
     * 租赁交回时间
     */
    public java.util.Date getLeaseBackDate() {
        return leaseBackDate;
    }

    /**
     * 租赁交回时间
     */
    public void setLeaseBackDate(java.util.Date leaseBackDate) {
        this.leaseBackDate = leaseBackDate;
    }
    /**
     * 租赁单位Id
     */
    public Long getLeaseId() {
        return leaseId;
    }

    /**
     * 租赁单位Id
     */
    public void setLeaseId(Long leaseId) {
        this.leaseId = leaseId;
    }
    /**
     * 租赁单位名称
     */
    public String getLeaseUnit() {
        return leaseUnit;
    }

    /**
     * 租赁单位名称
     */
    public void setLeaseUnit(String leaseUnit) {
        this.leaseUnit = leaseUnit;
    }
    /**
     * 调拨调差额
     */
    public BigDecimal getAlloAdjustNum() {
        return alloAdjustNum;
    }

    /**
     * 调拨调差额
     */
    public void setAlloAdjustNum(BigDecimal alloAdjustNum) {
        this.alloAdjustNum = alloAdjustNum;
    }
    /**
     * 原调差额
     */
    public BigDecimal getOriginAdjustNum() {
        return originAdjustNum;
    }

    /**
     * 原调差额
     */
    public void setOriginAdjustNum(BigDecimal originAdjustNum) {
        this.originAdjustNum = originAdjustNum;
    }
    /**
     * 调拨额
     */
    public BigDecimal getAlloAmount() {
        return alloAmount;
    }

    /**
     * 调拨额
     */
    public void setAlloAmount(BigDecimal alloAmount) {
        this.alloAmount = alloAmount;
    }
    /**
     * 原金额
     */
    public BigDecimal getOriginAmount() {
        return originAmount;
    }

    /**
     * 原金额
     */
    public void setOriginAmount(BigDecimal originAmount) {
        this.originAmount = originAmount;
    }
    /**
     * 调拨量
     */
    public BigDecimal getAlloNum() {
        return alloNum;
    }

    /**
     * 调拨量
     */
    public void setAlloNum(BigDecimal alloNum) {
        this.alloNum = alloNum;
    }
    /**
     * 调拨价
     */
    public BigDecimal getAlloPrice() {
        return alloPrice;
    }

    /**
     * 调拨价
     */
    public void setAlloPrice(BigDecimal alloPrice) {
        this.alloPrice = alloPrice;
    }
    /**
     * 库存量
     */
    public BigDecimal getStoreNum() {
        return storeNum;
    }

    /**
     * 库存量
     */
    public void setStoreNum(BigDecimal storeNum) {
        this.storeNum = storeNum;
    }
    /**
     * 原单价(入库单单价)
     */
    public BigDecimal getOriginPrice() {
        return originPrice;
    }

    /**
     * 原单价(入库单单价)
     */
    public void setOriginPrice(BigDecimal originPrice) {
        this.originPrice = originPrice;
    }

}
