package com.ejianc.integration.sdbjmaterial.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 领料出库实体
 *
 * @author generator
 *
 */
@TableName("out_store")
public class OutstoreEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="engineering")
    private String engineering; // 工程名称
    @TableField(value="project_manager")
    private String projectManager; // 项目经理
    @TableField(value="project_address")
    private String projectAddress; // 项目地址
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="sub_contract_id")
    private String subContractId; // 分包合同id
    @TableField(value="sub_contract_name")
    private String subContractName; // 分包合同名称
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="main_contract_id")
    private String mainContractId; // 主合同id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_id")
    private String projectId; // 项目id
    @TableField(value="project_source_id")
    private String projectSourceId; // 八局项目id
    @TableField(value="dev_project_name")
    private String devProjectName; // 研发项目名称
    @TableField(value="dev_project_id")
    private String devProjectId; // 研发项目id
    @TableField(value="out_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date outDate; // 出库日期
    @TableField(value="sender_id")
    private String senderId; // 发料人id
    @TableField(value="sender")
    private String sender; // 发料人
    @TableField(value="other_side_processor")
    private String otherSideProcessor; // 对方经办人
    @TableField(value="total_amount")
    private BigDecimal totalAmount; // 出库金额
    @TableField(value="allocation_in_unit_name")
    private String allocationInUnitName; // 调入单位名称
    @TableField(value="allocation_in_unit_id")
    private String allocationInUnitId; // 调入单位id
    @TableField(value="allocation_in_unit_type")
    private String allocationInUnitType; // 调入单位类型
    @TableField(value="out_type_name")
    private String outTypeName; // 出库单l类别名称
    @TableField(value="out_type")
    private String outType; // 出库单类别  6:自购消耗材,2:自购周转材,4:租赁周转材,9:零星采购,8:调拨,1:甲供材
    @TableField(value="name")
    private String name; // 出库单名称
    @TableField(value="bill_code")
    private String billCode; // 出库单编号
    @TableField(value="use_for_name")
    private String useForName; // 出库用途 1:'科研支出',3:'安全支出',2:'其他'
    @TableField(value="use_for")
    private String useFor; // 出库用途 1:'科研支出',3:'安全支出',2:'其他'
    @TableField(value="warehouse_id")
    private String warehouseId; // 仓库id
    @TableField(value="warehouse_name")
    private String warehouseName; // 仓库名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 自由态：0；审批中：1；审批通过：2；
    @TableField(value="opid")
    private String opid; // 八局单据id
    @TableField(value="processid")
    private String processid; // 八局 提交流程id


    @TableField(exist=false)
    @SubEntity(serviceName="outstoreDetailService")
    private List<OutstoreDetailEntity> outstoreDetailEntities = new ArrayList<>(); // 领料出库子表

    public String getOpid() {
        return opid;
    }

    public void setOpid(String opid) {
        this.opid = opid;
    }

    public String getProcessid() {
        return processid;
    }

    public void setProcessid(String processid) {
        this.processid = processid;
    }

    public String getAllocationInUnitType() {
        return allocationInUnitType;
    }

    public void setAllocationInUnitType(String allocationInUnitType) {
        this.allocationInUnitType = allocationInUnitType;
    }

    public String getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getUseForName() {
        return useForName;
    }

    public void setUseForName(String useForName) {
        this.useForName = useForName;
    }

    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }

    /**
     * 工程名称
     */
    public String getEngineering() {
        return engineering;
    }

    /**
     * 工程名称
     */
    public void setEngineering(String engineering) {
        this.engineering = engineering;
    }
    /**
     * 项目经理
     */
    public String getProjectManager() {
        return projectManager;
    }

    /**
     * 项目经理
     */
    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    /**
     * 项目地址
     */
    public String getProjectAddress() {
        return projectAddress;
    }

    /**
     * 项目地址
     */
    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 分包合同id
     */
    public String getSubContractId() {
        return subContractId;
    }

    /**
     * 分包合同id
     */
    public void setSubContractId(String subContractId) {
        this.subContractId = subContractId;
    }
    /**
     * 分包合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 分包合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同id
     */
    public String getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同id
     */
    public void setMainContractId(String mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目id
     */
    public String getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    /**
     * 出库日期
     */
    public java.util.Date getOutDate() {
        return outDate;
    }

    /**
     * 出库日期
     */
    public void setOutDate(java.util.Date outDate) {
        this.outDate = outDate;
    }
    /**
     * 发料人id
     */
    public String getSenderId() {
        return senderId;
    }

    /**
     * 发料人id
     */
    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }
    /**
     * 发料人
     */
    public String getSender() {
        return sender;
    }

    /**
     * 发料人
     */
    public void setSender(String sender) {
        this.sender = sender;
    }
    /**
     * 对方经办人
     */
    public String getOtherSideProcessor() {
        return otherSideProcessor;
    }

    /**
     * 对方经办人
     */
    public void setOtherSideProcessor(String otherSideProcessor) {
        this.otherSideProcessor = otherSideProcessor;
    }
    /**
     * 出库金额
     */
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    /**
     * 出库金额
     */
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    /**
     * 调入单位名称
     */
    public String getAllocationInUnitName() {
        return allocationInUnitName;
    }

    /**
     * 调入单位名称
     */
    public void setAllocationInUnitName(String allocationInUnitName) {
        this.allocationInUnitName = allocationInUnitName;
    }
    /**
     * 调入单位id
     */
    public String getAllocationInUnitId() {
        return allocationInUnitId;
    }

    /**
     * 调入单位id
     */
    public void setAllocationInUnitId(String allocationInUnitId) {
        this.allocationInUnitId = allocationInUnitId;
    }
    /**
     * 出库单l类别名称
     */
    public String getOutTypeName() {
        return outTypeName;
    }

    /**
     * 出库单l类别名称
     */
    public void setOutTypeName(String outTypeName) {
        this.outTypeName = outTypeName;
    }
    /**
     * 出库单l类别
     */
    public String getOutType() {
        return outType;
    }

    /**
     * 出库单l类别
     */
    public void setOutType(String outType) {
        this.outType = outType;
    }
    /**
     * 出库单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 出库单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 出库单编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 出库单编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 领料出库子表
     */
    public List<OutstoreDetailEntity> getOutstoreDetailEntities() {
        return outstoreDetailEntities;
    }

    /**
     * 领料出库子表
     */
    public void setOutstoreDetailEntities(List<OutstoreDetailEntity> outstoreDetailEntities) {
        this.outstoreDetailEntities = outstoreDetailEntities;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public String getDevProjectName() {
        return devProjectName;
    }

    public void setDevProjectName(String devProjectName) {
        this.devProjectName = devProjectName;
    }

    public String getDevProjectId() {
        return devProjectId;
    }

    public void setDevProjectId(String devProjectId) {
        this.devProjectId = devProjectId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
