package com.ejianc.integration.sdbjmaterial.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.google.common.collect.Maps;
import groovy.util.logging.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 测试
 * </p>
 *
 * @author yqls
 * @since 2020-08-17
 */
@Slf4j
public class Test {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final static String SDBJ_SERVER_URL = "https://pm.baju.com.cn/";
    private final static String APPID = "yql001";
    private final static String ACCESS_TOKEN_URL = "slsd8j/openapi/Auth_getAccessToken.action";
    private final static String MATERIAL_BY_DETAIL_ID_URL = "slsd8j/openapi/MaterialOut_getMaterialByDetailId.action";

    /** 模拟本地缓存 */
    private static final Map<String, String> localCache = Maps.newConcurrentMap();

    public static void main(String[] args) {
        try {
            Test test = new Test();
            /** 根据扫码以后获取到的入库明细ID，获取相关库存信息 */
            test.getMaterialByDetailId();

        } catch (Exception e) {
            //执行失败
            System.out.println(e);
        }
    }

    private CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        JSONObject resp = new JSONObject();

        JSONObject accessToken = getSDBJAccessToken();
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken.get("token").toString());
        String newUrl = SDBJ_SERVER_URL+url;
        String reqResp =  HttpTookit.get(newUrl, params, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", newUrl, JSON.toJSONString(params), headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(BooleanUtils.isNotTrue(jsonData.getBoolean("success"))) {
            return CommonResponse.error(null != jsonData.get("message") ? jsonData.get("message").toString() : "查询失败！");
        }
        return CommonResponse.success(jsonData);
    }

    /**
     * 获取水电八局服务访问Token
     *
     * @return success: Boolean,服务响应结果编码；
     *         message: String, 服务响应结果信息；
     *         data: {access_token：String，平台服务访问密钥；invalidate: DateTime，过期时间}
     */
    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String reqUrl = SDBJ_SERVER_URL + ACCESS_TOKEN_URL;

        String tokenInfo = localCache.get("access_token");
        if(StringUtils.isNotBlank(tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject(tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get("invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if(invalidateTime > curTime) {
                return tokenData;
            }
        }

        Map<String, Object> params = new HashMap<>(2);
        params.put("appId", APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader(reqUrl, params);
            logger.info("获取水电八局服务访问Token服务-[地址：{}, 参数：{}]，返回结果：{}", reqUrl, JSONObject.toJSONString(params), reqRespStr);

            JSONObject reqResp = JSONObject.parseObject(reqRespStr);
            if(BooleanUtils.isNotTrue((Boolean) reqResp.get("success"))) {
                logger.error(null != reqResp.get("message") ? reqResp.get("message").toString() : "获取水电八局服务请求Token失败！");
                return null;
            }

            Map<String, Object> tokenData = (Map<String, Object>) reqResp.get("data");
            JSONObject invalidateInfo = (JSONObject) tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get("time").toString());

            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", invalidateTime);

            //放入缓存，有效时间1小时
            localCache.put("access_token", JSONObject.toJSONString(resp));

            return resp;
        } catch (Exception e) {
            logger.error("请求水电八局服务访问Token异常, ", e);
            return null;
        }
    }

    /**
     * 根据扫码以后获取到的入库明细ID，获取相关库存信息
     *
     * @throws Exception
     */
    private void getMaterialByDetailId() throws Exception {
        Map<String, Object> params = new HashMap<>(2);
        params.put("indetailid", "402847888ca07deb018ca4c3f7ef37e1");
        params.put("intype", "8");

        CommonResponse<JSONObject> response = this.sendGetReq(MATERIAL_BY_DETAIL_ID_URL, params);
        if(!response.isSuccess()){
            logger.error(response.getMsg());
            return;
        }
        JSONObject back = new JSONObject();
        JSONArray list = response.getData().getJSONObject("data").getJSONArray("list");
        if(list!=null && list.size()>0 ){
            back = list.getJSONObject(0);
        }
        logger.info("---根据扫码以后获取到的入库明细ID，获取相关库存信息，请求成功！data = " + JSONObject.toJSONString(back) + "  ------------");
    }
}