/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.integration.sdbjmaterial.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.integration.sdbjmaterial.bean.OutstoreDetailEntity;
import com.ejianc.integration.sdbjmaterial.bean.OutstoreEntity;
import com.ejianc.integration.sdbjmaterial.controller.TestData;
import com.ejianc.integration.sdbjmaterial.service.IOutstoreService;
import com.ejianc.integration.sdbjmaterial.util.XmlUtils;
import com.ejianc.integration.sdbjmaterial.vo.OutstoreVO;
import com.ejianc.integration.sdbjmaterial.workflow.Flow;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outStore/"})
public class OutstoreController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String SDBJ_CACHE_KEY_PREFIX = "SDBJ::";
    private static final String BILL_CODE = "SDBJ_MATERIAL_OUT";
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${sdbj.serverUrl}")
    private String SDBJ_SERVER_URL;
    @Value(value="${sdbj.appid}")
    private String APPID;
    @Value(value="${sdbj.accessTokenUrl}")
    private String ACCESS_TOKEN_URL;
    @Value(value="${sdbj.materialWareHouseListUrl}")
    private String MATERIAL_WARE_HOUSE_LIST_URL;
    @Value(value="${sdbj.contactUnitListUrl}")
    private String CONTACT_UNIT_LIST_URL;
    @Value(value="${sdbj.materialContactListUrl}")
    private String MATERIAL_CONTACT_LIST_URL;
    @Value(value="${sdbj.contractListUrl}")
    private String CONTRACT_LIST_URL;
    @Value(value="${sdbj.employeeListUrl}")
    private String EMPLOYEE_LIST_URL;
    @Value(value="${sdbj.subContractListUrl}")
    private String SUB_CONTRACT_LIST_URL;
    @Value(value="${sdbj.securityCostsList}")
    private String SECURITY_COSTS_LIST_URL;
    @Value(value="${sdbj.greenDreamProjectList}")
    private String GREEN_DREAM_PROJECT_LIST_URL;
    @Value(value="${sdbj.inventoryList}")
    private String INVENTORY_LIST_URL;
    @Value(value="${sdbj.processTemplateList}")
    private String PROCESS_TEMPLATE_LIST_URL;
    @Value(value="${sdbj.flowEmployeeList}")
    private String FLOW_EMPLOYEE_LIST_URL;
    @Value(value="${sdbj.submitProcessUrl}")
    private String SUB_PROCESS_URL;
    @Value(value="${sdbj.pmSubjectListUrl}")
    private String PM_SUBJECT_LIST_URL;
    @Value(value="${sdbj.materialByDetailIdUrl}")
    private String MATERIAL_BY_DETAIL_ID_URL;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOutstoreService service;
    @Autowired
    private IEmployeeApi employeeApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutstoreVO> saveOrUpdate(@RequestBody OutstoreVO saveorUpdateVO) {
        OutstoreEntity entity = (OutstoreEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), OutstoreEntity.class));
        boolean isNew = false;
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            isNew = true;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("warehouseId", new Parameter("eq", (Object)entity.getWarehouseId()));
        param.getParams().put("billState", new Parameter("in", (Object)"0,1"));
        List exist = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)exist)) {
            if (isNew || exist.size() > 1) {
                throw new BusinessException("\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u5355\u636e\uff0c\u65e0\u6cd5\u4fdd\u5b58\u65b0\u5355\u636e\uff01");
            }
            if (!Objects.equals(((OutstoreEntity)((Object)exist.get(0))).getId(), entity.getId())) {
                throw new BusinessException("\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u5355\u636e\uff0c\u65e0\u6cd5\u4fdd\u5b58\u65b0\u5355\u636e\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutstoreVO vo = (OutstoreVO)((Object)BeanMapper.map((Object)((Object)entity), OutstoreVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutstoreVO> queryDetail(Long id) {
        OutstoreEntity entity = (OutstoreEntity)((Object)this.service.selectById(id));
        OutstoreVO vo = (OutstoreVO)((Object)BeanMapper.map((Object)((Object)entity), OutstoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutstoreVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutstoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("allocationInUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutstoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String key = "SDBJ::ACCESS_TOKEN";
        String reqUrl = this.SDBJ_SERVER_URL + this.ACCESS_TOKEN_URL;
        String tokenInfo = (String)((Object)this.cacheManager.get(key));
        if (StringUtils.isNotBlank((CharSequence)tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject((String)tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get((Object)"invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if (invalidateTime > curTime) {
                return tokenData;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("appId", this.APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader((String)reqUrl, params);
            this.logger.info("\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u670d\u52a1-[\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}]\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(params), reqRespStr});
            JSONObject reqResp = JSONObject.parseObject((String)reqRespStr);
            if (BooleanUtils.isNotTrue((Boolean)((Boolean)reqResp.get((Object)"success")))) {
                this.logger.error(null != reqResp.get((Object)"message") ? reqResp.get((Object)"message").toString() : "\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bf7\u6c42Token\u5931\u8d25\uff01");
                return null;
            }
            Map tokenData = (Map)reqResp.get((Object)"data");
            JSONObject invalidateInfo = (JSONObject)tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get((Object)"time").toString());
            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", (Object)invalidateTime);
            this.cacheManager.setex(key, (Serializable)((Object)JSONObject.toJSONString((Object)resp)), 3000);
            return resp;
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u5f02\u5e38, ", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"/refWarehouseListData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> refWarehouseListData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText) {
        JSONObject con;
        String projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotEmpty((CharSequence)(con = JSON.parseObject((String)condition)).getString("projectId"))) {
            projectId = con.getString("projectId");
        }
        if (StringUtils.isEmpty(projectId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u4ed3\u5e93\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.equals("devTestProject001", projectId)) {
            JSONArray page = JSONArray.parseArray((String)TestData.getWarehouseTestData());
            Page pageData = new Page(1L, page.size() == 0 ? 10L : (long)page.size(), (long)page.size());
            ArrayList<JSONObject> records = new ArrayList<JSONObject>();
            for (int i = 0; i < page.size(); ++i) {
                records.add(page.getJSONObject(i));
            }
            pageData.setRecords(records);
            return CommonResponse.success((Object)pageData);
        }
        CommonResponse<JSONObject> response = this.getMaterialWarehouseList(projectId);
        if (response.isSuccess()) {
            JSONObject object = (JSONObject)response.getData();
            JSONArray page = object.getJSONArray("list");
            Page pageData = new Page(1L, page.size() == 0 ? 10L : (long)page.size(), (long)page.size());
            ArrayList<JSONObject> records = new ArrayList<JSONObject>();
            for (int i = 0; i < page.size(); ++i) {
                records.add(page.getJSONObject(i));
            }
            pageData.setRecords(records);
            return CommonResponse.success((Object)pageData);
        }
        return CommonResponse.error((String)response.getMsg());
    }

    @GetMapping(value={"materialWarehouseList"})
    public CommonResponse<JSONObject> getMaterialWarehouseList(@RequestParam(value="projectId") String projectId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("prjid", projectId);
            CommonResponse<JSONObject> response = this.sendGetReq(this.MATERIAL_WARE_HOUSE_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject back = new JSONObject();
                back.put("list", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)back);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7269\u8d44\u4ed3\u5e93\u5217\u8868\u5f02\u5e38, ", (Throwable)e);
            return CommonResponse.error((String)"\u67e5\u8be2\u7269\u8d44\u4ed3\u5e93\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    @GetMapping(value={"contactUnitList"})
    public CommonResponse<JSONObject> getContactUnitList(@RequestParam(value="projectId") String projectId, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="type") String type, @RequestParam(value="pageIndex") int pageIndex, @RequestParam(value="pageSize") int pageSize) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("prjid", projectId);
            params.put("type", type);
            params.put("querypram", searchText);
            params.put("pageindex", pageIndex);
            params.put("pagesize", pageSize);
            CommonResponse<JSONObject> response = this.sendGetReq(this.CONTACT_UNIT_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject page = new JSONObject();
                page.put("current", (Object)pageIndex);
                if (Objects.equals("3", type)) {
                    page.put("pages", (Object)1);
                } else {
                    page.put("pages", (Object)(((JSONObject)response.getData()).getJSONObject("data").getInteger("count") / pageSize + 1));
                }
                page.put("total", (Object)((JSONObject)response.getData()).getJSONObject("data").getInteger("count"));
                page.put("records", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)page);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f80\u6765\u5355\u4f4d\u4fe1\u606f\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u5f80\u6765\u5355\u4f4d\u4fe1\u606f\u5217\u8868\u5931\u8d25!");
        }
    }

    @GetMapping(value={"contractList"})
    public CommonResponse<JSONObject> getContractList(@RequestParam(value="projectId") String projectId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("prjid", projectId);
            CommonResponse<JSONObject> response = this.sendGetReq(this.CONTRACT_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject back = new JSONObject();
                back.put("list", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)back);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u76ee\u4e3b\u5408\u540c\u4fe1\u606f\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u76ee\u4e3b\u5408\u540c\u4fe1\u606f\u5217\u8868\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/refContractListData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refContractListData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText) {
        String projectId = null;
        String contracttype = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject con = JSON.parseObject((String)condition);
            if (StringUtils.isNotEmpty((CharSequence)con.getString("projectId"))) {
                projectId = con.getString("projectId");
            }
            if (StringUtils.isNotEmpty((CharSequence)con.getString("contracttype"))) {
                contracttype = con.getString("contracttype");
            }
        }
        if (StringUtils.isEmpty(projectId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u7269\u8d44\u5408\u540c\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.equals("devTestProject001", projectId)) {
            JSONObject page = new JSONObject();
            page.put("current", (Object)pageNumber);
            page.put("size", (Object)pageSize);
            page.put("total", (Object)10);
            page.put("pages", (Object)1);
            page.put("records", (Object)JSONArray.parseArray((String)TestData.getContractTestData()));
            return CommonResponse.success((Object)page);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        if (StringUtils.isNotEmpty(contracttype)) {
            params.put("contracttype", contracttype);
        }
        params.put("prjid", projectId);
        params.put("querypram", searchText);
        params.put("pageindex", pageNumber);
        params.put("pagesize", pageSize);
        CommonResponse<JSONObject> response = null;
        try {
            response = this.sendGetReq(this.MATERIAL_CONTACT_LIST_URL, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u7269\u8d44\u5408\u540c\u53c2\u7167\u5931\u8d25");
        }
        if (response.isSuccess()) {
            JSONObject page = new JSONObject();
            page.put("current", (Object)pageNumber);
            page.put("size", (Object)pageSize);
            page.put("total", (Object)((JSONObject)response.getData()).getJSONObject("data").getInteger("count"));
            page.put("pages", (Object)(((JSONObject)response.getData()).getJSONObject("data").getInteger("count") / pageSize + 1));
            page.put("records", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
            return CommonResponse.success((Object)page);
        }
        return CommonResponse.error((String)response.getMsg());
    }

    @GetMapping(value={"employeeList"})
    public CommonResponse<JSONObject> getEmployeeList(@RequestParam(value="projectId") String projectId, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="pageIndex") int pageIndex, @RequestParam(value="pageSize") int pageSize) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("prjid", projectId);
            params.put("querypram", searchText);
            params.put("pageindex", pageIndex);
            params.put("pagesize", pageSize);
            CommonResponse<JSONObject> response = this.sendGetReq(this.EMPLOYEE_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject page = new JSONObject();
                page.put("current", (Object)pageIndex);
                page.put("pages", (Object)(((JSONObject)response.getData()).getJSONObject("data").getInteger("count") / pageSize + 1));
                page.put("total", (Object)((JSONObject)response.getData()).getJSONObject("data").getInteger("count"));
                page.put("records", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)page);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u9a8c\u6536\u4eba\u5458\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u9a8c\u6536\u4eba\u5458\u5217\u8868\u5931\u8d25!");
        }
    }

    @GetMapping(value={"subContractList"})
    public CommonResponse<JSONObject> getSubContractList(@RequestParam(value="projectId") String projectId, @RequestParam(value="subContractorId") String subContractorId, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="pageIndex") int pageIndex, @RequestParam(value="pageSize") int pageSize) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("prjid", projectId);
            params.put("fbsid", subContractorId);
            params.put("querypram", searchText);
            params.put("pageindex", pageIndex);
            params.put("pagesize", pageSize);
            CommonResponse<JSONObject> response = this.sendGetReq(this.SUB_CONTRACT_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject page = new JSONObject();
                page.put("current", (Object)pageIndex);
                page.put("pages", (Object)(((JSONObject)response.getData()).getJSONObject("data").getInteger("count") / pageSize + 1));
                page.put("total", (Object)((JSONObject)response.getData()).getJSONObject("data").getInteger("count"));
                page.put("records", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)page);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5206\u5305\u5408\u540c\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u5206\u5305\u5408\u540c\u5217\u8868\u5931\u8d25!");
        }
    }

    @GetMapping(value={"securityCostsList"})
    public CommonResponse<JSONObject> getSecurityCostsList(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="pageIndex") int pageIndex, @RequestParam(value="pageSize") int pageSize) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(6);
            params.put("pageindex", pageIndex);
            params.put("querypram", searchText);
            params.put("pagesize", pageSize);
            CommonResponse<JSONObject> response = this.sendGetReq(this.SECURITY_COSTS_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject page = new JSONObject();
                page.put("current", (Object)pageIndex);
                page.put("pages", (Object)(((JSONObject)response.getData()).getJSONObject("data").getInteger("count") / pageSize + 1));
                page.put("total", (Object)((JSONObject)response.getData()).getJSONObject("data").getInteger("count"));
                page.put("records", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)page);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5b89\u5168\u8d39\u7528\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u5b89\u5168\u8d39\u7528\u5217\u8868\u5931\u8d25!");
        }
    }

    @GetMapping(value={"greenDreamProjectList"})
    public CommonResponse<JSONObject> getGreenDreamProjectList(@RequestParam(value="contractId") String contractId, @RequestParam(value="pageIndex") int pageIndex, @RequestParam(value="pageSize") int pageSize) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(6);
            params.put("zhtid", contractId);
            params.put("pagesize", pageSize);
            params.put("pageindex", pageIndex);
            CommonResponse<JSONObject> response = this.sendGetReq(this.GREEN_DREAM_PROJECT_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject page = new JSONObject();
                page.put("pages", (Object)(((JSONObject)response.getData()).getJSONObject("data").getInteger("count") / pageSize + 1));
                page.put("current", (Object)pageIndex);
                page.put("total", (Object)((JSONObject)response.getData()).getJSONObject("data").getInteger("count"));
                page.put("records", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)page);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7814\u53d1\u9879\u76ee\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u7814\u53d1\u9879\u76ee\u5217\u8868\u5931\u8d25!");
        }
    }

    @GetMapping(value={"inventoryList"})
    public CommonResponse<JSONObject> getInventoryList(@RequestParam(value="type") String type, @RequestParam(value="warehouseId") String warehouseId, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="reportDate") String reportDate, @RequestParam(value="contractId", required=false) String contractId, @RequestParam(value="pageIndex") int pageIndex, @RequestParam(value="pageSize") int pageSize) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("intype", type);
            params.put("storehouseid", warehouseId);
            params.put("querypram", searchText);
            params.put("reportdate", reportDate);
            params.put("conid", contractId);
            params.put("pageindex", pageIndex);
            params.put("pagesize", pageSize);
            CommonResponse<JSONObject> response = this.sendGetReq(this.INVENTORY_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject page = new JSONObject();
                page.put("current", (Object)pageIndex);
                page.put("pages", (Object)(((JSONObject)response.getData()).getJSONObject("data").getInteger("count") / pageSize + 1));
                page.put("total", (Object)((JSONObject)response.getData()).getJSONObject("data").getInteger("count"));
                page.put("records", ((JSONObject)response.getData()).getJSONObject("data").get((Object)"list"));
                return CommonResponse.success((Object)page);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7269\u8d44\u5e93\u5b58\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u7269\u8d44\u5e93\u5b58\u5217\u8868\u5931\u8d25!");
        }
    }

    @GetMapping(value={"processTemplateList"})
    public CommonResponse<JSONArray> getProcessTemplateList(@RequestParam(value="projectId") String projectId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("prjid", projectId);
            CommonResponse<JSONObject> resp = this.sendGetReq(this.PROCESS_TEMPLATE_LIST_URL, params);
            JSONArray list = (JSONArray)((JSONObject)((JSONObject)resp.getData()).get((Object)"data")).get((Object)"list");
            if (!list.isEmpty()) {
                for (Object obj : list) {
                    JSONObject processTemplate = (JSONObject)obj;
                    processTemplate.put("flow", (Object)XmlUtils.parse(processTemplate.get((Object)"flowxl").toString()));
                }
            }
            return CommonResponse.success((Object)list);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6d41\u7a0b\u6a21\u677f\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u6d41\u7a0b\u6a21\u677f\u5217\u8868\u5931\u8d25!");
        }
    }

    @GetMapping(value={"flowEmployeeList"})
    public CommonResponse<JSONObject> getFlowEmployeeList(@RequestParam(value="projectId") String projectId, @RequestParam(value="roleId") String roleId, @RequestParam(value="queryParam", required=false) String queryParam, @RequestParam(value="pageIndex") int pageIndex, @RequestParam(value="pageSize") int pageSize) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("prjid", projectId);
            params.put("roleid", roleId);
            params.put("querypram", queryParam);
            params.put("pageindex", pageIndex);
            params.put("pagesize", pageSize);
            return this.sendGetReq(this.FLOW_EMPLOYEE_LIST_URL, params);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6d41\u7a0b\u8282\u70b9\u9009\u62e9\u4eba\u5458\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return CommonResponse.error((String)"\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u9009\u62e9\u4eba\u5458\u5217\u8868\u5931\u8d25!");
        }
    }

    private CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = this.getSDBJAccessToken();
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken.get((Object)"token").toString());
        String newUrl = this.SDBJ_SERVER_URL + url;
        String reqResp = HttpTookit.get((String)newUrl, params, headers, (int)10000, (int)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{newUrl, JSON.toJSONString(params), headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (BooleanUtils.isNotTrue((Boolean)jsonData.getBoolean("success"))) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"message") ? jsonData.get((Object)"message").toString() : "\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }

    private CommonResponse<JSONObject> sendPostReq(String url, String paramJson) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = this.getSDBJAccessToken();
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken.get((Object)"token").toString());
        String newUrl = this.SDBJ_SERVER_URL + url;
        String reqResp = HttpTookit.postByJson((String)newUrl, (String)paramJson, headers, (Integer)10000, (Integer)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{newUrl, paramJson, headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (BooleanUtils.isNotTrue((Boolean)jsonData.getBoolean("success"))) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"message") ? jsonData.get((Object)"message").toString() : "\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData.getJSONObject("data"));
    }

    @GetMapping(value={"materialOutStoreCallBack"})
    public CommonResponse<String> materialOutStoreCallBack(@RequestParam(value="opid") String opid, @RequestParam(value="billState") Integer billState) {
        if (StringUtils.isEmpty((CharSequence)opid)) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (billState != 0 && billState != 2) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5355\u636e\u72b6\u6001\u503c\u975e\u6cd5\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("opid", new Parameter("eq", (Object)opid));
        List entities = this.service.queryList(param, false);
        if (ListUtil.isEmpty((List)entities)) {
            return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u4e1a\u52a1id\u4e3a\uff01" + opid + " \u7684\u51fa\u5e93\u5355\uff01"));
        }
        ((OutstoreEntity)((Object)entities.get(0))).setBillState(billState);
        this.service.saveOrUpdate(entities.get(0), false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"doSubmit"})
    public CommonResponse<JSONObject> doSubmit(@RequestBody String dataStr) {
        JSONObject dataObj = JSONObject.parseObject((String)dataStr);
        Long userId = (long)InvocationInfoProxy.getUserid();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OutstoreEntity entity = (OutstoreEntity)((Object)this.service.selectById(Long.valueOf(dataObj.get((Object)"dataId").toString())));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("projectid", entity.getProjectSourceId());
        data.put("storehouseid", entity.getWarehouseId());
        data.put("code", entity.getBillCode());
        data.put("name", entity.getName());
        data.put("outtype", entity.getOutType());
        data.put("receivename", entity.getAllocationInUnitId());
        data.put("receiveman", entity.getOtherSideProcessor());
        data.put("giveman", entity.getSenderId());
        data.put("givedate", sdf.format(entity.getOutDate()));
        data.put("iskey", entity.getUseFor());
        data.put("kyname", entity.getEngineering());
        data.put("maincontractid", entity.getMainContractId());
        data.put("subcontractid", entity.getSubContractId());
        data.put("GreenDreamProjectId", entity.getDevProjectId());
        data.put("subject", dataObj.get((Object)"subject"));
        data.put("templetid", dataObj.get((Object)"templateId"));
        CommonResponse employeeResp = this.employeeApi.queryEmployeByUserId(userId);
        if (!employeeResp.isSuccess()) {
            return CommonResponse.error((String)("\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25\uff0c" + employeeResp.getMsg()));
        }
        this.logger.info("******** \u6839\u636e\u7528\u6237Id{},\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u7ed3\u679c: {}  *****", (Object)userId, (Object)JSON.toJSONString((Object)employeeResp.getData()));
        if (StringUtils.isEmpty((CharSequence)((EmployeeVO)employeeResp.getData()).getSourceId())) {
            return CommonResponse.error((String)"\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25\uff1a\u6d41\u7a0b\u53d1\u8d77\u4eba\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u8d26\u53f7\u6570\u636e\u662f\u5426\u540c\u6b65\uff01");
        }
        data.put("senduserid", ((EmployeeVO)employeeResp.getData()).getSourceId());
        Flow f = (Flow)JSONObject.parseObject((String)dataObj.getString("processData"), Flow.class);
        data.put("flowxml", XmlUtils.updateProcessXml(f, dataObj.getString("templateFlowXml")));
        if (StringUtils.isNotBlank((CharSequence)entity.getOpid())) {
            data.put("opid", entity.getOpid());
        }
        List<OutstoreDetailEntity> subList = entity.getOutstoreDetailEntities();
        ArrayList subs = new ArrayList();
        if (CollectionUtils.isNotEmpty(subList)) {
            subList.stream().forEach(sub -> {
                JSONObject s = new JSONObject();
                s.put("indetailid", (Object)sub.getIndetailid());
                s.put("resourceid", (Object)sub.getMaterialId());
                s.put("price", (Object)sub.getPrice());
                s.put("remainqty", (Object)sub.getStoreNum());
                s.put("applyqty", (Object)sub.getOutNum());
                s.put("qty", (Object)sub.getOutNum());
                s.put("amount", (Object)sub.getAmount());
                s.put("chaamount", (Object)sub.getAdjustNum());
                s.put("usedepart", (Object)sub.getUseFor());
                s.put("hireunit", (Object)sub.getHireunit());
                if (null != sub.getLeaseBackDate()) {
                    s.put("enddate", (Object)sdf.format(sub.getLeaseBackDate()));
                }
                s.put("moveprice", (Object)sub.getAlloPrice());
                s.put("storeprice", (Object)sub.getOriginAmount());
                s.put("ychaamount", (Object)sub.getOriginAdjustNum());
                s.put("remark", (Object)sub.getMemo());
                subs.add(s);
            });
        }
        data.put("list", subs);
        HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>();
        param.put("data", data);
        try {
            CommonResponse<JSONObject> submitResp = this.sendPostReq(this.SUB_PROCESS_URL, JSON.toJSONString(param));
            if (!submitResp.isSuccess()) {
                return CommonResponse.error((String)("\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25\uff0c" + submitResp.getMsg()));
            }
            String opid = ((JSONObject)submitResp.getData()).get((Object)"opid").toString();
            String processid = ((JSONObject)submitResp.getData()).get((Object)"processid").toString();
            this.logger.info("\u6d41\u7a0b\u63a8\u9001\u516b\u5c40\u6210\u529f\uff0c\u66f4\u65b0\u4e1a\u52a1\u3010\u4e3b\u952e-{}\u3011,opid-{}, processid-{}", new Object[]{entity.getId(), opid, processid});
            entity.setOpid(opid);
            entity.setProcessid(processid);
            entity.setBillState(1);
            this.service.saveOrUpdate((Object)entity);
        }
        catch (Exception e) {
            this.logger.error("\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25\uff0c\u6d41\u7a0b\u63a8\u9001\u516b\u5c40\u5f02\u5e38\uff1a", (Throwable)e);
            return CommonResponse.error((String)"\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25\uff0c\u6d41\u7a0b\u63a8\u9001\u5931\u8d25!");
        }
        return CommonResponse.success((String)"\u6d41\u7a0b\u63d0\u4ea4\u6210\u529f\uff01");
    }

    @PostMapping(value={"scanQRCode"})
    @ResponseBody
    public CommonResponse<JSONObject> scanQRCode(@RequestBody JSONObject data) {
        JSONObject material;
        JSONObject res = new JSONObject();
        if (data == null) {
            return CommonResponse.error((String)"\u975e\u6cd5\u6570\u636e\uff01");
        }
        String type = data.getString("type");
        String indetailid = data.getString("indetailid");
        if (StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)indetailid)) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e0d\u5b8c\u6574\uff01");
        }
        try {
            material = this.getSingleStore(indetailid, type);
            if (material == null) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5e93\u5b58\u5931\u8d25:\u4e0d\u5b58\u5728\u76f8\u5173\u7269\u8d44\uff01");
            }
            res.put("material", (Object)material);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)("\u67e5\u8be2\u516b\u5c40\u5e93\u5b58\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getLocalizedMessage()));
        }
        material = res.getJSONObject("material");
        String projectSourceId = material.getString("projectid");
        String storehouseId = material.getString("storehouseid");
        CommonResponse projectRegisterVOCommonResponse = this.projectApi.queryProjectBySourceId(projectSourceId);
        if (!projectRegisterVOCommonResponse.isSuccess() || projectRegisterVOCommonResponse.getData() == null) {
            return CommonResponse.error((String)"\u6b64\u9879\u76ee\u4fe1\u606f\u5c1a\u672a\u540c\u6b65\uff0c\u65e0\u6cd5\u8bc6\u522b\uff01");
        }
        res.put("project", projectRegisterVOCommonResponse.getData());
        CommonResponse<JSONObject> response = this.getSingleWarehouse(storehouseId, projectSourceId);
        if (!response.isSuccess() || response.getData() == null) {
            return CommonResponse.error((String)response.getMsg());
        }
        res.put("warehouse", response.getData());
        return CommonResponse.success((Object)res);
    }

    private JSONObject getSingleStore(String indetailid, String intype) throws Exception {
        Integer count;
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("indetailid", indetailid);
        params.put("intype", intype);
        CommonResponse<JSONObject> response = this.sendGetReq(this.MATERIAL_BY_DETAIL_ID_URL, params);
        JSONObject res = null;
        if (response.isSuccess() && (count = ((JSONObject)response.getData()).getJSONObject("data").getInteger("count")) > 0) {
            JSONArray list = ((JSONObject)response.getData()).getJSONObject("data").getJSONArray("list");
            res = list.getJSONObject(0);
        }
        return res;
    }

    private JSONObject getSingleStore(String reportdate, String type, String warehouseId, String price) throws Exception {
        Integer count;
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("intype", type);
        params.put("storehouseid", warehouseId);
        params.put("reportdate", reportdate);
        params.put("price", price);
        params.put("pageindex", 1);
        params.put("pagesize", 100);
        CommonResponse<JSONObject> response = this.sendGetReq(this.INVENTORY_LIST_URL, params);
        JSONObject res = null;
        if (response.isSuccess() && (count = ((JSONObject)response.getData()).getJSONObject("data").getInteger("count")) > 0) {
            JSONArray list = ((JSONObject)response.getData()).getJSONObject("data").getJSONArray("list");
            res = list.getJSONObject(0);
        }
        return res;
    }

    public CommonResponse<JSONObject> getSingleWarehouse(String storehouseId, String projectId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("houseid", storehouseId);
            params.put("prjid", projectId);
            CommonResponse<JSONObject> response = this.sendGetReq(this.MATERIAL_WARE_HOUSE_LIST_URL, params);
            if (response.isSuccess()) {
                JSONObject back = null;
                JSONArray list = ((JSONObject)response.getData()).getJSONObject("data").getJSONArray("list");
                if (list != null && list.size() > 0) {
                    back = list.getJSONObject(0);
                }
                return CommonResponse.success(back);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7269\u8d44\u4ed3\u5e93\u5217\u8868\u5f02\u5e38, ", (Throwable)e);
            return CommonResponse.error((String)("\u67e5\u8be2\u7269\u8d44\u4ed3\u5e93\u5217\u8868\u5931\u8d25:" + e.getLocalizedMessage()));
        }
    }

    @GetMapping(value={"getLastProjectInfoByUserCode"})
    @ResponseBody
    public CommonResponse<JSONObject> getLastProjectInfoByUserCode() {
        InvocationInfoProxy.getUsercode();
        QueryParam param = new QueryParam();
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(1);
        IPage page = this.service.queryPage(param, false);
        OutstoreEntity entity = (OutstoreEntity)((Object)page.getRecords().get(0));
        if (page != null && page.getTotal() > 0L && StringUtils.isNotEmpty((CharSequence)entity.getProjectId())) {
            JSONObject project = new JSONObject();
            project.put("id", (Object)entity.getProjectId());
            project.put("sourceId", (Object)entity.getProjectSourceId());
            project.put("name", (Object)entity.getProjectName());
            project.put("code", (Object)entity.getProjectCode());
            return CommonResponse.success((Object)project);
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u9ed8\u8ba4\u9879\u76ee\uff01");
    }

    @RequestMapping(value={"/refPmSubjectListTreeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> refPmSubjectListTreeData(@RequestParam(value="projectId") String projectId) {
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u9879\u76ee\u5de5\u7a0b\u90e8\u4f4d\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("prjid", projectId);
        CommonResponse<JSONObject> response = null;
        try {
            response = this.sendGetReq(this.PM_SUBJECT_LIST_URL, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u9879\u76ee\u5de5\u7a0b\u90e8\u4f4d\u53c2\u7167\u5931\u8d25");
        }
        if (response.isSuccess()) {
            JSONObject result = (JSONObject)response.getData();
            JSONArray list = result.getJSONObject("data").getJSONArray("list");
            ArrayList resultMapList = new ArrayList();
            if (list != null) {
                list.forEach(l -> {
                    JSONObject j = (JSONObject)l;
                    j.put("parentId", (Object)j.getString("parentid"));
                    resultMapList.add(j);
                });
            }
            return CommonResponse.success((Object)ResultAsTree.createTreeData(resultMapList));
        }
        return CommonResponse.error((String)response.getMsg());
    }

    @RequestMapping(value={"/refPmSubjectListTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refPmSubjectListTree(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        JSONObject con;
        String projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotEmpty((CharSequence)(con = JSON.parseObject((String)condition)).getString("projectId"))) {
            projectId = con.getString("projectId");
        }
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("prjid", projectId);
        CommonResponse<JSONObject> response = null;
        try {
            response = this.sendGetReq(this.PM_SUBJECT_LIST_URL, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u9879\u76ee\u5de5\u7a0b\u90e8\u4f4d\u53c2\u7167\u5931\u8d25");
        }
        if (response.isSuccess()) {
            JSONObject result = (JSONObject)response.getData();
            JSONArray list = result.getJSONObject("data").getJSONArray("list");
            ArrayList resultMapList = new ArrayList();
            if (list != null) {
                list.forEach(l -> {
                    JSONObject j = (JSONObject)l;
                    j.put("parentId", (Object)j.getString("parentid"));
                    resultMapList.add(j);
                });
            }
            return ResultAsTree.createTreeData(resultMapList);
        }
        throw new BusinessException(response.getMsg());
    }
}

